/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.properties;

import com.ibm.j2c.ui.internal.messages.J2CUIMessageBundle;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.properties.TargetServerProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.FileProperty;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;

public class ConnectorImportPropertyGroup
extends BasePropertyGroup
implements IVetoableChangeListener,
IPropertyChangeListener {
    public static String CONNECTOR_IMPORT_PG_NAME = "com.ibm.j2c.ui.internal.properties.ConnectorImportPropertyGroup";
    public static String CONNECTOR_FILE_PROPERTY_NAME = "CONNECTOR_FILE";
    public static String CONNECTOR_PROJECT_NAME_PROPERTY_NAME = "PROJECT_NAME";
    FileProperty connectorFileProperty_ = null;
    BaseSingleValuedProperty connectorProjectNameProperty_ = null;
    TargetServerProperty targetServerProperty_ = null;

    public ConnectorImportPropertyGroup() throws CoreException {
        super(CONNECTOR_IMPORT_PG_NAME, J2CUIMessages.CONNECTOR_IMPORT_PG_DISPLAY_NAME, J2CUIMessages.CONNECTOR_IMPORT_PG_DESCRIPTION);
        this.connectorFileProperty_ = new FileProperty(CONNECTOR_FILE_PROPERTY_NAME, J2CUIMessages.CONNECTOR_FILE_PROPERTY_DISPLAY_NAME, J2CUIMessages.CONNECTOR_FILE_PROPERTY_DESCRIPTION, (BasePropertyGroup)this, new String[]{"rar"}, true);
        this.connectorFileProperty_.setRequired(true);
        this.connectorFileProperty_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.connectorProjectNameProperty_ = new BaseSingleValuedProperty(CONNECTOR_PROJECT_NAME_PROPERTY_NAME, J2CUIMessages.CONNECTOR_PROJECT_NAME_PROPERTY_DISPLAY_NAME, J2CUIMessages.CONNECTOR_PROJECT_NAME_PROPERTY_DESCRIPTION, String.class, (BasePropertyGroup)this);
        this.connectorProjectNameProperty_.setRequired(true);
        this.connectorProjectNameProperty_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.targetServerProperty_ = new TargetServerProperty(this);
    }

    public ConnectorImportPropertyGroup(PropertyUIMessageBundle msgBundle) throws CoreException {
        super(CONNECTOR_IMPORT_PG_NAME, msgBundle.getMessage("CONNECTOR_IMPORT_PG_DISPLAY_NAME"), msgBundle.getMessage("CONNECTOR_IMPORT_PG_DESCRIPTION"));
        this.connectorFileProperty_ = new FileProperty(CONNECTOR_FILE_PROPERTY_NAME, msgBundle.getMessage("CONNECTOR_FILE_PROPERTY_DISPLAY_NAME"), msgBundle.getMessage("CONNECTOR_FILE_PROPERTY_DESCRIPTION"), (BasePropertyGroup)this, new String[]{"rar"}, true);
        this.connectorFileProperty_.setRequired(true);
        this.connectorFileProperty_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.connectorProjectNameProperty_ = new BaseSingleValuedProperty(CONNECTOR_PROJECT_NAME_PROPERTY_NAME, msgBundle.getMessage("CONNECTOR_PROJECT_NAME_PROPERTY_DISPLAY_NAME"), msgBundle.getMessage("CONNECTOR_PROJECT_NAME_PROPERTY_DESCRIPTION"), String.class, (BasePropertyGroup)this);
        this.connectorProjectNameProperty_.setRequired(true);
        this.connectorProjectNameProperty_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.connectorProjectNameProperty_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.targetServerProperty_ = new TargetServerProperty(this, msgBundle);
        this.targetServerProperty_.addPropertyChangeListener(this);
    }

    public Object clone() throws CloneNotSupportedException {
        ConnectorImportPropertyGroup group = (ConnectorImportPropertyGroup)((Object)super.clone());
        FileProperty connectorFileProperty = (FileProperty)group.getProperty(CONNECTOR_FILE_PROPERTY_NAME);
        BaseSingleValuedProperty connectorProjectNameProperty = (BaseSingleValuedProperty)group.getProperty(CONNECTOR_PROJECT_NAME_PROPERTY_NAME);
        TargetServerProperty targetServerProperty = (TargetServerProperty)group.getProperty("TARGET_SERVER");
        group.connectorFileProperty_ = connectorFileProperty;
        group.connectorProjectNameProperty_ = connectorProjectNameProperty;
        group.targetServerProperty_ = targetServerProperty;
        connectorFileProperty.addPropertyChangeListener((IPropertyChangeListener)group);
        connectorProjectNameProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        connectorProjectNameProperty.addPropertyChangeListener((IPropertyChangeListener)group);
        targetServerProperty.addPropertyChangeListener(group);
        return group;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        String errorMsg;
        String projectName;
        if (evt.getPropertyChangeType() == 0 && evt.getSource() == this.connectorProjectNameProperty_ && (projectName = (String)evt.getNewValue()) != null && (errorMsg = this.checkConnectorProjectName(projectName)) != null) {
            throw new PropertyVetoException(errorMsg, (java.beans.PropertyChangeEvent)evt);
        }
    }

    protected String checkConnectorProjectName(String projectName) {
        if (!this.isProjectNameValid(projectName)) {
            return J2CUIMessages.ERROR_PROJECT_NAME_ALREADY_EXISTS;
        }
        String projectLoc = this.getDefaultLocation(projectName);
        if (this.isProjectOnFileSystem(projectName)) {
            J2CUIMessageBundle messageBundle = new J2CUIMessageBundle(J2CUIMessages.class);
            Object[] parms = new Object[]{projectName, projectLoc};
            return messageBundle.getMessage(J2CUIMessages.ERROR_PROJECT_ALREADY_EXISTS_ONFILESYS, parms);
        }
        return null;
    }

    private String getDefaultLocation(String projectName) {
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (projectName != null) {
            path = path.append(projectName);
        }
        if (path != null) {
            return path.toOSString();
        }
        return "";
    }

    public boolean isProjectOnFileSystem(String projectName) {
        if (projectName != null && !projectName.equals("")) {
            File dotProject;
            String projectLoc = this.getDefaultLocation(projectName);
            if (projectLoc == null) {
                return false;
            }
            File file = new File(projectLoc);
            if (file.exists() && file.isDirectory() && (dotProject = new File(file, ".project")).exists()) {
                return true;
            }
        }
        return false;
    }

    public boolean isProjectNameValid(String projectName) {
        IProject project;
        return projectName != null && !(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists();
    }

    public BaseSingleValuedProperty getConnectorFileProperty() {
        return this.connectorFileProperty_;
    }

    public BaseSingleValuedProperty getConnectorProjectNameProperty() {
        return this.connectorProjectNameProperty_;
    }

    public TargetServerProperty getTargetServerProperty() {
        return this.targetServerProperty_;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyChangeType() == 0) {
            if (evt.getSource() == this.connectorFileProperty_) {
                String projectName;
                URI fileURI = (URI)evt.getNewValue();
                fileURI = fileURI.trimFileExtension();
                String baseProjectName = projectName = fileURI.lastSegment();
                int i = 1;
                while (!this.isProjectNameValid(projectName) || this.isProjectOnFileSystem(projectName)) {
                    projectName = String.valueOf(baseProjectName) + Integer.toString(i);
                    ++i;
                }
                try {
                    this.connectorProjectNameProperty_.setValueAsString(projectName);
                }
                catch (CoreException coreException) {}
            } else if (evt.getSource() == this.targetServerProperty_) {
                String errMsg;
                String projectName = this.connectorProjectNameProperty_.getValueAsString();
                if (projectName != null && (errMsg = this.checkConnectorProjectName(projectName)) != null) {
                    this.connectorProjectNameProperty_.setValid(false, errMsg);
                }
            } else if (evt.getSource() == this.connectorProjectNameProperty_) {
                this.connectorProjectNameProperty_.setValid(true, null);
            }
        }
    }
}

