/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.model;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.model.IDeploymentMethod;
import com.ibm.j2c.ui.internal.model.IDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.model.J2CUIInfo;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class AbstractDeploymentMethod
implements IDeploymentMethod {
    protected IProject ivc;
    protected J2CServiceDescription initialOutboundServiceDescription;
    protected Vector methodNames;
    protected Vector bindingOperations;
    protected int originatingWizardType = 0;
    public static int standAloneWizardType = 1;
    public static int integratedWizardType = 0;
    protected Vector advancedProps;
    protected IProgressMonitor monitor;

    @Override
    public abstract IPropertyGroup getPropertyGroup();

    public void setOriginalProject(IProject ivc) {
        this.ivc = ivc;
    }

    public void setInitialOID(J2CServiceDescription def) {
        this.initialOutboundServiceDescription = def;
    }

    public void setWizardType(int type) {
        this.originatingWizardType = type == 1 ? 1 : 0;
    }

    public void setBindingOperations(Vector vec) {
        this.bindingOperations = vec;
    }

    @Override
    public void performBeforeFinish(J2CUIInfo uiInfo) {
    }

    @Override
    public void performBeforeFinish(J2CServiceDescription oid, IFile file) {
        IPropertyGroup ipg = this.getPropertyGroup();
        if (ipg instanceof IDeploymentPropertyGroup) {
            String sResRef = ((IDeploymentPropertyGroup)ipg).getResourceRefName();
            this.updateJNDINameTag(oid, file, sResRef);
        }
    }

    @Override
    public abstract void performOnFinish(J2CUIInfo var1);

    @Override
    public abstract void performOnFinish(J2CServiceDescription var1, IFile var2);

    @Override
    public abstract String getDeploymentPageTitle();

    @Override
    public abstract String getDeploymentPageDescription();

    @Override
    public abstract ImageDescriptor getDeploymentPageImageDescriptor();

    @Override
    public abstract ImageDescriptor getDeploymentOptionImageDescriptor(int var1);

    public abstract IFile[] getDeploymentFiles();

    public void setMethodNames(Vector methods) {
        this.methodNames = methods;
    }

    protected IFile getGeneratedFile(J2CUIInfo info) {
        IFile generatedFile = null;
        try {
            IWorkspace workspace = ResourceUtils.getWorkspace();
            IPropertyGroup writeProperties = info.writerInfo_.getWriteProperties();
            IPropertyDescriptor projectDesc = PropertyUtil.getProperty((IPropertyGroup)writeProperties, (String)"Project");
            IPropertyDescriptor bindDesc = PropertyUtil.getProperty((IPropertyGroup)writeProperties, (String)"BindingName");
            IPropertyDescriptor packDesc = PropertyUtil.getProperty((IPropertyGroup)writeProperties, (String)"PackageName");
            String sFileName = PropertyUtil.getValueAsString((IPropertyDescriptor)bindDesc);
            String packageName = PropertyUtil.getValueAsString((IPropertyDescriptor)packDesc);
            String prName = PropertyUtil.getValueAsString((IPropertyDescriptor)projectDesc);
            IProject project = workspace.getRoot().getProject(prName);
            packageName = packageName.replace('.', '/');
            IPath clientSourceFolder = ResourceUtils.getAllJavaSourceLocations((IProject)project)[0];
            if (!sFileName.endsWith(".java")) {
                sFileName = String.valueOf(sFileName) + ".java";
            }
            IPath newFpath = clientSourceFolder.append(packageName);
            newFpath = newFpath.append("/" + sFileName);
            generatedFile = workspace.getRoot().getFile(newFpath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return generatedFile;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    protected void updateJNDINameTag(J2CServiceDescription osd, IFile file, String sResourceRefName) {
        if (sResourceRefName != null && sResourceRefName.length() > 0) {
            ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
            DeploymentUtils.updateJNDIName(cu, sResourceRefName);
        } else if (osd.getJNDILookupName() != null) {
            ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
            DeploymentUtils.updateJNDIName(cu, osd.getJNDILookupName());
        }
    }
}

