/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.datastore;

import com.ibm.adapter.command.AdapterCommandTags;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.j2c.lang.ui.internal.datastore.AntFile;
import com.ibm.j2c.lang.ui.internal.model.IOMessageSubInfo;
import com.ibm.j2c.ui.core.CoreConstants;
import com.ibm.j2c.ui.core.internal.datastore.GenerateNestedDynamicProp;
import com.ibm.j2c.ui.core.internal.utilities.J2CUIPropertyUtil;
import com.ibm.j2c.ui.internal.model.BindingOperationInfo;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.common.FileProperty;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.emf.common.util.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeneratePerformImport {
    static Vector bindingopInfo_ = null;

    static boolean PerformImportUseInputAsOutput(BindingOperationInfo op) {
        return op.useInputForOutput();
    }

    static boolean PerformImportForInput(BindingOperationInfo op) {
        boolean doPerformImport = false;
        if (op.getInputMessage() != null && op.getInputMessage().getDiscoveryAgent() != null) {
            doPerformImport = true;
        }
        return doPerformImport;
    }

    static boolean PerformImportForOutput(BindingOperationInfo op) {
        boolean doPerformImport = false;
        if (op.getOutputMessage() != null && op.getOutputMessage().getDiscoveryAgent() != null) {
            doPerformImport = true;
        }
        return doPerformImport;
    }

    static Document generateInput(Document doc, Element parent, BindingOperationInfo op) {
        if (op.getInputMessage() != null) {
            FileProperty fileProp = null;
            String discoveryAgent = null;
            try {
                ArrayList files;
                IPropertyGroup fproperties = null;
                if (op.getInputMessage().getDiscoveryAgent() != null) {
                    fproperties = op.getInputMessage().getDiscoveryAgent().getInitializeProperties();
                }
                if (op.getInputMessage().getDiscoveryAgent() != null && op.getInputMessage().getDiscoveryAgent().getMetaData() != null) {
                    discoveryAgent = op.getInputMessage().getDiscoveryAgent().getMetaData().getAgentName().toString();
                }
                if ((files = J2CUIPropertyUtil.getProperties((IPropertyGroup)fproperties, (int)4)) != null && !files.isEmpty()) {
                    fileProp = (FileProperty)files.get(0);
                }
            }
            catch (Exception ex) {
                CoreConstants.dump((String)("exception:" + ex.getMessage()));
                ex.printStackTrace();
            }
            if (op.getInputMessage().getSubMessageInfo() != null && discoveryAgent != null) {
                Element perform_node = doc.createElement(AdapterCommandTags.ANT_PERFORM_IMPORT);
                perform_node.setAttribute("agent", discoveryAgent);
                int j = 0;
                while (j < op.getInputMessage().getSubMessageInfo().size()) {
                    IOMessageSubInfo subinfo = (IOMessageSubInfo)op.getInputMessage().getSubMessageInfo().get(j);
                    if (subinfo != null && subinfo.getSource() != null) {
                        Object source = subinfo.getSource();
                        Element importresourcenode = doc.createElement(AdapterCommandTags.ANT_IMPORT_RESOURCE);
                        if (source instanceof URI) {
                            URI fileuri = (URI)source;
                            if (fileProp != null) {
                                importresourcenode.setAttribute("name", fileProp.getName());
                            }
                            if (fileuri != null) {
                                importresourcenode.setAttribute("value", fileuri.toFileString());
                            }
                        } else if (source instanceof IPropertyGroup) {
                            GenerateNestedDynamicProp.generatePropertyGroups((boolean)AntFile.outputDefault_, (Document)doc, (Node)importresourcenode, (IPropertyGroup)((IPropertyGroup)source));
                        }
                        perform_node.appendChild(importresourcenode);
                    }
                    if (subinfo != null && subinfo.getQueryProperties() != null) {
                        Element querynode = doc.createElement(AdapterCommandTags.ANT_QUERY_PROPERTIES);
                        GenerateNestedDynamicProp.generatePropertyGroups((boolean)AntFile.outputDefault_, (Document)doc, (Node)querynode, (IPropertyGroup)subinfo.getQueryProperties());
                        perform_node.appendChild(querynode);
                    }
                    ++j;
                }
                Element queryResultNode = doc.createElement(AdapterCommandTags.ANT_QUERY_RESULT);
                boolean hasImportResult = false;
                int j2 = 0;
                while (j2 < op.getInputMessage().getSubMessageInfo().size()) {
                    IResultNode importRes;
                    IOMessageSubInfo subinfo = (IOMessageSubInfo)op.getInputMessage().getSubMessageInfo().get(j2);
                    Object data = subinfo.getData();
                    if (data != null && data instanceof IResultNode && (importRes = (IResultNode)data) != null) {
                        Element selectNode = doc.createElement(AdapterCommandTags.ANT_SELECT_ELEMENT);
                        selectNode.setAttribute("name", importRes.getLocation());
                        queryResultNode.appendChild(selectNode);
                        hasImportResult = true;
                    }
                    ++j2;
                }
                if (hasImportResult) {
                    perform_node.appendChild(queryResultNode);
                }
                parent.appendChild(perform_node);
            }
        }
        return doc;
    }

    static Document generateOutput(Document doc, Element parent, BindingOperationInfo op) {
        String discoveryAgent = null;
        FileProperty fileProp = null;
        String filegroup = null;
        if (op.getOutputMessage() != null) {
            if (op.getOutputMessage().getDiscoveryAgent() != null && op.getOutputMessage().getDiscoveryAgent().getMetaData() != null) {
                discoveryAgent = op.getOutputMessage().getDiscoveryAgent().getMetaData().getAgentName().toString();
            }
            if (op.getOutputMessage().getSubMessageInfo() != null && discoveryAgent != null) {
                Node perform_node = null;
                Element selectNode = null;
                Node queryResultNode = null;
                Object lastsource = null;
                Object lastqueryprop = null;
                try {
                    ArrayList files;
                    IPropertyGroup fproperties = null;
                    if (op.getOutputMessage().getDiscoveryAgent() != null) {
                        if (op.getOutputMessage().getDiscoveryAgent().getMetaData() != null) {
                            discoveryAgent = op.getOutputMessage().getDiscoveryAgent().getMetaData().getAgentName().toString();
                        }
                        if ((fproperties = op.getOutputMessage().getDiscoveryAgent().getInitializeProperties()) != null) {
                            filegroup = fproperties.getName();
                        }
                    }
                    if ((files = J2CUIPropertyUtil.getProperties(fproperties, (int)4)) != null && !files.isEmpty()) {
                        fileProp = (FileProperty)files.get(0);
                    }
                }
                catch (Exception ex) {
                    CoreConstants.dump((String)ex.getMessage());
                    ex.printStackTrace();
                }
                int j = 0;
                while (j < op.getOutputMessage().getSubMessageInfo().size()) {
                    IOMessageSubInfo subinfo = (IOMessageSubInfo)op.getOutputMessage().getSubMessageInfo().get(j);
                    if (subinfo != null && subinfo.getSource() != null) {
                        Object source = subinfo.getSource();
                        if (!source.equals(lastsource) || !lastqueryprop.equals(subinfo.getQueryProperties())) {
                            IResultNode importResO;
                            Object data;
                            lastsource = source;
                            lastqueryprop = subinfo.getQueryProperties();
                            if (queryResultNode != null && selectNode != null && perform_node != null) {
                                perform_node.appendChild(queryResultNode);
                                parent.appendChild(perform_node);
                            } else if (perform_node != null) {
                                parent.appendChild(perform_node);
                            }
                            perform_node = doc.createElement(AdapterCommandTags.ANT_PERFORM_IMPORT);
                            perform_node.setAttribute("agent", discoveryAgent);
                            Element importresourcenode = doc.createElement(AdapterCommandTags.ANT_IMPORT_RESOURCE);
                            if (source instanceof URI) {
                                URI fileuri = (URI)source;
                                if (fileProp != null) {
                                    Element thisgroup = doc.createElement(AdapterCommandTags.ANT_PROPERTY_GROUP);
                                    thisgroup.setAttribute("name", filegroup);
                                    importresourcenode.appendChild(thisgroup);
                                    Element thisfile = doc.createElement(AdapterCommandTags.ANT_PROPERTY_ELEMENT);
                                    thisfile.setAttribute("name", fileProp.getName());
                                    if (fileuri != null) {
                                        thisfile.setAttribute("value", fileuri.toFileString());
                                    }
                                    thisgroup.appendChild(thisfile);
                                }
                                queryResultNode = null;
                                selectNode = null;
                            } else if (source instanceof IPropertyGroup) {
                                GenerateNestedDynamicProp.generatePropertyGroups((boolean)AntFile.outputDefault_, (Document)doc, (Node)importresourcenode, (IPropertyGroup)((IPropertyGroup)source));
                            }
                            perform_node.appendChild(importresourcenode);
                            if (subinfo != null && subinfo.getQueryProperties() != null) {
                                Element querynode = doc.createElement(AdapterCommandTags.ANT_QUERY_PROPERTIES);
                                GenerateNestedDynamicProp.generatePropertyGroups((boolean)AntFile.outputDefault_, (Document)doc, (Node)querynode, (IPropertyGroup)subinfo.getQueryProperties());
                                perform_node.appendChild(querynode);
                            }
                            if ((data = subinfo.getData()) != null && data instanceof IResultNode && (importResO = (IResultNode)data) != null) {
                                queryResultNode = doc.createElement(AdapterCommandTags.ANT_QUERY_RESULT);
                                selectNode = doc.createElement(AdapterCommandTags.ANT_SELECT_ELEMENT);
                                selectNode.setAttribute("name", importResO.getLocation());
                                queryResultNode.appendChild(selectNode);
                            }
                        } else if (subinfo != null) {
                            IResultNode importResMPO = (IResultNode)subinfo.getData();
                            selectNode = doc.createElement(AdapterCommandTags.ANT_SELECT_ELEMENT);
                            selectNode.setAttribute("name", importResMPO.getLocation());
                            queryResultNode.appendChild(selectNode);
                        }
                    }
                    ++j;
                }
                if (queryResultNode != null && selectNode != null && perform_node != null) {
                    perform_node.appendChild(queryResultNode);
                    parent.appendChild(perform_node);
                } else if (perform_node != null) {
                    parent.appendChild(perform_node);
                }
            }
        }
        return doc;
    }
}

