/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.data;

import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.j2c.lang.ui.internal.data.J2CLanguageImportUIController;
import com.ibm.j2c.lang.ui.internal.messages.LangUIMessageBundle;
import com.ibm.j2c.lang.ui.internal.model.IOMessageInfo;
import com.ibm.j2c.lang.ui.internal.model.IOMessageSubInfo;
import com.ibm.j2c.lang.ui.internal.model.JavaMethodInfo;
import com.ibm.j2c.lang.ui.internal.model.SubMPOInfo;
import com.ibm.j2c.lang.ui.internal.wizards.J2CLanguageImportWizard_ImporterPage;
import com.ibm.j2c.lang.ui.internal.wizards.J2CLanguageImportWizard_InitPage;
import com.ibm.j2c.lang.ui.wizards.J2CLanguageImportWizard;
import com.ibm.j2c.ui.core.internal.utilities.J2CLogUtil;
import com.ibm.j2c.ui.core.internal.utilities.J2CUICoreHelper;
import com.ibm.j2c.ui.internal.model.BindingOperationInfo;
import com.ibm.j2c.ui.internal.wizards.J2CUILanguageImportWizard;
import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ITreeProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.common.CustomPropertyHelper;
import com.ibm.propertygroup.spi.common.JavaClassNameProperty;
import com.ibm.propertygroup.spi.common.JavaPackageProperty;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;

public class J2CUILanguageImportController
extends J2CLanguageImportUIController {
    protected String PACKAGE_SUFFIX = ".data";
    protected String WRAPPERCLASS_SUFFIX = "Response";
    protected J2CLanguageImportWizard wizard_;
    protected Hashtable javaClassPath_;
    protected ArrayList javaClassCheckingList_;
    protected ArrayList mpoData_;
    protected Vector existingOperations_;
    protected JavaMethodInfo currentMethod_;
    protected QName interfaceName_;
    protected String interfaceImplName_;
    protected LangUIMessageBundle messageBundle_;

    public J2CUILanguageImportController(J2CUILanguageImportWizard wizard, QName interfaceName, String interfaceImplName, Vector operations, JavaMethodInfo currentMethod, LangUIMessageBundle messageBundle) {
        this.wizard_ = wizard;
        this.interfaceName_ = interfaceName;
        this.interfaceImplName_ = interfaceImplName;
        this.existingOperations_ = operations;
        this.currentMethod_ = currentMethod;
        this.messageBundle_ = messageBundle;
        this.javaClassPath_ = new Hashtable();
    }

    public void populateDefaultValue(IPropertyGroup properties) {
        this.javaClassPath_.clear();
        this.populateJavaClassPathList(properties);
        this.presetData();
    }

    public String validateProperty(IPropertyDescriptor ipd) {
        INodeProperty root;
        String errMsg = null;
        if (PropertyHelper.isCustomProperty((IPropertyDescriptor)ipd) && CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)((ICustomProperty)ipd))) {
            if (this.javaClassPath_ != null && this.javaClassPath_.size() > 0) {
                errMsg = this.validateJavaClassNameProperty((JavaClassNameProperty)ipd);
            }
        } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)ipd) && (root = ((ITreeProperty)ipd).getRoot()) != null) {
            errMsg = this.validateNodeProperty(root);
        }
        return errMsg;
    }

    protected String validateNodeProperty(INodeProperty node) {
        String errMsg = null;
        IPropertyGroup pg = node.createConfigurationProperties();
        if (pg != null) {
            errMsg = this.validatePropertyGroup(pg);
        }
        if (errMsg != null) {
            return errMsg;
        }
        INodeProperty[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                errMsg = this.validateNodeProperty(children[i]);
                if (errMsg != null) break;
                ++i;
            }
        }
        return errMsg;
    }

    protected String validatePropertyGroup(IPropertyGroup pg) {
        String errMsg = null;
        IPropertyDescriptor[] properties = pg.getProperties();
        int i = 0;
        while (i < properties.length) {
            errMsg = PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i]) ? this.validatePropertyGroup((IPropertyGroup)properties[i]) : this.validateProperty(properties[i]);
            if (errMsg != null) break;
            ++i;
        }
        return errMsg;
    }

    protected void populateJavaClassPathList(IPropertyGroup propertyGroup) {
        if (propertyGroup == null) {
            return;
        }
        JavaProjectProperty pj = null;
        JavaPackageProperty pkg = null;
        JavaClassNameProperty file = null;
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        if (properties == null) {
            return;
        }
        ArrayList<JavaClassNameProperty> javaClasses = new ArrayList<JavaClassNameProperty>();
        int i = 0;
        while (i < properties.length) {
            IPropertyDescriptor prop = properties[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)prop)) {
                this.populateJavaClassPathList((IPropertyGroup)prop);
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)prop)) {
                this.populateJavaClassPathList(((ITreeProperty)prop).getRoot());
            } else if (PropertyHelper.isCustomProperty((IPropertyDescriptor)prop)) {
                ICustomProperty cprop = (ICustomProperty)prop;
                if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    pj = (JavaProjectProperty)prop;
                } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    pkg = (JavaPackageProperty)prop;
                } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    file = (JavaClassNameProperty)prop;
                    javaClasses.add(file);
                }
            }
            ++i;
        }
        if (pj != null && pkg != null && javaClasses.size() > 0) {
            JavaClassPath path = new JavaClassPath(pj, pkg);
            int i2 = 0;
            while (i2 < javaClasses.size()) {
                this.javaClassPath_.put(javaClasses.get(i2), path);
                ++i2;
            }
        }
    }

    protected void populateJavaClassPathList(INodeProperty node) {
        if (node == null) {
            return;
        }
        IPropertyGroup pg = node.createConfigurationProperties();
        this.populateJavaClassPathList(pg);
        INodeProperty[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.populateJavaClassPathList(children[i]);
                ++i;
            }
        }
    }

    protected void presetData() {
        String project = this.wizard_.getProjectName();
        this.mpoData_ = this.wizard_.getInitPage().getMPOData();
        int javaClassIndex = 0;
        ArrayList widgets = this.wizard_.getSavingPage().getUIWidgets();
        int i = 0;
        while (i < widgets.size()) {
            IPropertyDescriptor prop = ((PropertyUIWidget)widgets.get(i)).getProperty();
            if (PropertyHelper.isCustomProperty((IPropertyDescriptor)prop)) {
                ICustomProperty cprop = (ICustomProperty)prop;
                if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    this.setDefaultValueToProperty(cprop, project, javaClassIndex);
                } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    if (this.interfaceName_ != null) {
                        this.setDefaultValueToProperty(cprop, String.valueOf(this.interfaceName_.getNamespaceURI()) + this.PACKAGE_SUFFIX, javaClassIndex);
                    }
                } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    this.setDefaultValueToProperty(cprop, "foo", javaClassIndex);
                    if (!this.mpoData_.isEmpty()) {
                        ++javaClassIndex;
                    }
                }
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)prop)) {
                INodeProperty root;
                String pkgName = null;
                if (this.interfaceName_ != null) {
                    pkgName = String.valueOf(this.interfaceName_.getNamespaceURI()) + this.PACKAGE_SUFFIX;
                }
                if ((root = ((ITreeProperty)prop).getRoot()) != null) {
                    this.setDefaultValueToTreeNode(root, project, pkgName, 0);
                }
            }
            ++i;
        }
    }

    protected void setDefaultValueToProperty(ICustomProperty icp, String defaultValue, int javaClassIndex) {
        if (icp == null || defaultValue == null || defaultValue.length() < 1) {
            return;
        }
        Object currentValue = PropertyUtil.getValue((IPropertyDescriptor)((IPropertyDescriptor)icp));
        try {
            if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)icp)) {
                ((JavaProjectProperty)icp).setValueAsString(defaultValue);
            } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)icp)) {
                if (currentValue == null) {
                    ((JavaPackageProperty)icp).setValueAsString(defaultValue);
                }
            } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)icp) && currentValue == null) {
                String fileName = null;
                if (this.mpoData_.size() < 1) {
                    IResultNodeSelection resultNodeSelection = this.wizard_.getImporterPage().getResultNodeSelection();
                    if (resultNodeSelection.getSelection().length > 0) {
                        fileName = resultNodeSelection.getSelection()[0].getName();
                    }
                } else if (javaClassIndex == 0) {
                    if (this.currentMethod_ != null) {
                        fileName = String.valueOf(this.currentMethod_.getMethodName()) + this.WRAPPERCLASS_SUFFIX;
                    }
                } else if (javaClassIndex - 1 < this.mpoData_.size()) {
                    fileName = ((SubMPOInfo)this.mpoData_.get(javaClassIndex - 1)).getIOMessageSubInfoName();
                }
                if (fileName != null && fileName.length() > 0) {
                    String errMsg;
                    char ch = fileName.charAt(0);
                    if (Character.isLowerCase(ch)) {
                        StringBuffer newName = new StringBuffer(fileName);
                        newName.setCharAt(0, Character.toUpperCase(ch));
                        fileName = newName.toString();
                    }
                    if ((errMsg = this.checkJavaClassName((JavaClassNameProperty)icp, fileName)) == null) {
                        ((JavaClassNameProperty)icp).setValueAsString(fileName);
                    }
                }
            }
        }
        catch (CoreException ie) {
            J2CLogUtil.log((String)ie.getMessage(), (short)60);
        }
    }

    protected void setDefaultValueToTreeNode(INodeProperty node, String project, String pkgName, int index) {
        if (node == null) {
            return;
        }
        IPropertyGroup pg = node.createConfigurationProperties();
        if (pg != null) {
            this.setDefaultValueToPropertyGroup(pg, project, pkgName, index);
        }
    }

    protected void setDefaultValueToPropertyGroup(IPropertyGroup pg, String project, String pkg, int index) {
        if (pg == null) {
            return;
        }
        IPropertyDescriptor[] properties = pg.getProperties();
        int i = 0;
        while (i < properties.length) {
            INodeProperty root;
            if (PropertyHelper.isCustomProperty((IPropertyDescriptor)properties[i])) {
                ICustomProperty cprop = (ICustomProperty)properties[i];
                if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    if (((JavaProjectProperty)cprop).getValue() == null) {
                        this.setDefaultValueToProperty(cprop, project, index);
                    }
                } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    this.setDefaultValueToProperty(cprop, pkg, index);
                } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    this.setDefaultValueToProperty(cprop, "foo", index);
                }
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)properties[i]) && (root = ((ITreeProperty)properties[i]).getRoot()) != null) {
                this.setDefaultValueToTreeNode(root, project, pkg, index);
            }
            ++i;
        }
    }

    public String validateJavaClassNameProperty(JavaClassNameProperty property) {
        String fileName = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
        String errMsg = this.checkJavaClassName(property, fileName);
        return errMsg;
    }

    protected String checkJavaClassName(JavaClassNameProperty javaClass, String fileName) {
        String errMsg = null;
        JavaClassPath javaPath = (JavaClassPath)this.javaClassPath_.get(javaClass);
        String pj = null;
        String pkg = null;
        if (javaPath != null) {
            pj = PropertyUtil.getValueAsString((IPropertyDescriptor)javaPath.Project_);
            pkg = PropertyUtil.getValueAsString((IPropertyDescriptor)javaPath.Package_);
        }
        if (pj != null && pkg != null && pj.length() > 0 && pkg.length() > 0) {
            String projName = this.wizard_.getProjectName();
            String pkgName = null;
            String iName = null;
            if (this.interfaceName_ != null) {
                pkgName = this.interfaceName_.getNamespaceURI();
                iName = this.interfaceName_.getLocalPart();
            }
            String implName = this.interfaceImplName_;
            if (iName != null && iName.equalsIgnoreCase(fileName) && pj.equalsIgnoreCase(projName) && pkg.equalsIgnoreCase(pkgName)) {
                errMsg = this.messageBundle_.getMessage("ERROR_WIZARDS_NAME_IS_USED", (Object[])J2CUICoreHelper.getDefault().getDisplayString(fileName));
                return errMsg;
            }
            if (implName != null && implName.equalsIgnoreCase(fileName) && pj.equalsIgnoreCase(projName) && pkg.equalsIgnoreCase(pkgName)) {
                errMsg = this.messageBundle_.getMessage("ERROR_WIZARDS_NAME_IS_USED", (Object[])J2CUICoreHelper.getDefault().getDisplayString(fileName));
                return errMsg;
            }
            if (this.javaClassCheckingList_ == null) {
                this.populateJavaClassCheckingList(this.existingOperations_, javaClass);
            }
            if (this.javaClassCheckingList_.size() > 0) {
                StringBuffer tmp = new StringBuffer(pj);
                tmp.append('/');
                tmp.append(pkg);
                tmp.append('/');
                tmp.append(fileName);
                String classPath = tmp.toString();
                int i = 0;
                while (i < this.javaClassCheckingList_.size()) {
                    if (classPath.equalsIgnoreCase((String)this.javaClassCheckingList_.get(i))) {
                        errMsg = this.messageBundle_.getMessage("ERROR_WIZARDS_NAME_IS_USED", (Object[])J2CUICoreHelper.getDefault().getDisplayString(fileName));
                        return errMsg;
                    }
                    ++i;
                }
            }
            Object[] keys = this.javaClassPath_.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                if (!keys[i].equals(javaClass)) {
                    String workingFN;
                    String workingPKG;
                    JavaClassNameProperty key = (JavaClassNameProperty)keys[i];
                    JavaClassPath path = (JavaClassPath)this.javaClassPath_.get(key);
                    String workingPJ = PropertyUtil.getValueAsString((IPropertyDescriptor)path.Project_);
                    if (workingPJ != null && workingPJ.length() >= 1 && workingPJ.equalsIgnoreCase(pj) && (workingPKG = PropertyUtil.getValueAsString((IPropertyDescriptor)path.Package_)) != null && workingPKG.length() >= 1 && workingPKG.equalsIgnoreCase(pkg) && (workingFN = PropertyUtil.getValueAsString((IPropertyDescriptor)key)) != null && workingFN.length() >= 1 && workingFN.equalsIgnoreCase(fileName)) {
                        errMsg = this.messageBundle_.getMessage("ERROR_WIZARDS_NAME_IS_USED", (Object[])J2CUICoreHelper.getDefault().getDisplayString(fileName));
                        return errMsg;
                    }
                }
                ++i;
            }
        }
        return errMsg;
    }

    protected void getJavaClassPathInfo(IPropertyGroup propertyGroup, JavaClassNameProperty workingJavaClass, ArrayList javaClasses) {
        if (propertyGroup == null) {
            return;
        }
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        if (properties == null) {
            return;
        }
        ArrayList<String> classes = new ArrayList<String>();
        String pjName = null;
        String pkgName = null;
        String fileName = null;
        int i = 0;
        while (i < properties.length) {
            IPropertyDescriptor prop = properties[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)prop)) {
                this.getJavaClassPathInfo((IPropertyGroup)prop, workingJavaClass, javaClasses);
            }
            if (PropertyHelper.isCustomProperty((IPropertyDescriptor)prop)) {
                ICustomProperty cprop = (ICustomProperty)prop;
                if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    pjName = PropertyUtil.getValueAsString((IPropertyDescriptor)prop);
                } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    pkgName = PropertyUtil.getValueAsString((IPropertyDescriptor)prop);
                } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop) && (fileName = PropertyUtil.getValueAsString((IPropertyDescriptor)prop)) != null && fileName.length() > 0) {
                    classes.add(fileName);
                }
            }
            ++i;
        }
        if (pjName != null && pkgName != null && pjName.length() > 0 && pkgName.length() > 0) {
            i = 0;
            while (i < classes.size()) {
                StringBuffer classPath = new StringBuffer(pjName);
                classPath.append('/');
                classPath.append(pkgName);
                classPath.append('/');
                classPath.append((String)classes.get(i));
                javaClasses.add(classPath.toString());
                ++i;
            }
        }
    }

    protected void populateJavaClassCheckingList(Vector operations, JavaClassNameProperty javaClass) {
        this.javaClassCheckingList_ = new ArrayList();
        if (operations != null) {
            int i = 0;
            while (i < operations.size()) {
                BindingOperationInfo method = (BindingOperationInfo)operations.get(i);
                IOMessageInfo io = method.getInputMessage();
                if (io != null) {
                    this.getJavaClassPathInfo(io.getWriteProperties(), null, this.javaClassCheckingList_);
                }
                if ((io = method.getOutputMessage()) != null) {
                    this.getJavaClassPathInfo(io.getWriteProperties(), null, this.javaClassCheckingList_);
                }
                ++i;
            }
        }
        if (this.currentMethod_ != null) {
            IOMessageInfo io = this.currentMethod_.getInputMessage();
            if (io != null) {
                this.getJavaClassPathInfo(io.getWriteProperties(), null, this.javaClassCheckingList_);
            }
            if ((io = this.currentMethod_.getOutputMessage()) != null) {
                this.getJavaClassPathInfo(io.getWriteProperties(), null, this.javaClassCheckingList_);
            }
        }
    }

    public void getDataTypeName() {
        ArrayList dataTypes = this.wizard_.getDataTypes();
        ArrayList importedFiles = this.getImportedFiles();
        if (importedFiles.size() > 0) {
            IOMessageSubInfo subInfo = new IOMessageSubInfo((String)importedFiles.get(0));
            dataTypes.add(subInfo);
            J2CLanguageImportWizard_InitPage initPage = this.wizard_.getInitPage();
            subInfo.setSource((Object)initPage.getPropertyGroup());
            ArrayList mpoData = initPage.getMPOData();
            int k = 1;
            if (mpoData != null && mpoData.size() > 0) {
                int i = 0;
                while (i < mpoData.size()) {
                    IOMessageSubInfo info = ((SubMPOInfo)mpoData.get(i)).getIOMessageSubInfo();
                    if (!(info.getSource() instanceof URI) && k < importedFiles.size()) {
                        info.setName((String)importedFiles.get(k++));
                    }
                    dataTypes.add(info);
                    ++i;
                }
            } else {
                J2CLanguageImportWizard_ImporterPage importerPage = this.wizard_.getImporterPage();
                subInfo.setQueryProperties(importerPage.getPropertyGroup());
                ArrayList selection = importerPage.getSelectedResultNodes();
                if (selection != null && !selection.isEmpty()) {
                    IResultNode node = (IResultNode)selection.get(0);
                    subInfo.setData((Object)node);
                }
            }
        }
    }

    protected ArrayList getImportedFiles() {
        ArrayList<String> importedFiles = new ArrayList<String>(3);
        ArrayList widgtes = this.wizard_.getSavingPage().getUIWidgets();
        int i = 0;
        while (i < widgtes.size()) {
            INodeProperty root;
            IPropertyDescriptor prop = ((PropertyUIWidget)widgtes.get(i)).getProperty();
            if (PropertyHelper.isCustomProperty((IPropertyDescriptor)prop)) {
                ICustomProperty cprop = (ICustomProperty)prop;
                if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    importedFiles.add(PropertyUtil.getValueAsString((IPropertyDescriptor)prop));
                }
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)prop) && (root = ((ITreeProperty)prop).getRoot()) != null) {
                this.getImportedFiles(root, importedFiles);
            }
            ++i;
        }
        return importedFiles;
    }

    protected void getImportedFiles(INodeProperty node, ArrayList importedFiles) {
        INodeProperty[] children;
        IPropertyGroup pg = node.createConfigurationProperties();
        if (pg != null) {
            this.getImportedFiles(pg, importedFiles);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                this.getImportedFiles(children[i], importedFiles);
                ++i;
            }
        }
    }

    protected void getImportedFiles(IPropertyGroup pg, ArrayList importedFiles) {
        IPropertyDescriptor[] properties = pg.getProperties();
        int i = 0;
        while (i < properties.length) {
            INodeProperty root;
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i])) {
                this.getImportedFiles((IPropertyGroup)properties[i], importedFiles);
            }
            if (PropertyHelper.isCustomProperty((IPropertyDescriptor)properties[i])) {
                ICustomProperty cprop = (ICustomProperty)properties[i];
                if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    JavaClassNameProperty jcnp = (JavaClassNameProperty)cprop;
                    String name = jcnp.getValueAsString();
                    if (name == null) {
                        name = jcnp.getPropertyType().getDefaultValue().toString();
                    }
                    if (name != null) {
                        importedFiles.add(name);
                    }
                }
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)properties[i]) && (root = ((ITreeProperty)properties[i]).getRoot()) != null) {
                this.getImportedFiles(root, importedFiles);
            }
            ++i;
        }
    }

    protected class JavaClassPath {
        JavaProjectProperty Project_;
        JavaPackageProperty Package_;

        public JavaClassPath(JavaProjectProperty project, JavaPackageProperty pkg) {
            this.Project_ = project;
            this.Package_ = pkg;
        }
    }
}

