/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.deployment.simplejsp;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.deployment.simplejsp.SimpleJSPDeploymentMessages;
import com.ibm.j2c.ui.internal.deployment.simplejsp.SimpleJSPDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.deployment.simplejsp.SimplejspPlugin;
import com.ibm.j2c.ui.internal.model.AbstractDeploymentMethod;
import com.ibm.j2c.ui.internal.model.IDeploymentMethod;
import com.ibm.j2c.ui.internal.model.IWasCommonUtils;
import com.ibm.j2c.ui.internal.model.J2CUIInfo;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.j2c.ui.internal.utilities.J2CUIHelper;
import com.ibm.propertygroup.IPropertyGroup;
import commonj.connector.metadata.description.FunctionDescription;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.WebServiceClientTestArrivalCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample.GSTCGenerateCommand;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class SimpleJSPDeployment
extends AbstractDeploymentMethod
implements IDeploymentMethod {
    private SimpleJSPDeploymentPropertyGroup sppg = null;

    public IPropertyGroup getPropertyGroup() {
        try {
            IProject origProj;
            String ivcType;
            if (this.sppg == null) {
                this.sppg = new SimpleJSPDeploymentPropertyGroup(this.initialOutboundServiceDescription);
            }
            if (this.ivc != null && (ivcType = ResourceUtils.getJ2EEProjectType((IProject)this.ivc.getProject())) != null && ivcType.equals(ResourceUtils.DYNAMIC_WEB) && (origProj = this.ivc.getProject()) != null) {
                this.sppg.getWebProjectProperty().setEnabled(true);
                this.sppg.setWebProjectName(origProj.getName());
                this.sppg.getWebProjectProperty().setEnabled(false);
            }
            return this.sppg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void performOnFinish(J2CUIInfo J2CUIInfo_) {
        this.performOnFinish(J2CUIInfo_.JavaInterface_, this.getGeneratedFile(J2CUIInfo_));
    }

    public void performOnFinish(J2CServiceDescription oid, IFile file) {
        IProject webProj = ResourceUtils.getWorkspace().getRoot().getProject(this.sppg.getWebProjectName());
        IVirtualComponent webMod = ComponentCore.createComponent((IProject)webProj);
        Vector associatedEARs = DeploymentUtils.hasEARSforJ2EEProj((IProject)this.sppg.getDeployableComponent().getProject());
        IVirtualComponent earMod = null;
        if (associatedEARs != null && !associatedEARs.isEmpty()) {
            earMod = (IVirtualComponent)associatedEARs.get(0);
        }
        DeploymentHelper helper = new DeploymentHelper();
        FunctionDescription[] methodsList = null;
        if (oid != null) {
            methodsList = oid.getServiceDescription().getFunctionDescriptions();
        }
        Hashtable typeNames = DeploymentUtils.getAllDataTypeProjectNames((FunctionDescription[])methodsList, (boolean)false);
        helper.updateDeploymentInfo(this.ivc, this.ivc.getName(), webMod, earMod, typeNames, DeploymentUtils.hasEARSforJ2EEProj((IProject)webProj).size() <= 0, false);
        DeploymentUtils.waitForBuildJobs((int)3, (IProgressMonitor)this.monitor);
        TestInfo testInfo = new TestInfo();
        WebServiceClientTestArrivalCommand methodSignatureDiscoverer = new WebServiceClientTestArrivalCommand();
        IVirtualComponent component = ComponentCore.createComponent((IProject)webProj);
        IPath modulePath = component.getRootFolder().getWorkspaceRelativePath();
        IPath projectRelativePath = component.getRootFolder().getProjectRelativePath().append(this.sppg.getFolderName());
        IPath pJspPath = modulePath.append(this.sppg.getFolderName());
        String jspPath = pJspPath.toString();
        String webProjectPath = webProj.getFullPath().toString();
        String genCodeProj = this.ivc.getProject().getFullPath().toString();
        IEnvironment env2 = EnvironmentService.getEclipseConsoleEnvironment();
        String qualifiedBeanName = null;
        String packName = J2CUIHelper.instance().convertStringToQName(oid.getServiceDescription().getName()).getNamespaceURI();
        qualifiedBeanName = packName != null && !packName.equals("") ? String.valueOf(packName) + "." + file.getName() : file.getName();
        methodSignatureDiscoverer.setProxyBean(qualifiedBeanName);
        if (genCodeProj.startsWith("/")) {
            genCodeProj = genCodeProj.substring(1);
        }
        methodSignatureDiscoverer.setClientProject(String.valueOf(genCodeProj) + "/" + genCodeProj);
        methodSignatureDiscoverer.setEnvironment(env2);
        IStatus status = methodSignatureDiscoverer.execute(null, null);
        if (status.getSeverity() == 4) {
            MessageDialog.openError((Shell)new Shell(), (String)SimpleJSPDeploymentMessages.ERROR_WIZARDS_JSP_GEN, (String)status.getMessage());
            return;
        }
        BooleanSelection[] methods = methodSignatureDiscoverer.getMethods();
        int j = 0;
        while (j < methods.length) {
            if (methods[j] != null) {
                methods[j] = new BooleanSelection(methods[j].getValue(), false);
            }
            ++j;
        }
        int i = 0;
        while (i < this.methodNames.size()) {
            String methodName = (String)this.methodNames.get(i);
            int k = 0;
            while (k < methods.length) {
                if (methods[k] != null && methods[k].getValue().startsWith(String.valueOf(methodName) + "(")) {
                    methods[k] = new BooleanSelection(methods[k].getValue(), true);
                }
                ++k;
            }
            ++i;
        }
        testInfo.setClientProject(genCodeProj);
        testInfo.setJspFolder(jspPath);
        testInfo.setMethods(methods);
        testInfo.setProxyBean(qualifiedBeanName);
        testInfo.setGenerationProject(webProjectPath);
        GSTCGenerateCommand generateCommand = new GSTCGenerateCommand(testInfo);
        generateCommand.setEnvironment(env2);
        status = generateCommand.execute(null, null);
        if (status.getSeverity() == 4) {
            MessageDialog.openError((Shell)new Shell(), (String)SimpleJSPDeploymentMessages.ERROR_WIZARDS_JSP_GEN, (String)status.getMessage());
        }
        String resRefName = this.sppg.getResourceReference();
        IWasCommonUtils utils = DeploymentHelper.instance().getWASCommonUtils();
        utils.updateResourceReference(resRefName, this.sppg.getJNDILookupName(), webProj);
        ResourceUtils.highlightCreatedResource((IResource)webProj.getFolder(projectRelativePath));
    }

    public String getDeploymentPageTitle() {
        return SimpleJSPDeploymentMessages.J2C_UI_WIZARDS_TITLE_TEST;
    }

    public String getDeploymentPageDescription() {
        return SimpleJSPDeploymentMessages.J2C_UI_WIZARDS_TITLE_TEST_DESC;
    }

    public ImageDescriptor getDeploymentPageImageDescriptor() {
        return SimplejspPlugin.getImageDescriptor("icons/J2Cjsp_wiz.gif");
    }

    public ImageDescriptor getDeploymentOptionImageDescriptor(int imageCode) {
        if (imageCode == 1) {
            return SimplejspPlugin.getImageDescriptor("icons/JspDeploy.gif");
        }
        if (imageCode == 2) {
            return SimplejspPlugin.getImageDescriptor("icons/JspDeployFalse.gif");
        }
        if (imageCode == 3) {
            return SimplejspPlugin.getImageDescriptor("icons/jsp_hov.gif");
        }
        return null;
    }

    public IFile[] getDeploymentFiles() {
        if (this.sppg == null) {
            return null;
        }
        IFile[] files = new IFile[4];
        IProject webProj = ResourceUtils.getWorkspace().getRoot().getProject(this.sppg.getWebProjectName());
        IVirtualComponent component = ComponentCore.createComponent((IProject)webProj);
        IPath projectRelativePath = component.getRootFolder().getProjectRelativePath().append(this.sppg.getFolderName());
        files[0] = webProj.getFile(projectRelativePath.append(GSTCGenerateCommand.INPUT));
        files[1] = webProj.getFile(projectRelativePath.append(GSTCGenerateCommand.METHOD));
        files[2] = webProj.getFile(projectRelativePath.append(GSTCGenerateCommand.RESULT));
        files[3] = webProj.getFile(projectRelativePath.append(GSTCGenerateCommand.TEST_CLIENT));
        return files;
    }
}

