/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.deployment.jsf;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.deployment.jsf.JSFDeploymentMessages;
import com.ibm.j2c.ui.internal.model.IDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.properties.CommonDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.properties.J2EEProjectProperty;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JSFDeploymentPropertyGroup
extends CommonDeploymentPropertyGroup
implements IDeploymentPropertyGroup {
    protected J2EEProjectProperty webProject_;
    protected BaseSingleValuedProperty jspFolder_;
    protected BaseSingleValuedProperty jspFileName_;
    private String webProjectName_ = "WebProject";

    public JSFDeploymentPropertyGroup(Object param) throws CoreException {
        super("FacesJSPDeploymentPropertyGroup", JSFDeploymentMessages.J2C_UI_DEPLOYMENT_JSF_DESCRIPTION, "");
        this.initialize();
        this.def = (J2CServiceDescription)param;
        super.initializeAdvanced();
    }

    public J2EEProjectProperty getWebProjectProperty() {
        return this.webProject_;
    }

    public String getWebProjectName() {
        return this.webProject_.getValueAsString();
    }

    public void setWebProjectName(String newName) {
        try {
            this.webProject_.setValueAsString(newName);
        }
        catch (Exception exception) {}
    }

    protected void initialize() throws CoreException {
        this.webProject_ = new J2EEProjectProperty(this.webProjectName_, JSFDeploymentMessages.J2C_UI_DEPLOYMENT_JSF_WEBPROJECT_LABEL, JSFDeploymentMessages.J2C_UI_DEPLOYMENT_JSF_WEBPROJECT_LABEL, String.class, (BasePropertyGroup)this);
        this.webProject_.setRequired(true);
        this.webProject_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.webProject_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.webProject_.setProjectType(ResourceUtils.DYNAMIC_WEB);
        this.webProject_.assignID("com.ibm.j2c.ui.propertyextension.newj2eewizard");
        this.jspFolder_ = new BaseSingleValuedProperty("jspFolder", JSFDeploymentMessages.J2C_UI_DEPLOYMENT_JSF_FOLDER_LABEL, JSFDeploymentMessages.J2C_UI_DEPLOYMENT_JSF_FOLDER_LABEL, String.class, (BasePropertyGroup)this);
        this.jspFolder_.setRequired(false);
        this.jspFolder_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.jspFileName_ = new BaseSingleValuedProperty("jspFileName", JSFDeploymentMessages.J2C_UI_DEPLOYMENT_JSF_JSPNAME_LABEL, JSFDeploymentMessages.J2C_UI_DEPLOYMENT_JSF_JSPNAME_LABEL, String.class, (BasePropertyGroup)this);
        this.jspFileName_.setRequired(true);
        this.jspFileName_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
    }

    public Object clone() throws CloneNotSupportedException {
        JSFDeploymentPropertyGroup group = (JSFDeploymentPropertyGroup)((Object)super.clone());
        J2EEProjectProperty webProjectProperty = (J2EEProjectProperty)group.getProperty(this.webProjectName_);
        webProjectProperty.setRequired(true);
        webProjectProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        webProjectProperty.addPropertyChangeListener((IPropertyChangeListener)group);
        BaseSingleValuedProperty folder = (BaseSingleValuedProperty)group.getProperty("jspFolder");
        folder.setRequired(false);
        folder.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        BaseSingleValuedProperty jspName = (BaseSingleValuedProperty)group.getProperty("jspFileName");
        jspName.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        jspName.setRequired(true);
        return group;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyChangeType()) {
            case 0: {
                Object source = evt.getSource();
                if (source != this.webProject_) break;
                String wName = this.webProject_.getValueAsString();
                DeploymentUtils.initializeCommonDeploymentPropretyGroupValues((String)wName, (BasePropertyGroup)this);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object source = evt.getSource();
        Object newValue = evt.getNewValue();
        if (newValue == null) {
            return;
        }
        if (source == this.webProject_) {
            IProject project = ResourceUtils.getWorkspace().getRoot().getProject((String)evt.getNewValue());
            if (project != null && !project.exists()) {
                throw new PropertyVetoException(JSFDeploymentMessages.J2C_UI_DEPLOYMENT_NOT_WEB_PROJECT_ERROR, (java.beans.PropertyChangeEvent)evt);
            }
            if (source == this.webProject_ && !ResourceUtils.isProjectOfKind((IProject)project, (String)ResourceUtils.DYNAMIC_WEB)) {
                throw new PropertyVetoException(JSFDeploymentMessages.J2C_UI_DEPLOYMENT_NOT_WEB_PROJECT_ERROR, (java.beans.PropertyChangeEvent)evt);
            }
        }
    }

    public String getFolderName() {
        String res = this.jspFolder_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    public IVirtualComponent getDeployableComponent() {
        String webName = this.webProject_.getValueAsString();
        if (webName != null) {
            IProject pr = ResourceUtils.getWorkspace().getRoot().getProject(webName);
            IVirtualComponent comp = ComponentCore.createComponent((IProject)pr);
            return comp;
        }
        return null;
    }

    public String getResourceRefName() {
        return this.resourceReference_.getValueAsString();
    }

    public String getJndiLookupName() {
        return this.jndiLookupName_.getValueAsString();
    }

    public Vector getEarComponents() {
        return DeploymentUtils.hasEARSforJ2EEProj((IProject)this.getDeployableComponent().getProject());
    }

    public String getJSPFileName() {
        return this.jspFileName_.getValueAsString();
    }
}

