/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.deployment.ejb;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.deployment.ejb.EjbDeploymentMessages;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.model.IDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.properties.CommonDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.properties.J2EEProjectProperty;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.j2c.ui.internal.utilities.EJB30Utils;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class EjbDeploymentPropertyGroup
extends CommonDeploymentPropertyGroup
implements IDeploymentPropertyGroup {
    protected final String STATELESS_FLAG = "Stateless";
    protected final String STATEFUL_FLAG = "Stateful";
    protected final String CONTAINER_FLAG = "Container";
    protected final String BEAN_FLAG = "Bean";
    protected J2EEProjectProperty ejbProject_;
    protected J2EEProjectProperty earProject_;
    protected BaseSingleValuedProperty sessionBeanName_;
    protected BaseSingleValuedProperty sessionBeanPackage_;
    protected BaseSingleValuedProperty sessionType_;
    protected BaseSingleValuedProperty transactionType_;
    protected BaseSingleValuedProperty jndiName_;
    protected BaseSingleValuedProperty remoteInterfaceEnabled_;
    protected BaseSingleValuedProperty remoteHomeInterface_;
    protected BaseSingleValuedProperty remoteInterface_;
    protected BaseSingleValuedProperty localInterfaceEnabled_;
    protected BaseSingleValuedProperty localHomeInterface_;
    protected BaseSingleValuedProperty localInterface_;
    protected BaseSingleValuedProperty ejbTransactionNotEnabled_;
    private String ejbProjectName_ = "EJB Project";
    private String earProjectName_ = "Ear Project";
    private boolean isEJB30 = false;
    private boolean earFieldRemoved = false;
    private IProject correspondingConnectorProject = null;
    protected boolean isEJB30Enabled = false;

    public EjbDeploymentPropertyGroup(Object param) throws CoreException {
        super("EJBDeploymentPropertyGroup", "EJB deployment properties", "");
        this.initialize();
        this.def = (J2CServiceDescription)param;
        super.initializeAdvanced();
        if (this.def != null) {
            try {
                this.correspondingConnectorProject = this.def.getResourceAdapterDescriptor().getConnectorProject();
            }
            catch (Exception exception) {}
        }
    }

    public J2EEProjectProperty getEjbProjectProperty() {
        return this.ejbProject_;
    }

    public J2EEProjectProperty getEarProjectProperty() {
        return this.earProject_;
    }

    public String getEJBProjectName() {
        return this.ejbProject_.getValueAsString();
    }

    public void setEJBProjectName(String newName) {
        try {
            this.ejbProject_.setValueAsString(newName);
        }
        catch (Exception exception) {}
    }

    public String getEarProjectName() {
        return this.earProject_.getValueAsString();
    }

    private void initialize() throws CoreException {
        this.ejbProject_ = new J2EEProjectProperty(this.ejbProjectName_, J2CUIMessages.J2C_UI_WIZARDS_LABEL_EJB_PROJECT, J2CUIMessages.J2C_UI_WIZARDS_LABEL_EJB_PROEJCT_TOOLTIP, String.class, (BasePropertyGroup)this);
        this.ejbProject_.setRequired(true);
        this.ejbProject_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.ejbProject_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.ejbProject_.setProjectType(ResourceUtils.EJB);
        this.ejbProject_.assignID("com.ibm.j2c.ui.propertyextension.newj2eewizard");
        this.earProject_ = new J2EEProjectProperty(this.earProjectName_, J2CUIMessages.J2C_UI_WIZARDS_DEPLOYMENT_EAR_FILE, J2CUIMessages.J2C_UI_WIZARDS_DEPLOYMENT_EAR_FILE, String.class, (BasePropertyGroup)this);
        this.earProject_.setRequired(true);
        this.earProject_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.earProject_.setProjectType(ResourceUtils.ENTERPRISE_APPLICATION);
        this.earProject_.assignID("com.ibm.j2c.ui.propertyextension.newj2eewizard");
        this.sessionBeanName_ = new BaseSingleValuedProperty("SessionBeanName", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_SES_BEAN_NAME, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_SES_BEAN_NAME, String.class, (BasePropertyGroup)this);
        this.sessionBeanName_.setRequired(true);
        this.sessionBeanName_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.sessionBeanPackage_ = new BaseSingleValuedProperty("SessionBeanPackage", EjbDeploymentMessages.J2C_UI_SESSION_BEAN_PACKAGE_NAME, EjbDeploymentMessages.J2C_UI_SESSION_BEAN_PACKAGE_NAME, String.class, (BasePropertyGroup)this);
        this.sessionBeanPackage_.setRequired(true);
        this.sessionBeanPackage_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.sessionType_ = new BaseSingleValuedProperty("Session Type", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_SES_TYPE, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_SES_TYPE_TOOLTIP, String.class, (BasePropertyGroup)this);
        this.sessionType_.setRequired(true);
        Object[] valVals = new String[]{"Stateless", "Stateful"};
        this.sessionType_.setValidValues(valVals);
        this.sessionType_.setDefaultValue((Object)"Stateless");
        this.sessionType_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.transactionType_ = new BaseSingleValuedProperty("Transaction Type", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_TRAN_TYPE, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_TRAN_TYPE_TOOPTIP, String.class, (BasePropertyGroup)this);
        this.transactionType_.setRequired(true);
        Object[] valVals2 = new String[]{"Container", "Bean"};
        this.transactionType_.setValidValues(valVals2);
        this.transactionType_.setDefaultValue((Object)"Container");
        this.transactionType_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.jndiName_ = new BaseSingleValuedProperty("JNDI Name", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_JNDI_NAME, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_JNDI_NAME_TOOLTIP, String.class, (BasePropertyGroup)this);
        this.jndiName_.setRequired(true);
        this.jndiName_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.remoteInterfaceEnabled_ = new BaseSingleValuedProperty("remote enabled", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_REM_CLIENT_VIEW, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_REM_CLIENT_VIEW_TOOLTIP, Boolean.class, (BasePropertyGroup)this);
        this.remoteInterfaceEnabled_.setRequired(false);
        this.remoteInterfaceEnabled_.setValue((Object)new Boolean(true));
        this.remoteInterfaceEnabled_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.remoteHomeInterface_ = new BaseSingleValuedProperty("Remote home interface", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_REM_HOME_INTER, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_REM_HOME_INTER_TOOLTIP, String.class, (BasePropertyGroup)this);
        this.remoteHomeInterface_.setRequired(false);
        this.remoteHomeInterface_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.remoteInterface_ = new BaseSingleValuedProperty("Remote Interface", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_REM_INTER, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_REM_INTER_TOOLTIP, String.class, (BasePropertyGroup)this);
        this.remoteInterface_.setRequired(false);
        this.remoteInterface_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.localInterfaceEnabled_ = new BaseSingleValuedProperty("local enabled", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_LOCAL_CLIENT_VIEW, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_LOCAL_CLIENT_VIEW_TOOLTIP, Boolean.class, (BasePropertyGroup)this);
        this.localInterfaceEnabled_.setRequired(false);
        this.localInterfaceEnabled_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.localHomeInterface_ = new BaseSingleValuedProperty("Local home interface", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_LOCAL_HOME_INTER, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_LOCAL_HOME_INTER_TOOLTIP, String.class, (BasePropertyGroup)this);
        this.localHomeInterface_.setRequired(false);
        this.localHomeInterface_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.localInterface_ = new BaseSingleValuedProperty("Local interface", J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_LOCAL_HOME_INTER, J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_LOCAL_HOME_INTER_TOOLTIP, String.class, (BasePropertyGroup)this);
        this.localInterface_.setRequired(false);
        this.localInterface_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.ejbTransactionNotEnabled_ = new BaseSingleValuedProperty("disable EJB transaction", J2CUIMessages.J2C_UI_DISABLE_EJB_TRANSACTION, J2CUIMessages.J2C_UI_DISABLE_EJB_TRANSACTION, Boolean.class, (BasePropertyGroup)this);
        this.ejbTransactionNotEnabled_.setRequired(false);
        this.ejbTransactionNotEnabled_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.ejbTransactionNotEnabled_.setExpert(true);
    }

    public Object clone() throws CloneNotSupportedException {
        EjbDeploymentPropertyGroup group = (EjbDeploymentPropertyGroup)((Object)super.clone());
        JavaProjectProperty webProjectProperty = (JavaProjectProperty)group.getProperty(this.ejbProjectName_);
        webProjectProperty.addPropertyChangeListener((IPropertyChangeListener)group);
        webProjectProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        JavaProjectProperty earProjectProperty = (JavaProjectProperty)group.getProperty(this.earProjectName_);
        earProjectProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        BaseSingleValuedProperty beanName = (BaseSingleValuedProperty)group.getProperty("SessionBeanName");
        beanName.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        BaseSingleValuedProperty beanPackage = (BaseSingleValuedProperty)group.getProperty("SessionBeanPackage");
        beanPackage.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        BaseSingleValuedProperty sessionType = (BaseSingleValuedProperty)group.getProperty("Session Type");
        sessionType.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        BaseSingleValuedProperty transactionType = (BaseSingleValuedProperty)group.getProperty("Transaction Type");
        transactionType.setRequired(true);
        Object[] valVals2 = new String[]{"Container", "Bean"};
        try {
            transactionType.setValidValues(valVals2);
            transactionType.setDefaultValue((Object)"Container");
        }
        catch (Exception exception) {}
        transactionType.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        BaseSingleValuedProperty jndiName = (BaseSingleValuedProperty)group.getProperty("JNDI Name");
        jndiName.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        jndiName.setRequired(true);
        BaseSingleValuedProperty remoteHomeInterfaceEnabled = (BaseSingleValuedProperty)group.getProperty("remote enabled");
        remoteHomeInterfaceEnabled.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        remoteHomeInterfaceEnabled.setRequired(false);
        BaseSingleValuedProperty remoteHomeInterface = (BaseSingleValuedProperty)group.getProperty("Remote home interface");
        remoteHomeInterface.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        remoteHomeInterface.setRequired(false);
        BaseSingleValuedProperty remoteInterface = (BaseSingleValuedProperty)group.getProperty("Remote interface");
        remoteInterface.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        remoteInterface.setRequired(false);
        BaseSingleValuedProperty localHomeInterfaceEnabled = (BaseSingleValuedProperty)group.getProperty("local enabled");
        localHomeInterfaceEnabled.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        localHomeInterfaceEnabled.setRequired(false);
        BaseSingleValuedProperty localHomeInterface = (BaseSingleValuedProperty)group.getProperty("Local home interface");
        localHomeInterface.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        localHomeInterface.setRequired(false);
        BaseSingleValuedProperty localInterface = (BaseSingleValuedProperty)group.getProperty("Local interface");
        localInterface.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        localInterface.setRequired(false);
        BaseSingleValuedProperty ejbTrDis = (BaseSingleValuedProperty)group.getProperty("disable EJB transaction");
        ejbTrDis.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        ejbTrDis.setRequired(false);
        ejbTrDis.setExpert(true);
        return group;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyChangeType()) {
            case 0: {
                Object source = evt.getSource();
                if (source != this.ejbProject_) break;
                IProject ejbProj = ResourceUtils.getWorkspace().getRoot().getProject(this.getEJBProjectName());
                this.populateEARModules(ejbProj, (BaseSingleValuedProperty)this.earProject_);
                DeploymentUtils.initializeCommonDeploymentPropretyGroupValues((String)this.getEJBProjectName(), (BasePropertyGroup)this);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object source = evt.getSource();
        Object newValue = evt.getNewValue();
        if (newValue == null) {
            return;
        }
        if (source == this.ejbProject_ || source == this.earProject_) {
            String projName = (String)evt.getNewValue();
            IProject project = ResourceUtils.getWorkspace().getRoot().getProject(projName);
            if (source == this.ejbProject_) {
                if (!ResourceUtils.isProjectOfKind((IProject)project, (String)ResourceUtils.EJB)) {
                    boolean isEJB30Exists = EJB30Utils.isEJB30FacetExists((IProject)project, (IProject)this.correspondingConnectorProject);
                    if (!isEJB30Exists) {
                        throw new PropertyVetoException(J2CUIMessages.J2C_UI_DEPLOYMENT_OPTION_INVALID_EJB_PRJ, (java.beans.PropertyChangeEvent)evt);
                    }
                    if (!project.exists()) {
                        throw new PropertyVetoException(J2CUIMessages.J2C_UI_DEPLOYMENT_OPTION_INVALID_EJB_PRJ, (java.beans.PropertyChangeEvent)evt);
                    }
                }
                boolean isEJBProject = ResourceUtils.isEJBProject((IProject)project);
                this.isEJB30 = EJB30Utils.isEJB30Project((IProject)project);
                if (this.isEJB30 || !isEJBProject) {
                    if (EJB30Utils.isEJB30FacetExists((IProject)project, (IProject)this.correspondingConnectorProject)) {
                        this.enableEJB3UI(true, isEJBProject);
                    }
                } else {
                    this.enableEJB3UI(false, isEJBProject);
                }
            } else if (!ResourceUtils.isProjectOfKind((IProject)project, (String)ResourceUtils.ENTERPRISE_APPLICATION)) {
                throw new PropertyVetoException(J2CUIMessages.J2C_UI_WIZARDS_LABEL_INVALID_EAR, (java.beans.PropertyChangeEvent)evt);
            }
        } else if (source == this.sessionBeanName_) {
            String errorMessage = this.validateSessionBeanName((String)evt.getNewValue());
            if (errorMessage != null) {
                throw new PropertyVetoException(errorMessage, (java.beans.PropertyChangeEvent)evt);
            }
            this.setDefaultPropertyValues((String)evt.getNewValue(), this.sessionBeanPackage_.getValueAsString());
        } else if (source == this.sessionBeanPackage_) {
            IStatus stat = JavaConventions.validatePackageName((String)((String)evt.getNewValue()), (String)"1.5", (String)"1.3");
            if (stat.getSeverity() == 4) {
                throw new PropertyVetoException(stat.getMessage(), (java.beans.PropertyChangeEvent)evt);
            }
            this.setDefaultPropertyValues(this.sessionBeanName_.getValueAsString(), (String)evt.getNewValue());
        }
    }

    public String getSessionBeanName() {
        String res = this.sessionBeanName_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getSessionType() {
        String res = this.sessionType_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getTransactionType() {
        String res = this.transactionType_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getJNDIName() {
        String res = this.jndiName_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getRemoteHomeInterface() {
        String res = this.remoteHomeInterface_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getRemoteInterface() {
        String res = this.remoteInterface_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getLocalHomeInterface() {
        String res = this.localHomeInterface_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getLocalInterface() {
        String res = this.localInterface_.getValueAsString();
        if (res == null) {
            res = "";
        }
        return res;
    }

    private String validateSessionBeanName(String name) {
        String errorMessage = null;
        IStatus stat = JavaConventions.validateJavaTypeName((String)name);
        if (stat.getSeverity() == 4) {
            errorMessage = stat.getMessage();
        }
        return errorMessage;
    }

    public IVirtualComponent getEarComponent() {
        String earName = this.earProject_.getValueAsString();
        if (earName != null) {
            IProject pr = ResourceUtils.getWorkspace().getRoot().getProject(earName);
            IVirtualComponent comp = ComponentCore.createComponent((IProject)pr);
            return comp;
        }
        return null;
    }

    public Vector<IVirtualComponent> getEarComponents() {
        Vector<IVirtualComponent> res = new Vector<IVirtualComponent>();
        res.add(this.getEarComponent());
        return res;
    }

    public IVirtualComponent getDeployableComponent() {
        String ejbName = this.ejbProject_.getValueAsString();
        if (ejbName != null) {
            IProject pr = ResourceUtils.getWorkspace().getRoot().getProject(ejbName);
            IVirtualComponent comp = ComponentCore.createComponent((IProject)pr);
            return comp;
        }
        return null;
    }

    public boolean isEjbTransactionDisabled() {
        Boolean res = (Boolean)this.ejbTransactionNotEnabled_.getValue();
        if (res != null) {
            return res;
        }
        return false;
    }

    public boolean isLocalInterfaceEnabled() {
        Boolean res = (Boolean)this.localInterfaceEnabled_.getValue();
        if (res != null) {
            return res;
        }
        return false;
    }

    public boolean isRemoteInterfaceEnabled() {
        Boolean res = (Boolean)this.remoteInterfaceEnabled_.getValue();
        if (res != null) {
            return res;
        }
        return false;
    }

    public String getSessionBeanPackage() {
        return this.sessionBeanPackage_.getValueAsString();
    }

    public void setDefaultPropertyValues(String name, String pack) {
        if (name == null || pack == null) {
            return;
        }
        String jndi = "ejb/" + pack.replace('.', '/') + "/" + name + "Home";
        try {
            this.jndiName_.setValueAsString(jndi);
        }
        catch (Exception exception) {}
        if (!PropertyUtil.isHidden((IPropertyDescriptor)this.remoteHomeInterface_) && PropertyUtil.isEnabled((IPropertyDescriptor)this.remoteHomeInterface_)) {
            try {
                this.remoteHomeInterface_.setValueAsString(String.valueOf(pack) + "." + name + "Home");
            }
            catch (Exception exception) {}
        }
        if (!PropertyUtil.isHidden((IPropertyDescriptor)this.remoteInterface_) && PropertyUtil.isEnabled((IPropertyDescriptor)this.remoteInterface_)) {
            try {
                this.remoteInterface_.setValueAsString(String.valueOf(pack) + "." + name);
            }
            catch (Exception exception) {}
        }
        if (!PropertyUtil.isHidden((IPropertyDescriptor)this.localHomeInterface_) && PropertyUtil.isEnabled((IPropertyDescriptor)this.localHomeInterface_)) {
            try {
                this.localHomeInterface_.setValueAsString(String.valueOf(pack) + "." + name + "LocalHome");
            }
            catch (Exception exception) {}
        }
        if (!PropertyUtil.isHidden((IPropertyDescriptor)this.localInterface_) && PropertyUtil.isEnabled((IPropertyDescriptor)this.localInterface_)) {
            try {
                this.localInterface_.setValueAsString(String.valueOf(pack) + "." + name + "Local");
            }
            catch (Exception exception) {}
        }
    }

    public String getResourceRefName() {
        return this.resourceReference_.getValueAsString();
    }

    public String getJndiLookupName() {
        return this.jndiLookupName_.getValueAsString();
    }

    private void enableEJB3UI(boolean enable, boolean isEJBProject) {
        try {
            if (enable && !this.isEJB30Enabled) {
                this.remove((IPropertyDescriptor)this.sessionBeanName_);
                this.remove((IPropertyDescriptor)this.sessionBeanPackage_);
                this.remove((IPropertyDescriptor)this.localHomeInterface_);
                this.remove((IPropertyDescriptor)this.localInterface_);
                this.remove((IPropertyDescriptor)this.localInterfaceEnabled_);
                this.remove((IPropertyDescriptor)this.remoteHomeInterface_);
                this.remove((IPropertyDescriptor)this.remoteInterface_);
                this.remove((IPropertyDescriptor)this.remoteInterfaceEnabled_);
                if (!isEJBProject && !this.earFieldRemoved) {
                    this.earFieldRemoved = true;
                    this.remove((IPropertyDescriptor)this.earProject_);
                }
                this.jndiName_.setRequired(false);
                this.isEJB30Enabled = true;
            }
            if (!enable && this.isEJB30Enabled) {
                this.addProperty((IPropertyDescriptor)this.sessionBeanName_);
                this.addProperty((IPropertyDescriptor)this.sessionBeanPackage_);
                this.addProperty((IPropertyDescriptor)this.localHomeInterface_);
                this.addProperty((IPropertyDescriptor)this.localInterface_);
                this.addProperty((IPropertyDescriptor)this.localInterfaceEnabled_);
                this.addProperty((IPropertyDescriptor)this.remoteHomeInterface_);
                this.addProperty((IPropertyDescriptor)this.remoteInterface_);
                this.addProperty((IPropertyDescriptor)this.remoteInterfaceEnabled_);
                if (isEJBProject && this.earFieldRemoved) {
                    this.earFieldRemoved = false;
                    this.addProperty((IPropertyDescriptor)this.earProject_);
                }
                this.jndiName_.setRequired(true);
                this.isEJB30Enabled = false;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void enableEJB3UI(boolean isEjbProject) {
        this.enableEJB3UI(true, isEjbProject);
    }
}

