/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.deployment.ejb;

import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.deployment.ejb.EJBFacetInstallDataModelProvider;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import com.ibm.j2c.ui.internal.utilities.EJB30Utils;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPreferences;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class EJBDeploymentUtils {
    public static void addAnnotationsToCU(IFile file, List typeLevelAnnotations, List correspondingImportStatements) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
        try {
            int n = 0;
            while (n < typeLevelAnnotations.size()) {
                IType[] types;
                if (!cu.isWorkingCopy()) {
                    cu = cu.getWorkingCopy(null);
                }
                if ((types = cu.getAllTypes()) != null && types.length > 0) {
                    IType el = types[0];
                    String sAnnPackName = (String)correspondingImportStatements.get(n);
                    String sAnnotationRep = (String)typeLevelAnnotations.get(n);
                    EJBDeploymentUtils.addAnnotationToCU(cu, sAnnPackName, sAnnotationRep, (IJavaElement)el, true);
                }
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    public static void installEJB3FacetOnUtilityJavaProject(IProject pr, IProgressMonitor monitor) {
        try {
            IProjectFacet utilityFacet;
            Vector dependentProjects;
            boolean needToInstall = false;
            if (ResourceUtils.isTrueJavaProject((IProject)pr) && (dependentProjects = DeploymentHelper.instance().getConnectorProjectsOnClassPath(pr)) != null && dependentProjects.size() > 0) {
                IProject conn = (IProject)dependentProjects.get(0);
                needToInstall = EJB30Utils.doesEjb30ExistForParticularProject((IProject)conn);
            }
            if (!needToInstall) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)pr);
            IFacetedProject facetProj = ProjectFacetsManager.create((IProject)pr);
            if (facetProj.hasProjectFacet(utilityFacet = ProjectFacetsManager.getProjectFacet((String)"jst.utility"))) {
                IProjectFacetVersion ipv = facetProj.getInstalledVersion(utilityFacet);
                facetProj.uninstallProjectFacet(ipv, null, monitor);
                String configFolder = null;
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                if (roots.length != 0) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        if (root.getKind() == 1 && root.getElementName().length() > 0) {
                            configFolder = root.getElementName();
                            break;
                        }
                        ++n2;
                    }
                }
                if (configFolder == null) {
                    configFolder = EJBDeploymentUtils.getDefaultEJBContentFolder();
                }
                IDataModel udm = DataModelFactory.createDataModel((IDataModelProvider)new EJBFacetInstallDataModelProvider());
                udm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)javaProject.getProject().getName());
                udm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"3.0");
                udm.setProperty("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI", (Object)(String.valueOf(javaProject.getProject().getName()) + ".jar"));
                udm.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)configFolder);
                udm.setProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", (Object)Boolean.FALSE);
                udm.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", (Object)Boolean.TRUE);
                IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
                dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)javaProject.getProject().getName());
                IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                map.add(udm);
                dm.getDefaultOperation().execute(monitor, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getDefaultEJBContentFolder() {
        J2EEPreferences preferences = J2EEPlugin.getDefault().getJ2EEPreferences();
        String configFolder = preferences.getString("ejbContent");
        if (configFolder == null || configFolder.trim().length() == 0) {
            configFolder = "ejbModule";
        }
        return configFolder;
    }

    private static void addAnnotationToCU(ICompilationUnit cu, String sAnnPackName, String sAnnotationRep, IJavaElement el, boolean commit) {
        if (cu == null || sAnnPackName == null || sAnnotationRep == null || el == null) {
            return;
        }
        if (!sAnnotationRep.startsWith("@")) {
            return;
        }
        ASTParser parser = null;
        parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        try {
            if (!cu.isWorkingCopy()) {
                cu = cu.getWorkingCopy(null);
            }
            Document doc = new Document(cu.getSource());
            if (el instanceof ISourceReference && ((ISourceReference)el).getSourceRange() != null) {
                int in;
                int iStart = ((ISourceReference)el).getSourceRange().getOffset();
                int iLine = doc.getLineOfOffset(iStart);
                String sSource = ((ISourceReference)el).getSource();
                if (sSource != null && (in = sSource.indexOf("* @generated")) >= 0) {
                    int iTemp3;
                    int iTemp1 = doc.getLineOfOffset(in += iStart);
                    iStart = iTemp3 = doc.getLineOffset(iTemp1 + 2);
                }
                iLine = doc.getLineOfOffset(iStart);
                int iOffOfLine = doc.getLineOffset(iLine);
                String sDiff = doc.get(iOffOfLine, iStart - iOffOfLine);
                String del = null;
                String[] dels = doc.getLegalLineDelimiters();
                if (dels != null && dels.length > 0) {
                    del = dels[0];
                } else {
                    int i = doc.getNumberOfLines() - 1;
                    while (i >= 0) {
                        try {
                            String curr = doc.getLineDelimiter(i);
                            if (curr != null) {
                                del = curr;
                            }
                        }
                        catch (Exception exception) {}
                        --i;
                    }
                }
                if (del != null) {
                    int off = doc.getLineOffset(iLine);
                    String sToInsert = String.valueOf(sDiff) + sAnnotationRep + del;
                    doc.replace(off, 0, sToInsert);
                    cu.getBuffer().setContents(doc.get());
                }
            }
            parser.setSource(cu);
            CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            if (astCU == null) {
                return;
            }
            List imports = astCU.imports();
            String packName = sAnnPackName;
            String annRep = sAnnotationRep.trim();
            annRep = annRep.substring(1, annRep.length());
            int indx = annRep.indexOf("(");
            String sFullName = String.valueOf(packName) + "." + annRep;
            if (indx > 0) {
                sFullName = String.valueOf(packName) + "." + annRep.substring(0, indx);
            }
            boolean bImportFound = false;
            int b = 0;
            while (b < imports.size()) {
                ImportDeclaration impDec = (ImportDeclaration)imports.get(b);
                String sIN = impDec.getName().toString();
                if (sIN.equals(sFullName) || sIN.equals(String.valueOf(packName) + ".*")) {
                    bImportFound = true;
                    break;
                }
                ++b;
            }
            if (!bImportFound) {
                ImportDeclaration imD = astCU.getAST().newImportDeclaration();
                Name nFullName = astCU.getAST().newName(sFullName);
                imD.setName(nFullName);
                ASTRewrite rewrite1 = ASTRewrite.create((AST)astCU.getAST());
                ListRewrite lrw1 = rewrite1.getListRewrite((ASTNode)astCU, CompilationUnit.IMPORTS_PROPERTY);
                lrw1.insertLast((ASTNode)imD, null);
                TextEdit edits1 = rewrite1.rewriteAST((IDocument)doc, null);
                edits1.apply((IDocument)doc);
                cu.getBuffer().setContents(doc.get());
            }
            if (commit) {
                cu.commitWorkingCopy(true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

