/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.deployment.common.util;

import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.ResourceRefBindingImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBindingsHelper;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.deployment.common.util.CommonDeploymentUtils;
import com.ibm.j2c.ui.internal.model.IWasCommonUtils;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.jee.was.descriptors.web.WebBindingsDescriptor;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class WasCommonUtils
implements IWasCommonUtils {
    public int getWasServerVersion(IServer server) {
        int res = 0;
        if (server == null) {
            return res;
        }
        IRuntime runt = server.getRuntime();
        return this.getWasRuntimeVersion(runt);
    }

    public int getWasRuntimeVersion(IRuntime runt) {
        int res = 51;
        if (WASRuntimeUtil.isWASv60Runtime((IRuntime)runt)) {
            res = 60;
        } else if (WASRuntimeUtil.isWASv61OrLaterRuntime((IRuntime)runt)) {
            res = 61;
        }
        return res;
    }

    public void createResourceRefBinding(IVirtualComponent component1, String resourceRefName, String jndiName) {
        WebArtifactEdit editWeb1 = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)component1);
        if (editWeb1 == null) {
            return;
        }
        WebApp webApp2 = editWeb1.getWebApp();
        for (ResourceRef rR : webApp2.getResourceRefs()) {
            block11: {
                if (!rR.getName().equals(resourceRefName)) continue;
                float iVer = new Float(J2EEProjectUtilities.getJ2EEProjectVersion((IProject)component1.getProject())).floatValue() * 10.0f;
                if (iVer > 24.0f) {
                    WebBindingsDescriptor wbd = new WebBindingsDescriptor(component1.getProject());
                    try {
                        wbd.setResourceRefBinding(resourceRefName, jndiName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    ResourceRefBindingImpl refBind = new ResourceRefBindingImpl();
                    refBind.setJndiName(jndiName);
                    refBind.setBindingResourceRef(rR);
                    WebAppBinding wab = WebAppBindingsHelper.getWebAppBinding((WebApp)webApp2);
                    EList rrLst = wab.getResRefBindings();
                    ArrayList<ResourceRefBindingImpl> dupBindings = new ArrayList<ResourceRefBindingImpl>(5);
                    int w = 0;
                    while (w < rrLst.size()) {
                        String brrName;
                        ResourceRefBindingImpl rrI = (ResourceRefBindingImpl)rrLst.get(w);
                        if (rrI != null && rrI.getBindingResourceRef() != null && (brrName = rrI.getBindingResourceRef().getName()) != null && brrName.equals(resourceRefName)) {
                            dupBindings.add(rrI);
                        }
                        ++w;
                    }
                    int f = 0;
                    while (f < dupBindings.size()) {
                        rrLst.remove(dupBindings.get(f));
                        ++f;
                    }
                    wab.getResRefBindings().add((Object)refBind);
                }
                try {
                    editWeb1.save((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (editWeb1 == null) break block11;
                    editWeb1.dispose();
                }
            }
            if (editWeb1 == null) break;
            editWeb1.dispose();
            break;
        }
    }

    private String getBindingWebResRef(IProject webProj, String moduleName, String reName) {
        String result = null;
        float iVer = new Float(J2EEProjectUtilities.getJ2EEProjectVersion((IProject)webProj)).floatValue() * 10.0f;
        if (iVer > 24.0f) {
            WebBindingsDescriptor wbd = new WebBindingsDescriptor(webProj);
            try {
                result = wbd.getResourceRefBindingsName(reName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if (ResourceUtils.isDynamicWebProject((IProject)webProj)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)webProj);
            WebArtifactEdit editWeb = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
            WebApp webApp2 = editWeb.getWebApp();
            WebAppBinding wab = WebAppBindingsHelper.getWebAppBinding((WebApp)webApp2);
            for (ResourceRefBinding webResRefBind : wab.getResRefBindings()) {
                if (!webResRefBind.getBindingResourceRef().getName().equals(reName)) continue;
                result = webResRefBind.getJndiName();
                return result;
            }
            editWeb.dispose();
        }
        return result;
    }

    public String getBindingForResReference(IProject proj, String moduleName, String reName) {
        String result = null;
        if (proj != null) {
            if (ResourceUtils.isEJBProject((IProject)proj)) {
                DeploymentUtils.waitForBuildJobs((int)4);
                try {
                    EList beansList;
                    EJBJar ejbJar;
                    IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
                    EJBArtifactEdit editEJB = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                    if (editEJB != null && (ejbJar = editEJB.getEJBJar()) != null && (beansList = ejbJar.getEnterpriseBeans()) != null) {
                        Iterator newEBIter = beansList.iterator();
                        editEJB.dispose();
                        while (newEBIter.hasNext()) {
                            EnterpriseBean newEB = (EnterpriseBean)newEBIter.next();
                            EnterpriseBeanBinding ejbB = EJBBindingsHelper.getEjbBinding((EnterpriseBean)newEB);
                            for (ResourceRefBinding resB : ejbB.getResRefBindings()) {
                                if (!resB.getBindingResourceRef().getName().equals(reName)) continue;
                                result = resB.getJndiName();
                                return result;
                            }
                        }
                    }
                }
                catch (Exception w) {
                    w.printStackTrace();
                }
            } else if (ResourceUtils.isTrueJavaProject((IProject)proj)) {
                IProject webPrj = proj;
                IWorkspace workspace = ResourceUtils.getWorkspace();
                IProject[] allProjs = workspace.getRoot().getProjects();
                int i = 0;
                while (i < allProjs.length) {
                    IProject prr = allProjs[i];
                    if (ResourceUtils.isDynamicWebProject((IProject)prr)) {
                        IVirtualComponent component = ComponentCore.createComponent((IProject)prr);
                        WebArtifactEdit editWeb = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
                        IVirtualReference[] refs = editWeb.getLibModules();
                        editWeb.dispose();
                        if (refs != null) {
                            int j = 0;
                            while (j < refs.length) {
                                String res;
                                if (refs[j].getReferencedComponent().getProject().getName().equals(proj.getName()) && (res = this.getBindingWebResRef(webPrj = allProjs[i], moduleName, reName)) != null) {
                                    return res;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            } else if (ResourceUtils.isDynamicWebProject((IProject)proj)) {
                result = this.getBindingWebResRef(proj, moduleName, reName);
            }
        }
        return result;
    }

    public void updateResourceReference(String resRefName, String jndiName, IProject webProj) {
        if (resRefName != null && resRefName.length() > 0) {
            CommonDeploymentUtils.updateReference(webProj, resRefName);
            IVirtualComponent component1 = ComponentCore.createComponent((IProject)webProj);
            if (jndiName != null) {
                this.createResourceRefBinding(component1, resRefName, jndiName);
            }
        }
    }
}

