/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.rar.operations.jmx.internal.utils;

import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.j2c.rar.operations.jmx.internal.Activator;
import com.ibm.j2c.rar.operations.jmx.internal.ServerRAROperations;
import com.ibm.j2c.rar.operations.jmx.internal.messages.J2CJmxMessages;
import com.ibm.j2c.rar.operations.jmx.internal.model.MCF_RAR_Indentifier;
import com.ibm.j2c.rar.operations.jmx.internal.model.PropSet;
import com.ibm.j2c.rar.operations.jmx.internal.model.RarPublish;
import com.ibm.j2c.rar.operations.jmx.internal.utils.ServerCreationListener;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;

public class JmxUtils {
    public static final int JNDINAMES_LOOKUP_AS_MODE = 5;
    public static final int RESOURCE_SEARCH_MODE = 3;
    public static final int MCF_CLASSNAME_LOOKUP_MODE = 4;
    public static final int JNDINAMES_LOOKUP_MCF_MODE = 2;
    public static final int RAR_DEPLOY_MODE_MCF = 1;
    public static final int RAR_DEPLOY_MODE_AS = 6;

    public static IResourceAdapterDescriptor getProperResourceAdapterDescriptorFromServer(String lookupName, IProject project, Object monitor) {
        IResourceAdapterDescriptor aresD = null;
        MCF_RAR_Indentifier[] mcfAr = JmxUtils.getMCFRars(monitor, lookupName);
        IResourceAdapterRegistry raRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
        if (mcfAr.length > 0) {
            if (mcfAr.length == 1) {
                MCF_RAR_Indentifier mcfRI = null;
                mcfRI = mcfAr[0];
                try {
                    IResourceAdapterDescriptor[] ras = raRegistry.getResourceAdapters(mcfRI.getRarType(), mcfRI.getRarVersion(), mcfRI.getRarVendor());
                    if (ras.length > 0) {
                        aresD = ras[0];
                    }
                }
                catch (Exception exception) {}
            } else {
                IFacetedProject fProj = null;
                try {
                    fProj = ProjectFacetsManager.create((IProject)project);
                }
                catch (Exception exception) {}
                if (fProj != null) {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime runT = fProj.getPrimaryRuntime();
                    IRuntime rT = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runT);
                    int eq = 0;
                    while (eq < mcfAr.length) {
                        String targetRT = mcfAr[eq].getServer().getRuntime().getRuntimeType().getId();
                        if (targetRT.equals(rT.getRuntimeType().getId())) {
                            try {
                                IResourceAdapterDescriptor[] ras = raRegistry.getResourceAdapters(mcfAr[eq].getRarType(), mcfAr[eq].getRarVersion(), mcfAr[eq].getRarVendor());
                                if (ras.length > 0) {
                                    aresD = ras[0];
                                    break;
                                }
                            }
                            catch (Exception exception) {}
                        }
                        ++eq;
                    }
                }
            }
        }
        return aresD;
    }

    public static MCF_RAR_Indentifier getMCFRar(Object containerObject, String jndiName, IServer server) {
        try {
            ServerRAROperations ops = new ServerRAROperations();
            return ops.getMcfRarInfo(containerObject, jndiName, server);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MCF_RAR_Indentifier[] getMCFRars(Object containerObject, String jndiName) {
        IServer[] servers = ServerCore.getServers();
        ArrayList<MCF_RAR_Indentifier> lst = new ArrayList<MCF_RAR_Indentifier>(3);
        int i = 0;
        while (i < servers.length) {
            IServer server = servers[i];
            MCF_RAR_Indentifier rI = JmxUtils.getMCFRar(containerObject, jndiName, server);
            if (rI != null) {
                rI.setServer(server);
                lst.add(rI);
            }
            ++i;
        }
        MCF_RAR_Indentifier[] a = new MCF_RAR_Indentifier[lst.size()];
        return lst.toArray(a);
    }

    public static Vector getProps(Iterator propIter, Vector vec, Hashtable validPropNames) {
        Vector<PropSet> res = vec;
        if (res == null) {
            res = new Vector<PropSet>();
        }
        while (propIter.hasNext()) {
            String reverseName;
            EMDUtil.BeanProperty pDesc = (EMDUtil.BeanProperty)propIter.next();
            String pName = pDesc.getPropertyName();
            if (validPropNames.get(pName) == null && validPropNames.get(reverseName = JmxUtils.reverseCasing(pName)) != null) {
                pName = reverseName;
            }
            Object oValue = pDesc.getPropertyValue();
            String pValue = null;
            if (oValue != null) {
                pValue = oValue.toString();
            }
            boolean pReq = false;
            String sType = pDesc.getPropertyType().getName();
            PropSet pSet = new PropSet(pName, sType, pValue, pReq);
            res.add(pSet);
        }
        return res;
    }

    private static String reverseCasing(String str) {
        int firstChar = UTF16.charAt((String)str, (int)0);
        firstChar = UCharacter.isLowerCase((int)firstChar) ? UCharacter.toUpperCase((int)firstChar) : UCharacter.toLowerCase((int)firstChar);
        return String.valueOf(UCharacter.toString((int)firstChar)) + str.substring(1);
    }

    public static boolean resourceExists(IWizardContainer container, String jndiName, IServer server, IProject connectorProject, List connectionProperties, String eisType, String vendorName, String version, String displayName) {
        boolean res = false;
        ServerRAROperations ops = new ServerRAROperations();
        try {
            ops.setEisType(eisType);
            ops.setVendorName(vendorName);
            ops.setConnectorVersion(version);
            ops.setDisplayName(displayName);
            boolean resVec = ops.resourceExists(container, jndiName, server, connectorProject, connectionProperties);
            return resVec;
        }
        catch (Exception e) {
            res = false;
            e.printStackTrace();
            return res;
        }
    }

    public static void deployRARStandAlone(IProject deployableProj, IModule earMod, String sServerId, IProject connectorProject, List connectionProperties, boolean createJNDIAlias, String JNDIName, String resRef, Shell shell, String eisType, String vendorName, String version, String displayName) {
        if (sServerId == null) {
            ServerCreationListener listener = new ServerCreationListener(earMod, connectorProject, connectionProperties, createJNDIAlias, JNDIName, resRef, shell, eisType, vendorName, version, displayName);
            ServerCore.addServerLifecycleListener((IServerLifecycleListener)listener);
            return;
        }
        IServer server = ServerCore.findServer((String)sServerId);
        if (server == null || server.getName().equals("")) {
            MessageDialog.openWarning((Shell)shell, (String)J2CJmxMessages.WARNING_WIZARDS_TITLE_RAR_DEPLOYMENT, (String)J2CJmxMessages.WARNING_WIZARDS_TEXT_RAR_DEPLOYMENT);
            return;
        }
        ServerRAROperations ops = new ServerRAROperations();
        ops.setEisType(eisType);
        ops.setVendorName(vendorName);
        ops.setConnectorVersion(version);
        ops.setDisplayName(displayName);
        ops.deployRARStandAlone(earMod, sServerId, connectorProject, connectionProperties, createJNDIAlias, JNDIName, shell);
    }

    public static void restartModuleOnServer(IServer server, IModule module, IProgressMonitor monitor) {
        int state;
        if (server != null && module != null && (state = server.getServerState()) == 2) {
            try {
                IModule[] arrMod = new IModule[]{module};
                if (server.canControlModule(arrMod, monitor).isOK()) {
                    server.restartModule(arrMod, new IServer.IOperationListener(){

                        public void done(IStatus result) {
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void publishRAR(IServer server, IProgressMonitor localMonitor, String sName, String sVendorName, String sVersion, IProject connectorProject, String fileName) {
        int serverVersion = JmxUtils.getWasServerVersion(server);
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.j2c.ui.RARServerDeploymentInfo");
        IExtension[] extensions = extensionPoint.getExtensions();
        int r = 0;
        while (r < extensions.length) {
            IExtension currentEx = extensions[r];
            IConfigurationElement[] configEls = currentEx.getConfigurationElements();
            int y = 0;
            while (y < configEls.length) {
                IConfigurationElement currentConEl = configEls[y];
                String servVer = currentConEl.getAttribute("serverVersion");
                if (serverVersion == 61 && servVer.equals("6.1") || serverVersion == 60 && servVer.equals("6.0") || serverVersion == 70 && servVer.equals("7.0")) {
                    try {
                        RarPublish ops = (RarPublish)currentConEl.createExecutableExtension("deploymentClassName");
                        String sPath = String.valueOf(Activator.getDefault().getStateLocation().toString()) + "/" + fileName + ".rar";
                        ResourceUtils.exportRarFile((IProject)connectorProject, (String)sPath, (IProgressMonitor)localMonitor);
                        ops.publishRar(sPath, server, localMonitor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++y;
            }
            ++r;
        }
    }

    private static int getWasServerVersion(IServer server) {
        int res = 0;
        if (server == null) {
            return res;
        }
        IRuntime runt = server.getRuntime();
        if (WASRuntimeUtil.isWASv60Runtime((IRuntime)runt)) {
            res = 60;
        } else if (WASRuntimeUtil.isWASv61Runtime((IRuntime)runt)) {
            res = 61;
        } else if (WASRuntimeUtil.isWASv70OrLaterRuntime((IRuntime)runt)) {
            res = 70;
        }
        return res;
    }

    public static void addClassPathEntries(ConfigServiceProxy configService, ObjectName ra, ArrayList<String> vals) {
        String[] ar = new String[]{"classpath"};
        JmxUtils.addPathEntries(configService, ra, ar, vals);
    }

    public static ArrayList getClassPathEntries(ConfigServiceProxy configService, ObjectName ra) {
        String[] ar = new String[]{"classpath"};
        return JmxUtils.getPathEntries(configService, ra, ar);
    }

    public static ArrayList getNativePathEntries(ConfigServiceProxy configService, ObjectName ra) {
        String[] ar = new String[]{"nativepath"};
        return JmxUtils.getPathEntries(configService, ra, ar);
    }

    public static void addNativePathEntries(ConfigServiceProxy configService, ObjectName ra, ArrayList<String> vals) {
        String[] ar = new String[]{"nativepath"};
        JmxUtils.addPathEntries(configService, ra, ar, vals);
    }

    public static void markAsSeparateClassLoader(ConfigServiceProxy configService, ObjectName ra) {
        String[] ar = new String[]{"isolatedClassLoader"};
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("true");
        JmxUtils.modifyAttribute(configService, ra, ar, vals);
    }

    private static void modifyAttribute(ConfigServiceProxy configService, ObjectName ra, String[] ar, ArrayList<String> vals) {
        try {
            Session session2 = new Session();
            AttributeList at1 = configService.getAttributes(session2, ra, ar, false);
            if (at1 != null) {
                Attribute oldAttr = null;
                int i = 0;
                while (i < at1.size()) {
                    Attribute att = (Attribute)at1.get(i);
                    if (att.getName().equals(ar[0])) {
                        oldAttr = att;
                    }
                    ++i;
                }
                if (oldAttr != null) {
                    at1.remove(oldAttr);
                    Attribute newAttr = new Attribute(ar[0], new Boolean(true));
                    at1.add(0, newAttr);
                }
                configService.setAttributes(session2, ra, at1);
                configService.save(session2, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addPathEntries(ConfigServiceProxy configService, ObjectName ra, String[] ar, ArrayList<String> vals) {
        try {
            Session session2 = new Session();
            AttributeList at1 = configService.getAttributes(session2, ra, ar, false);
            if (at1 != null) {
                Attribute oldAttr = null;
                int i = 0;
                while (i < at1.size()) {
                    Attribute att = (Attribute)at1.get(i);
                    if (att.getName().equals(ar[0])) {
                        oldAttr = att;
                    }
                    ++i;
                }
                if (oldAttr != null) {
                    ArrayList newVal = (ArrayList)oldAttr.getValue();
                    int k = 0;
                    while (k < vals.size()) {
                        String sTemp = vals.get(k);
                        if (!newVal.contains(sTemp)) {
                            newVal.add(sTemp);
                        }
                        ++k;
                    }
                    at1.remove(oldAttr);
                    Attribute newAttr = new Attribute(ar[0], newVal);
                    at1.add(0, newAttr);
                }
                configService.setAttributes(session2, ra, at1);
                configService.save(session2, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ArrayList getPathEntries(ConfigServiceProxy configService, ObjectName ra, String[] ar) {
        ArrayList res = new ArrayList();
        try {
            Session session2 = new Session();
            AttributeList at1 = configService.getAttributes(session2, ra, ar, false);
            if (at1 != null) {
                Attribute oldAttr = null;
                int i = 0;
                while (i < at1.size()) {
                    Attribute att = (Attribute)at1.get(i);
                    if (att.getName().equals(ar[0])) {
                        oldAttr = att;
                    }
                    ++i;
                }
                if (oldAttr != null) {
                    res = (ArrayList)oldAttr.getValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static boolean areArrayListsEqual(ArrayList al1, ArrayList al2) {
        if (al1 == null && al2 == null) {
            return true;
        }
        if (al1 != null && al2 == null) {
            return false;
        }
        if (al1 == null && al2 != null) {
            return false;
        }
        return al1.containsAll(al2);
    }
}

