/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.rar.operations.jmx.internal;

import com.ibm.adapter.j2ca.ConnectorProjectDescriptor;
import com.ibm.j2c.rar.operations.jmx.internal.messages.J2CJmxMessages;
import com.ibm.j2c.rar.operations.jmx.internal.model.MCFInfo;
import com.ibm.j2c.rar.operations.jmx.internal.model.MCF_RAR_Indentifier;
import com.ibm.j2c.rar.operations.jmx.internal.model.PropSet;
import com.ibm.j2c.rar.operations.jmx.internal.utils.JmxUtils;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import com.ibm.ws.ast.st.jmx.core.IWebSphereJMXConnection;
import com.ibm.ws.ast.st.jmx.core.WebSphereJMXUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;

public class DeployFilesJob
extends Job
implements IServerListener,
IPublishListener {
    private IProject project;
    private IServer server;
    private boolean setJNDIName = false;
    private List connectionProperties;
    private String jndiName = null;
    private String sEisType = null;
    private String sVersion = null;
    private String sVendorName = null;
    private String sDisplayName = null;
    private Vector pVec;
    private IModule module;
    private int mode = 1;
    private Vector factoryJNDINames;
    private boolean resourceExist = false;
    private String mcfClassName;
    private boolean serverWasStarted = true;
    private IProgressMonitor localMonitor = new NullProgressMonitor();
    private MCF_RAR_Indentifier mcfRar;
    private ArrayList<String> refPaths = new ArrayList();
    private ArrayList<String> copPaths = new ArrayList();
    private String asType;
    private String listenerName;

    public String getMCFClassName() {
        return this.mcfClassName;
    }

    public boolean isResourceExist() {
        return this.resourceExist;
    }

    public void setMode(int e) {
        this.mode = e;
    }

    public void setModule(IModule mod) {
        this.module = mod;
    }

    public Vector getJNDINames() {
        return this.factoryJNDINames;
    }

    public void setConnectionProperties(List connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setSetJNDIName(boolean setJNDIName) {
        this.setJNDIName = setJNDIName;
    }

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    public DeployFilesJob(String name, IProject project, IServer server, String eisType, String version, String vendorName, String displayName) {
        super(name);
        this.project = project;
        this.server = server;
        this.sEisType = eisType;
        this.sVersion = version;
        this.sVendorName = vendorName;
        this.setSDisplayName(displayName);
        this.initAdapterClassPathVars();
    }

    protected IStatus run(IProgressMonitor monitor) {
        block18: {
            this.localMonitor = monitor;
            this.serverWasStarted = true;
            while (this.server.getServerState() == 1) {
                this.serverWasStarted = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            boolean installNewRA = true;
            try {
                if (this.mode == 4) {
                    IWebSphereJMXConnection con = WebSphereJMXUtil.getWebSphereJMXConnection((IServer)this.server);
                    ConfigServiceProxy configService = con.getConfigServiceProxy();
                    Session session = new Session();
                    ObjectName rra = ConfigServiceHelper.createObjectName(null, (String)"J2CResourceAdapter", null);
                    ObjectName[] matches = configService.queryConfigObjects(session, null, rra, null);
                    int i = 0;
                    while (i < matches.length) {
                        ObjectName fact = ConfigServiceHelper.createObjectName(null, (String)"J2CConnectionFactory", null);
                        ObjectName[] conFactMatches = configService.queryConfigObjects(session, matches[i], fact, null);
                        int ii = 0;
                        while (ii < conFactMatches.length) {
                            String atr = (String)configService.getAttribute(session, conFactMatches[ii], "jndiName");
                            if (atr != null && atr.equals(this.jndiName)) {
                                this.mcfClassName = this.getManagedConnectionFactoryClassName(new Session(), configService, matches[i]);
                                this.mcfRar = this.getMcfRarObject(session, configService, matches[i], this.mcfClassName);
                                return new Status(0, "com.ibm.j2c.rar.operations.jmx", 0, J2CJmxMessages.MCF_CLASSNAME_FOUND, null);
                            }
                            ++ii;
                        }
                        ++i;
                    }
                    return new Status(0, "com.ibm.j2c.rar.operations.jmx", 0, J2CJmxMessages.MCF_CLASSNAME_NOT_FOUND, null);
                }
                if (this.mode == 1 || this.mode == 6) {
                    if (installNewRA) {
                        this.server.addPublishListener((IPublishListener)this);
                        if (this.server.getServerState() == 2) {
                            this.server.publish(3, monitor);
                        }
                    }
                    break block18;
                }
                if (this.mode == 2 || this.mode == 5) {
                    if (!this.serverWasStarted) {
                        this.server.publish(1, monitor);
                    }
                    IWebSphereJMXConnection con = WebSphereJMXUtil.getWebSphereJMXConnection((IServer)this.server);
                    ConfigServiceProxy configService = con.getConfigServiceProxy();
                    Session session = new Session();
                    ObjectName rra = ConfigServiceHelper.createObjectName(null, (String)"J2CResourceAdapter", null);
                    ObjectName[] matches = configService.queryConfigObjects(session, null, rra, null);
                    int i = 0;
                    while (i < matches.length) {
                        boolean adapterFound = this.sameConnectorProps(session, configService, matches[i]);
                        if (adapterFound) {
                            installNewRA = false;
                            this.factoryJNDINames = this.getAllFactories(session, configService, matches[i]);
                            break block18;
                        }
                        ++i;
                    }
                    break block18;
                }
                if (this.mode == 3 && this.jndiName != null && this.jndiName.length() > 0) {
                    boolean exists = this.resourceExists(this.jndiName);
                    this.resourceExist = exists;
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                return new Status(4, "com.ibm.j2c.rar.operations.jmx", 4, J2CJmxMessages.RAR_DEPLOY_FAILED, null);
            }
        }
        if (this.server != null && this.module != null) {
            JmxUtils.restartModuleOnServer(this.server, this.module, monitor);
        }
        return new Status(0, "com.ibm.j2c.rar.operations.jmx", 0, J2CJmxMessages.RAR_DEPLOYED_SUCCESSFULLY, null);
    }

    private void populateJ2EEPropSet(Iterator propIter, ObjectName set, ConfigServiceProxy cs, Session session, Hashtable validProps) {
        this.pVec = new Vector();
        this.pVec = JmxUtils.getProps(propIter, this.pVec, validProps);
        for (PropSet pSet : this.pVec) {
            AttributeList provAttrs = new AttributeList();
            provAttrs.add(new Attribute("name", pSet.getPName()));
            provAttrs.add(new Attribute("type", pSet.getPType()));
            if (this.sEisType.equals("SAP") && pSet.getPName().equals("BONamespace") && pSet.getPValue() != null) {
                provAttrs.add(new Attribute("value", pSet.getPValue().replaceFirst("http://www.ibm.com", "com.ibm").replaceAll("/", ".")));
            } else {
                provAttrs.add(new Attribute("value", pSet.getPValue()));
            }
            provAttrs.add(new Attribute("required", new Boolean(pSet.getPRequired())));
            try {
                cs.createConfigData(session, set, "resourceProperties", "J2EEResourceProperty", provAttrs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addJ2CConectionFactory(Session session, ConfigServiceProxy configService, ObjectName ra) {
        AttributeList provAttrs = new AttributeList();
        String name = "";
        int ii = new Random().nextInt();
        if (ii > 0) {
            ii *= -1;
        }
        if (name.length() == 0 && this.mode == 1) {
            name = "J2CConnectionFactory" + ii;
        } else if (name.length() == 0 && this.mode == 6) {
            name = "J2CActivationSpec" + ii;
        }
        provAttrs.add(new Attribute("name", name));
        provAttrs.add(new Attribute("jndiName", this.jndiName));
        try {
            ObjectName j2cFact = null;
            AttributeList propSetAttrs = new AttributeList();
            ObjectName propertySet = null;
            if (this.mode == 1) {
                j2cFact = configService.createConfigData(session, ra, "J2CConnectionFactory", "J2CConnectionFactory", provAttrs);
                propertySet = configService.createConfigData(session, j2cFact, "propertySet", "", propSetAttrs);
                Hashtable validProps = this.getValidMCFPropNames(session, configService, ra);
                this.populateJ2EEPropSet(this.connectionProperties.iterator(), propertySet, configService, session, validProps);
            } else if (this.mode == 6) {
                Attribute activationSepc = this.getActivationSpec(session, configService, ra);
                ObjectName as = ConfigServiceHelper.createObjectName((AttributeList)((AttributeList)activationSepc.getValue()));
                provAttrs.add(new Attribute("description", ""));
                provAttrs.add(new Attribute("authenticationAlias", ""));
                provAttrs.add(new Attribute("destinationJndiName", ""));
                provAttrs.add(new Attribute("activationSpec", as));
                ObjectName j2cAS = configService.createConfigData(session, ra, "j2cActivationSpec", "J2CActivationSpec", provAttrs);
                Hashtable h = this.getASPropNames(session, configService, ra);
                this.populateJ2EEPropSet(this.connectionProperties.iterator(), j2cAS, configService, session, h);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Attribute getActivationSpec(Session session, ConfigServiceProxy configService, ObjectName ra) {
        try {
            AttributeList attrList = (AttributeList)configService.getAttribute(session, ra, "deploymentDescriptor");
            for (Attribute attr : attrList) {
                if (!attr.getName().equals("resourceAdapter")) continue;
                List l2 = (List)attr.getValue();
                for (Attribute outbAtrr : l2) {
                    if (!outbAtrr.getName().equals("inboundResourceAdapter")) continue;
                    AttributeList outbProps = (AttributeList)outbAtrr.getValue();
                    for (Attribute outbProp : outbProps) {
                        if (!outbProp.getName().equals("messageAdapter")) continue;
                        ArrayList connPrps = (ArrayList)outbProp.getValue();
                        for (Attribute outcProp : connPrps) {
                            if (!outcProp.getName().equals("messageListeners")) continue;
                            ArrayList lisPrps = (ArrayList)outcProp.getValue();
                            for (AttributeList outdProps : lisPrps) {
                                for (Attribute outeProp : outdProps) {
                                    AttributeList outeProps;
                                    Attribute outfProp;
                                    if (!outeProp.getName().equals("activationSpec") || !this.asType.equals((outfProp = (Attribute)(outeProps = (AttributeList)outeProp.getValue()).get(0)).getValue())) continue;
                                    this.listenerName = (String)((Attribute)outdProps.get(0)).getValue();
                                    return outeProp;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ObjectName factoryExists(Session session, ConfigServiceProxy configService, ObjectName ra, String jndiName) {
        ObjectName result = null;
        try {
            ObjectName fact = null;
            if (this.mode == 1) {
                fact = ConfigServiceHelper.createObjectName(null, (String)"J2CConnectionFactory", null);
            } else if (this.mode == 6) {
                fact = ConfigServiceHelper.createObjectName(null, (String)"J2CActivationSpec", null);
            }
            ObjectName[] conFactMatches = configService.queryConfigObjects(session, ra, fact, null);
            int i = 0;
            while (i < conFactMatches.length) {
                String atr = (String)configService.getAttribute(session, conFactMatches[i], "jndiName");
                if (atr.equals(jndiName)) {
                    result = conFactMatches[i];
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Vector getAllFactories(Session session, ConfigServiceProxy configService, ObjectName ra) {
        Vector<MCFInfo> result = new Vector<MCFInfo>();
        ObjectName fact = null;
        if (this.mode == 5) {
            fact = ConfigServiceHelper.createObjectName(null, (String)"J2CActivationSpec", null);
        } else if (this.mode == 2) {
            fact = ConfigServiceHelper.createObjectName(null, (String)"J2CConnectionFactory", null);
        }
        if (fact == null) {
            return result;
        }
        try {
            ObjectName[] conFactMatches = configService.queryConfigObjects(session, ra, fact, null);
            int i = 0;
            while (i < conFactMatches.length) {
                String atr = (String)configService.getAttribute(session, conFactMatches[i], "jndiName");
                Hashtable validNames = this.getFactoryResourceProps(session, configService, conFactMatches[i]);
                MCFInfo mcfInf = new MCFInfo(atr, validNames);
                result.add(mcfInf);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sameFactoryProps(Session session, ConfigServiceProxy configService, ObjectName fact, Hashtable validProps) {
        boolean result = true;
        try {
            if (this.pVec == null) {
                this.pVec = JmxUtils.getProps(this.connectionProperties.iterator(), this.pVec, validProps);
            }
            Iterator iter = this.pVec.iterator();
            AttributeList attrList = (AttributeList)configService.getAttribute(session, fact, "propertySet");
            Iterator iterTemp = attrList.iterator();
            List propValuesLst = null;
            boolean resourcePropertiesFound = false;
            while (iterTemp.hasNext()) {
                Attribute atrTemp = (Attribute)iterTemp.next();
                if (!atrTemp.getName().equals("resourceProperties")) continue;
                resourcePropertiesFound = true;
                propValuesLst = (List)atrTemp.getValue();
                break;
            }
            if (!resourcePropertiesFound) {
                return false;
            }
            if (propValuesLst == null) return false;
            if (this.pVec.size() != propValuesLst.size()) {
                return false;
            }
            block3: while (true) {
                if (!iter.hasNext()) {
                    return result;
                }
                PropSet pSet = (PropSet)iter.next();
                boolean propertyFound = false;
                int i = 0;
                while (true) {
                    block15: {
                        if (i >= propValuesLst.size()) {
                            if (propertyFound) continue block3;
                            return false;
                        }
                        String name = "";
                        String value = "";
                        AttributeList prop = (AttributeList)propValuesLst.get(i);
                        Iterator iterTemp2 = prop.iterator();
                        while (true) {
                            if (!iterTemp2.hasNext()) {
                                if (name.equals(pSet.getPName())) {
                                    propertyFound = true;
                                    if (value != null) break;
                                    return false;
                                }
                                break block15;
                            }
                            Attribute aNext = (Attribute)iterTemp2.next();
                            if (aNext.getName().equals("name")) {
                                name = (String)aNext.getValue();
                                continue;
                            }
                            if (!aNext.getName().equals("value")) continue;
                            value = (String)aNext.getValue();
                        }
                        if (!value.equals(pSet.getPValue())) {
                            return false;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean sameASProps(Session session, ConfigServiceProxy configService, ObjectName fact, Hashtable validProps) {
        return false;
    }

    private boolean sameConnectorProps(Session session, ConfigServiceProxy configService, ObjectName ra) {
        boolean sameVendorName = false;
        boolean sameEisType = false;
        boolean sameVersion = false;
        boolean sameDisplayName = false;
        try {
            AttributeList attrList = (AttributeList)configService.getAttribute(session, ra, "deploymentDescriptor");
            for (Attribute attr : attrList) {
                if (attr.getName().equals("vendorName")) {
                    if (!attr.getValue().equals(this.sVendorName)) continue;
                    sameVendorName = true;
                    continue;
                }
                if (attr.getName().equals("version")) {
                    if (!attr.getValue().equals(this.sVersion)) continue;
                    sameVersion = true;
                    continue;
                }
                if (attr.getName().equals("eisType")) {
                    if (!attr.getValue().equals(this.sEisType)) continue;
                    sameEisType = true;
                    continue;
                }
                if (!attr.getName().equals("displayName") || !attr.getValue().equals(this.sDisplayName)) continue;
                sameDisplayName = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sameVendorName && sameVersion && sameEisType && sameDisplayName) {
            if (WASRuntimeUtil.isWASv70Server((IServer)this.server)) {
                boolean b = true;
                if (this.sEisType.equals("CICS") || this.sEisType.equals("IMS")) {
                    b = this.areTheClassPathEntriesSame(this.refPaths, this.copPaths, ra);
                }
                return b;
            }
            return true;
        }
        return false;
    }

    private MCF_RAR_Indentifier getMcfRarObject(Session session, ConfigServiceProxy configService, ObjectName ra, String className) {
        String localVendorName = null;
        String localEisType = null;
        String localVersion = null;
        try {
            AttributeList attrList = (AttributeList)configService.getAttribute(session, ra, "deploymentDescriptor");
            for (Attribute attr : attrList) {
                if (attr.getName().equals("vendorName")) {
                    localVendorName = (String)attr.getValue();
                    continue;
                }
                if (attr.getName().equals("version")) {
                    localVersion = (String)attr.getValue();
                    continue;
                }
                if (!attr.getName().equals("displayName")) continue;
                localEisType = (String)attr.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new MCF_RAR_Indentifier(className, localVendorName, localVersion, localEisType);
    }

    public MCF_RAR_Indentifier getMCF() {
        return this.mcfRar;
    }

    private String getManagedConnectionFactoryClassName(Session session, ConfigServiceProxy configService, ObjectName ra) {
        String res = null;
        try {
            AttributeList attrList = (AttributeList)configService.getAttribute(session, ra, "deploymentDescriptor");
            for (Attribute attr : attrList) {
                if (!attr.getName().equals("resourceAdapter")) continue;
                AttributeList raList = (AttributeList)attr.getValue();
                for (Attribute raAttr : raList) {
                    if (!raAttr.getName().equals("managedConnectionFactoryClass")) continue;
                    res = (String)raAttr.getValue();
                }
                if (res != null) continue;
                for (Attribute outbAtrr : raList) {
                    if (!outbAtrr.getName().equals("outboundResourceAdapter")) continue;
                    AttributeList outbProps = (AttributeList)outbAtrr.getValue();
                    for (Attribute outbProp : outbProps) {
                        if (!outbProp.getName().equals("connectionDefinitions")) continue;
                        ArrayList connPrps = (ArrayList)outbProp.getValue();
                        for (AttributeList connPrpLst : connPrps) {
                            for (Attribute connPrp : connPrpLst) {
                                if (!connPrp.getName().equals("managedConnectionFactoryClass")) continue;
                                res = (String)connPrp.getValue();
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private Hashtable getASPropNames(Session session, ConfigServiceProxy configService, ObjectName ra) {
        Attribute activationSepc = this.getActivationSpec(session, configService, ra);
        String s = "";
        AttributeList actSpecList = (AttributeList)activationSepc.getValue();
        for (Object at : actSpecList) {
            if (!((Attribute)at).getName().equals("_Websphere_Config_Data_Id")) continue;
            s = ((Attribute)at).getValue().toString();
        }
        Hashtable<Object, Object> h = new Hashtable<Object, Object>();
        try {
            Boolean done = false;
            ArrayList attrList = (ArrayList)configService.getAttribute(session, ra, "activationSpecTemplateProps");
            for (AttributeList as2 : attrList) {
                Boolean match = false;
                for (Object t : as2) {
                    if (!((Attribute)t).getName().equals("activationSpec")) continue;
                    ObjectName o = (ObjectName)((Attribute)t).getValue();
                    match = o.getKeyProperty("_Websphere_Config_Data_Id").equals(s);
                    break;
                }
                if (!match.booleanValue()) continue;
                for (Attribute as3 : as2) {
                    if (!as3.getName().equals("resourceProperties")) continue;
                    ArrayList as4 = (ArrayList)as3.getValue();
                    for (AttributeList as5 : as4) {
                        for (Attribute as6 : as5) {
                            if (as6.getName().equals("name")) {
                                h.put(as6.getValue(), as6.getValue());
                            }
                            done = true;
                        }
                    }
                    if (done.booleanValue()) break;
                }
                if (!done.booleanValue()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return h;
    }

    private Hashtable getValidMCFPropNames(Session session, ConfigServiceProxy configService, ObjectName ra) {
        Hashtable<Object, Object> res = new Hashtable<Object, Object>();
        try {
            if (this.mode == 1) {
                AttributeList attrList = (AttributeList)configService.getAttribute(session, ra, "deploymentDescriptor");
                for (Attribute attr : attrList) {
                    if (!attr.getName().equals("resourceAdapter")) continue;
                    AttributeList raList = (AttributeList)attr.getValue();
                    for (Attribute raAttr : raList) {
                        if (!raAttr.getName().equals("configProperties")) continue;
                        ArrayList configPrps = (ArrayList)raAttr.getValue();
                        for (AttributeList aatrList : configPrps) {
                            for (Attribute aatrAtr : aatrList) {
                                if (!aatrAtr.getName().equals("name")) continue;
                                res.put(aatrAtr.getValue(), aatrAtr.getValue());
                            }
                        }
                    }
                    if (!res.isEmpty()) continue;
                    for (Attribute outbAtrr : raList) {
                        if (!outbAtrr.getName().equals("outboundResourceAdapter")) continue;
                        AttributeList outbProps = (AttributeList)outbAtrr.getValue();
                        for (Attribute outbProp : outbProps) {
                            if (!outbProp.getName().equals("connectionDefinitions")) continue;
                            ArrayList connPrps = (ArrayList)outbProp.getValue();
                            for (AttributeList connPrpLst : connPrps) {
                                for (Attribute connPrp : connPrpLst) {
                                    if (!connPrp.getName().equals("configProperties")) continue;
                                    ArrayList configPrps = (ArrayList)connPrp.getValue();
                                    for (AttributeList aatrList : configPrps) {
                                        for (Attribute aatrAtr : aatrList) {
                                            if (!aatrAtr.getName().equals("name")) continue;
                                            res.put(aatrAtr.getValue(), aatrAtr.getValue());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean resourceExists(String jdniName) {
        boolean res = false;
        IWebSphereJMXConnection con = WebSphereJMXUtil.getWebSphereJMXConnection((IServer)this.server);
        ConfigServiceProxy configService = con.getConfigServiceProxy();
        Session session = new Session();
        ObjectName rra = ConfigServiceHelper.createObjectName(null, (String)"J2CResourceAdapter", null);
        try {
            ObjectName[] matches = configService.queryConfigObjects(session, null, rra, null);
            int i = 0;
            while (true) {
                if (i >= matches.length) {
                    return res;
                }
                boolean adapterFound = this.sameConnectorProps(session, configService, matches[i]);
                if (adapterFound) {
                    ObjectName fact = null;
                    if (this.mode == 1) {
                        fact = ConfigServiceHelper.createObjectName(null, (String)"J2CConnectionFactory", null);
                    } else if (this.mode == 6) {
                        fact = ConfigServiceHelper.createObjectName(null, (String)"J2CActivationSpec", null);
                    }
                    try {
                        ObjectName[] conFactMatches = configService.queryConfigObjects(session, matches[i], fact, null);
                        int ii = 0;
                        while (true) {
                            if (ii >= conFactMatches.length) {
                                return res;
                            }
                            String atr = (String)configService.getAttribute(session, conFactMatches[ii], "jndiName");
                            if (atr.equals(this.jndiName)) {
                                return true;
                            }
                            ++ii;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return res;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private Hashtable getFactoryResourceProps(Session session, ConfigServiceProxy configService, ObjectName fact) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            AttributeList attrList = null;
            if (this.mode == 5) {
                attrList = configService.getAttributes(session, fact, null, true);
            } else if (this.mode == 2) {
                attrList = (AttributeList)configService.getAttribute(session, fact, "propertySet");
            } else {
                return result;
            }
            Iterator iterTemp = attrList.iterator();
            List propValuesLst = null;
            boolean resourcePropertiesFound = false;
            while (iterTemp.hasNext()) {
                Attribute atrTemp = (Attribute)iterTemp.next();
                if (!atrTemp.getName().equals("resourceProperties")) continue;
                resourcePropertiesFound = true;
                propValuesLst = (List)atrTemp.getValue();
                break;
            }
            if (!resourcePropertiesFound) {
                return result;
            }
            if (propValuesLst == null) {
                return result;
            }
            int i = 0;
            while (i < propValuesLst.size()) {
                String name = "";
                String value = "";
                AttributeList prop = (AttributeList)propValuesLst.get(i);
                for (Attribute aNext : prop) {
                    if (aNext.getName().equals("name")) {
                        name = (String)aNext.getValue();
                        continue;
                    }
                    if (!aNext.getName().equals("value")) continue;
                    value = (String)aNext.getValue();
                }
                if (name != null && value != null) {
                    result.put(name, value);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        return result;
    }

    public void serverChanged(ServerEvent event) {
        event.getKind();
    }

    public void publishFinished(IServer server, IStatus status) {
    }

    public void publishStarted(IServer server) {
        block21: {
            try {
                boolean adapterFound = false;
                IWebSphereJMXConnection con = WebSphereJMXUtil.getWebSphereJMXConnection((IServer)server);
                if (con == null) {
                    System.out.println("***unable to get connection from server***");
                    return;
                }
                ConfigServiceProxy configService = con.getConfigServiceProxy();
                Session session = new Session();
                ObjectName resourceAdapter = null;
                ObjectName rra = null;
                rra = ConfigServiceHelper.createObjectName(null, (String)"J2CResourceAdapter", null);
                ObjectName[] matches = configService.queryConfigObjects(session, null, rra, null);
                int i = 0;
                while (i < matches.length && !adapterFound) {
                    adapterFound = this.sameConnectorProps(session, configService, matches[i]);
                    if (adapterFound && WASRuntimeUtil.isWASv70Server((IServer)server)) {
                        adapterFound &= this.areTheClassPathEntriesSame(this.refPaths, this.copPaths, matches[i]);
                    }
                    if (adapterFound) {
                        resourceAdapter = matches[i];
                    }
                    ++i;
                }
                if (adapterFound) {
                    if (this.setJNDIName) {
                        Hashtable validProps;
                        ObjectName conF = this.factoryExists(session, configService, resourceAdapter, this.jndiName);
                        if (conF == null) {
                            this.addJ2CConectionFactory(session, configService, resourceAdapter);
                            configService.save(session, true);
                        } else if (this.mode == 1 ? !this.sameFactoryProps(session, configService, conF, validProps = this.getValidMCFPropNames(session, configService, resourceAdapter)) : this.mode == 6 && !this.sameASProps(session, configService, conF, validProps = this.getASPropNames(session, configService, resourceAdapter))) {
                            return;
                        }
                    }
                    break block21;
                }
                String sTargetName = this.project.getName();
                if (WASRuntimeUtil.isWASv70Server((IServer)server) && this.doesNameExists(sTargetName)) {
                    int ii = new Random().nextInt();
                    sTargetName = String.valueOf(sTargetName) + ii;
                }
                JmxUtils.publishRAR(server, this.localMonitor, this.sEisType, this.sVendorName, this.sVersion, this.project, sTargetName);
                try {
                    IWebSphereJMXConnection con3 = WebSphereJMXUtil.getWebSphereJMXConnection((IServer)server);
                    ConfigServiceProxy configService3 = con3.getConfigServiceProxy();
                    Session session3 = new Session();
                    ObjectName rra3 = null;
                    rra3 = ConfigServiceHelper.createObjectName(null, (String)"J2CResourceAdapter", null);
                    ObjectName[] matches3 = configService3.queryConfigObjects(session3, null, rra3, null);
                    String prName = sTargetName;
                    if (prName.lastIndexOf("/") != 1) {
                        prName = prName.substring(prName.lastIndexOf("/") + 1);
                    }
                    int i2 = 0;
                    while (i2 < matches3.length) {
                        String atr = (String)configService3.getAttribute(session3, matches3[i2], "name");
                        if (atr.equals(sTargetName)) {
                            ObjectName ra = matches3[i2];
                            if (this.refPaths.size() > 0 || this.copPaths.size() > 0) {
                                if (this.refPaths.size() > 0) {
                                    JmxUtils.addNativePathEntries(configService3, ra, this.refPaths);
                                }
                                if (this.copPaths.size() > 0) {
                                    JmxUtils.addClassPathEntries(configService3, ra, this.copPaths);
                                }
                                configService3.save(session3, true);
                            }
                            if (this.setJNDIName) {
                                this.addJ2CConectionFactory(session3, configService3, ra);
                                configService3.save(session3, true);
                            }
                            break;
                        }
                        ++i2;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        server.removePublishListener((IPublishListener)this);
    }

    private boolean areTheClassPathEntriesSame(ArrayList refPaths, ArrayList copPaths, ObjectName ra) {
        try {
            IWebSphereJMXConnection con3 = WebSphereJMXUtil.getWebSphereJMXConnection((IServer)this.server);
            ConfigServiceProxy configService3 = con3.getConfigServiceProxy();
            ArrayList newRef = JmxUtils.getNativePathEntries(configService3, ra);
            ArrayList newCop = JmxUtils.getClassPathEntries(configService3, ra);
            boolean b1 = JmxUtils.areArrayListsEqual(newRef, refPaths);
            boolean b2 = JmxUtils.areArrayListsEqual(newCop, copPaths);
            return b1 && b2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void initAdapterClassPathVars() {
        String spath;
        URI u;
        int t;
        if (this.project == null) {
            return;
        }
        ConnectorProjectDescriptor cpd = new ConnectorProjectDescriptor(this.project);
        URI[] refUs = cpd.getReferencedClasspathEntries();
        URI[] copUs = cpd.getCopiedClasspathEntries();
        ArrayList<String> parents = new ArrayList<String>();
        if (refUs != null) {
            t = 0;
            while (t < refUs.length) {
                u = refUs[t];
                spath = u.getPath();
                if (spath.startsWith("/") && !Platform.getOS().equals("linux")) {
                    spath = spath.substring(1, spath.length());
                }
                if (spath.endsWith(".jar") || spath.endsWith(".zip")) {
                    this.copPaths.add(spath);
                } else if (spath.endsWith(".dll") || spath.endsWith(".so")) {
                    int index = spath.lastIndexOf("/");
                    spath = index == -1 ? "." : spath.substring(0, index + 1);
                    this.refPaths.add(spath);
                } else {
                    this.copPaths.add(spath);
                    spath = spath.substring(0, spath.lastIndexOf("/"));
                    if (!parents.contains(spath)) {
                        parents.add(spath);
                        this.copPaths.add(spath);
                    }
                }
                ++t;
            }
        }
        if (copUs != null) {
            t = 0;
            while (t < copUs.length) {
                u = copUs[t];
                spath = u.getPath();
                if (spath.startsWith("/") && !Platform.getOS().equals("linux")) {
                    spath = spath.substring(1, spath.length());
                }
                this.copPaths.add(spath);
                if (!(spath.endsWith(".jar") || spath.endsWith(".zip") || spath.endsWith(".dll") || spath.endsWith(".so") || parents.contains(spath = spath.substring(0, spath.lastIndexOf("/"))))) {
                    this.copPaths.add(spath);
                }
                ++t;
            }
        }
    }

    private boolean doesNameExists(String name) {
        boolean nameFound = false;
        try {
            IWebSphereJMXConnection con4 = WebSphereJMXUtil.getWebSphereJMXConnection((IServer)this.server);
            ConfigServiceProxy configService4 = con4.getConfigServiceProxy();
            Session session4 = new Session();
            ObjectName rra4 = ConfigServiceHelper.createObjectName(null, (String)"J2CResourceAdapter", null);
            ObjectName[] matches4 = configService4.queryConfigObjects(session4, null, rra4, null);
            int i = 0;
            String prName = name;
            if (prName.lastIndexOf("/") != 1) {
                prName = prName.substring(prName.lastIndexOf("/") + 1);
            }
            i = 0;
            while (i < matches4.length) {
                String atr = (String)configService4.getAttribute(session4, matches4[i], "name");
                if (atr.equals(name)) {
                    nameFound = true;
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return nameFound;
    }

    public void setSDisplayName(String sDisplayName) {
        this.sDisplayName = sDisplayName;
    }

    public String getSDisplayName() {
        return this.sDisplayName;
    }

    public void setASType(String asType) {
        this.asType = asType;
    }

    public String getListenerName() {
        return this.listenerName;
    }
}

