<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
    xmlns:xalan="http://xml.apache.org/xslt">

	<xsl:output version="1.0" encoding="UTF-8" indent="no" method="html"/>

	<!-- Define a variable to look for the images folder -->
	<xsl:variable name="j2c_img_folder"	select="/section/j2cImageFolder/@location"/>

	<xsl:attribute-set name="class">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/class.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="connection">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/connection.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="connection_factory">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/connection_factory.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="data_binding">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/data_binding.gif</xsl:attribute>
	</xsl:attribute-set>

    <xsl:attribute-set name="commandbean">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/cmndbean.gif</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="commandbeans">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/commands_obj.gif</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="error">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/error.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="generate_javabeans">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/generate_javabeans.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="input">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/input.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="interface">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/interface.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="jndiname">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/jndiname.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="operation">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/operation.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="output">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/output.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="service">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/service.gif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="warning">
	  <xsl:attribute name="src"><xsl:value-of select="$j2c_img_folder"/>/warning.gif</xsl:attribute>
	</xsl:attribute-set>



	<!-- Root document, output the header -->
	<xsl:template match="/">
		<h1>J2C Service Migration Summary (WSADIE to RAD)</h1>
		<xsl:apply-templates select="node()"/>
	</xsl:template>

	<!-- Match for each service migrated -->
	<xsl:template match="/section">
		<ol style="margin-bottom:0; margin-top:0; " start="1" type="1">
            <xsl:for-each select="section">
				<li>
					<xsl:element name="img" use-attribute-sets="service"/>
                    <xsl:value-of select="@name"/>
					<ul>
						<li><xsl:apply-templates select="node()[starts-with(@name, 'Connection')]"/></li>
						<li><xsl:apply-templates select="node()[starts-with(@name, 'Java resources')]"/></li>
						<li><xsl:apply-templates select="node()[starts-with(@name, 'AdditionalInfo')]"/></li>
					</ul>
                </li>
            </xsl:for-each>
        </ol>
	</xsl:template>
    
    <!-- Additional info display -->
	<xsl:template match="/section/section/section[starts-with(@name, 'AdditionalInfo')]">
    <xsl:element name="img" use-attribute-sets="warning"/> <xsl:value-of select="section/@name"/> 
		<table border="1">
			<tr><td><b>WSDL</b></td><td><b>Info</b></td></tr>
            <xsl:for-each select="item">
                <tr>
					<td>
						<xsl:value-of select="@key"/>
					</td>
					<td>
						<xsl:value-of select="@value"/>
					</td>
                </tr>
            </xsl:for-each>
		</table>
    </xsl:template>
	<!-- Connection info display -->
	<xsl:template match="/section/section/section[starts-with(@name, 'Connection')]">
		<xsl:element name="img" use-attribute-sets="connection"/> Connection<br/>
		<xsl:element name="img" use-attribute-sets="jndiname"/> JNDI: <xsl:value-of select="item/@value"/> <br/>
		<xsl:element name="img" use-attribute-sets="connection_factory"/> <xsl:value-of select="section/@name"/> 
		<table border="1">
			<tr><td><b>Name</b></td><td><b>Value</b></td></tr>
            <xsl:for-each select="section/item">
                <tr>
					<td>
						<xsl:value-of select="@key"/>
					</td>
					<td>
						<xsl:value-of select="@value"/>
					</td>
                </tr>
            </xsl:for-each>
		</table>
	</xsl:template>

	<!-- Java resourced generated display -->
	<xsl:template match="/section/section/section[starts-with(@name, 'Java resources')]">
		<xsl:element name="img" use-attribute-sets="generate_javabeans"/>  <xsl:value-of select="@name"/>
		<ul>
            <xsl:for-each select="section">
				<li>

				<xsl:choose>
					<xsl:when test="starts-with(@name, 'J2C bean')"> <!-- Output J2C bean info -->
						<xsl:element name="img" use-attribute-sets="generate_javabeans"/><xsl:value-of select="@name"/>
						<ul>
						<li> <xsl:element name="img" use-attribute-sets="interface"/> <xsl:value-of select="item/@value"/> </li>
						<li>
						<xsl:element name="img" use-attribute-sets="class"/> <xsl:value-of select="section/@name"/>
							<ul>
				            <xsl:for-each select="section">

								<xsl:apply-templates select="node()"/> <!-- Display method Information -->

							</xsl:for-each>
							</ul>
						</li>
						</ul>
					</xsl:when>
					<xsl:when test="starts-with(@name, 'Command beans')">
					 	<xsl:element name="img" use-attribute-sets="commandbeans"/><xsl:value-of select="@name"/>
						<ul>
			            <xsl:for-each select="item">
							<li><xsl:element name="img" use-attribute-sets="commandbean"/><xsl:value-of select="@value"/></li>
						</xsl:for-each>
						</ul>
					</xsl:when>
					<xsl:otherwise>	<!-- assume data binding.  Need to add a when clause for command bean gen -->
						<xsl:element name="img" use-attribute-sets="data_binding"/><xsl:value-of select="@name"/>
						<ul>
			            <xsl:for-each select="item">
							<li><xsl:element name="img" use-attribute-sets="class"/><xsl:value-of select="@value"/></li>
						</xsl:for-each>
						</ul>
					</xsl:otherwise>
				</xsl:choose>

				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>

	<!-- Method level display -->
	<xsl:template match="/section/section/section/section/section/section">
		<li>
		<xsl:element name="img" use-attribute-sets="operation"/> <xsl:value-of select="@name"/>
		<ul>
			<xsl:for-each select="section">
				<li>
				<xsl:choose>
					<xsl:when test="starts-with(@name, 'Input')"> <!-- For input display -->
						<xsl:element name="img" use-attribute-sets="input"/> <xsl:value-of select="@name"/>:
                                      <xsl:choose>
							<xsl:when test="count(section)>0">
								<xsl:value-of select="section/@name"/> <br/>
								<ul>
								<xsl:for-each select="section/item">
									<li>
									<xsl:value-of select="@value"/> <br/>
									</li>
								</xsl:for-each>
								</ul>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="item/@value"/> <br/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="starts-with(@name, 'Output')"> <!-- For output display -->
						<xsl:element name="img" use-attribute-sets="output"/> <xsl:value-of select="@name"/>: 
						<xsl:choose>
							<xsl:when test="count(section)>0">
								<xsl:value-of select="section/@name"/> <br/>
								<ul>
								<xsl:for-each select="section/item">
									<li>
									<xsl:value-of select="@value"/> <br/>
									</li>
								</xsl:for-each>
								</ul>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="item/@value"/> <br/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise> <!-- display interaction or connection specs -->
						<xsl:value-of select="@name"/><br/>
						<xsl:if test="count(item)>0">
							<table border="1">
								<tr><td><b>Name</b></td><td><b>Value</b></td></tr>
					            <xsl:for-each select="item">
					                <tr>
										<td>
											<xsl:value-of select="@key"/>
										</td>
										<td>
											<xsl:value-of select="@value"/>
										</td>
					                </tr>
					            </xsl:for-each>
							</table>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
				</li>
				<xsl:apply-templates select="node()"/>
			</xsl:for-each>
		</ul>
		</li>
	</xsl:template>

	<!-- Status messages display -->
	<xsl:template match="section[starts-with(@name, 'Status')]">
		<xsl:choose>
			<xsl:when test="contains(item/@key, 'warning')">
				<xsl:element name="img" use-attribute-sets="warning"/>
			</xsl:when>
			<xsl:when test="contains(item/@key, 'error')">
				<xsl:element name="img" use-attribute-sets="error"/>
			</xsl:when>
			<xsl:when test="contains(item/@key, 'information')">
				<xsl:element name="img" use-attribute-sets="warning"/>
			</xsl:when>
		</xsl:choose>
		<xsl:value-of select="item/@key"/>: <xsl:value-of select="item/@value"/><br/>
	</xsl:template>

</xsl:stylesheet>
