#!/bin/sh
# IBM Confidential OCO Source Material
# 5630-A36 (C) COPYRIGHT International Business Machines Corp. 2000, 2002
# The source code for this program is not published or otherwise divested
# of its trade secrets, irrespective of what has been deposited with the
# U.S. Copyright Office.

#####################################################
#                                                   #
# J2C migration tool.                               #
#                                                   #  
# Version 1.0                                       #
#                                                   #
#####################################################

if [ $# -gt 1 ]
then
	# Set the classpath for the tool.
	while [ $# -gt 1 ] && [ "$inputfile" = "" ]
		do 
			case "$1" in 
				-f )
					inputfile=$2 ;;
				-w ) 
					wsdlsource=$2 ;;
				-p ) 
					project=$2 ;;
				-d ) 
					WORKSPACE=$2 ;;
				-t ) 
					type=$2 ;;
				-s ) 
					summary=$2 ;;
				-c )
					cicsver=$2 ;;
	                        -i )
					imsver=$2 ;;
				-r )
					wasver=$2 ;;
				-cicsrar )
					cicsrar=$2 ;;
				-imsrar )
					imsrar=$2 ;;
				-suffix )
				    suffix=$2 ;;					
				-o )  
					option=$2 ;;
			esac
	
		shift 2
	done
	
	if [ "$ECLIPSE_ROOT" = "" ]
	then
		ECLIPSE_ROOT="/opt/IBM/RXD/SDP"
	fi

	if [ "$JDK_HOME" = "" ]
	then
		JDK_HOME="$ECLIPSE_ROOT/jdk/jre/bin"
	fi


	if [ "$WORKSPACE" = "" ]
	then
		WORKSPACE="$ECLIPSE_ROOT/workspace/Migration"
	fi
	
      if [ "$EQUINOXJAR" = "" ]
	then
		EQUINOXJAR="$ECLIPSE_ROOT/plugins/org.eclipse.equinox.launcher_1.0.101.R34x_v20081125.jar"
	fi

    

	
	if [ "$inputfile" = "" ]
	then
		echo ===============================================
		echo Displaying options entered from command line
		echo ===============================================
		echo option: $option
		echo 
		echo type: $type
		echo 
		echo project: $project
		echo 
		echo summary: $summary
		echo 
		echo wsdlsource: $wsdlsource 
		echo
		echo cicsver: $cicsver
		echo
		echo imsver: $imsver
		echo
		echo wasver: $wasver
		echo
		echo cicsrar: $cicsrar
		echo 
		echo imsrar: $imsrar
		echo
		echo suffix: $suffix
		echo
		echo ================================================
		echo
		echo eclipse_root: $ECLIPSE_ROOT
		echo JDK_HOME: $JDK_HOME
		echo workspace: $WORKSPACE		 
        echo EQUINOXJAR:$EQUINOXJAR
        echo 
		echo ================================================
		
		 
		
		if [ "$project" != "" ]
		then
			OUTPUT="-output=$project"
		fi

		if [ "$summary" != "" ]
		then
			REPORT="-report=$summary"
		fi

		if [ "$wsdlsource" != "" ]
		then
			WSDL="-wsdl=$wsdlsource" 
		fi		

		if [ "$type" != "" ]
		then
			TYPE="-$type"
		fi

		if [ "$cicsver" != "" ]
		then
			CICSVER="-cicsver=$cicsver"
		fi
		
		if [ "$imsver" != "" ]
		then
			IMSVER="-imsver=$imsver"
		fi	
		

		if [ "$wasver" != "" ]
		then
			WASVER="-runtime=$wasver"
		fi

		if [ "$cicrar" != "" ]
		then
			CICSRAR="-cicsrar=$cicsrar"
		fi

		if [ "$imsrar" != "" ]
		then
			IMSRAR="-imsrar=$imsrar"
		fi	
		
		if [ "$suffix" != "" ]
		then
		    SUFFIX="-suffix=$suffix"
		fi
		
		if [ "$suffix" == "" ]
		then
		    SUFFIX="-suffix=-Proxy"
		fi

		if [ "$option" != "" ]
		then
			OPTION="-$option"
		fi


		echo 
		echo Invoking the command line migration Tool...
		echo 
		
		"$JDK_HOME/java" -Xj9 -Xquickstart -Xms100M -Xmx1024M -cp "$EQUINOXJAR" org.eclipse.core.launcher.Main -os linux -ws gtk -data "$WORKSPACE" -application com.ibm.j2c.migration.wsadie.J2CMigration $WSDL $OUTPUT $TYPE $REPORT $OPTION $CICSVER $IMSVER $WASVER $CICSRAR $IMSRAR $SUFFIX
	
	else
		echo
		echo eclipse_root: $ECLIPSE_ROOT
		echo JDK_HOME:$JDK_HOME
		echo workspace: $WORKSPACE
		echo EQUINOXJAR: $EQUINOXJAR
		echo  
 	      echo was.runtime:$WASRUNTIME 
            echo rarsPathVar:$RARVARPATH
            echo 

		FILE="-file=$inputfile"
		
		echo
		echo inputfile: $inputfile
		echo $FILE
		echo
		
		# -clean option only for internal development to pickup fixes by migration.jar plugin.
		# -clean will take a long time , normally do not use -clean
		# ECHO. "$JDK_HOME/java" -Xj9   -cp "$EQUINOXJAR" org.eclipse.core.launcher.Main -data "$WORKSPACE" -application com.ibm.j2c.migration.wsadie.J2CMigration $FILE 
		#
		echo Invoking the command line migration Tool...
		echo

		"$JDK_HOME/java" -Xj9 -Xquickstart -Xms100M -Xmx1024M -cp "$EQUINOXJAR" org.eclipse.core.launcher.Main -os linux -ws gtk -data "$WORKSPACE" -application com.ibm.j2c.migration.wsadie.J2CMigration $FILE 
	fi

else
	echo You should provide at least one input. 

	echo ===========================================================================================
	echo You need to set the eclipse_root, JDK_HOME and EQUINOXJAR inside the J2CMigration.bat first
	echo 
      echo ECLIPSE_ROOT is the directory where eclipse.exe and eclipse.ini is located
      echo
      echo    The default path is "/opt/IBM/RAD"  for RAD
      echo    The default path is "/opt/IBM/RSA"  for RSA
      echo  
      echo 
      echo JDK_HOME  is where your java.exe is located
      echo 
      echo     The default path should be $ECLIPSE_ROOT/jre/bin 
      echo
      echo EQUINOXJAR is where the org.eclipse.equinox.launcher_*.jar is located
      echo     It is for the invoking the org.eclipse.core.launcher.Main
      echo     The default path is $ECLIPSE_ROOT/plugins/org.eclipse.equinox.launcher_*.jar 
      echo 
      echo RARVARPATH is the directory where the resource adapters are located and is defined in config.ini
      echo    
      echo     The default value is $ECLIPSE_ROOT/ResourceAdapters and there is a
      echo     variable rarsPathVar defined in $ECLIPSE_ROOT/eclipse.ini
      echo
      echo
      echo WASRUNTIME is the directory of where the WAS runtime stub is located
      echo
      echo     The default value is $ECLIPSE_ROOT/runtimes
      echo     There is a variable was.runtime defined in $ECLIPSE_ROOT/configuration/config.ini
      echo 
      echo
	echo You can locate the default values of rarsPathVar and was.runtime in  $ECLIPSE_ROOT/configuration/config.ini
	echo
	echo If they are not correct, go to the J2CMigraion.sh file to change it
	echo
	echo
	echo
	echo ================================================echo
	echo
	echo Usage:      J2CMigration.sh 
	echo             -w wsdlsource -d workspace [-p project] [-t type] [-o option] [-s summary] 
	echo
	echo
	echo workspace:  The workspace of where output is generated 
     	echo             The default value is set to $ECLIPSE_ROOT/workspace/Migration
	echo 
	echo cicsrarURI: The fullpath of CICS Resource Adapter e.g /opt/IBM/RXD/SDP/ResourceAdapter/CICS/ciceci6022.rar
	echo 		 This is optional, you can just specify the cics version.
	echo
	echo imsrarURI: This full path of IMS Resource Adapter e.g /opt/IBM/RXD/SDP/ResourceAdapter/IMS/ims91025a.rar
	echo 		This is optional, you can just specify the cics version.
	echo
	echo cicsver:   The version of CICS Resource Adapter e.g 6.1.0.2
	echo 		If the version is specified, do not need to specify cicsrar
	echo		We will locate the adapter from the registry
	echo		If no such version is found, we will use the cicsrar.
	echo		If no cicsrar specified we will locate one with jca 1.5 from registry.
	echo
	echo imsver:	The version of IMS Resource Adapter e.g 9.1.0.2.5a
	echo		If the version is specified, do not need to specify imsrar
	echo		We will locate the adapter from the registry
	echo		If no such version is found, we will use the imsrar.
	echo		If no imsrar specified we will locate one with jca 1.5 from registry
	echo
	echo wasversion: The webSphere applicatoin server version
	echo		 If none specified, the default is 6.1
	echo		 If no WAS server is installed, the WAS stub will be used instead
	echo		 For 6.0 use was.base.v6
	echo		 For 6.1 use was.base.v61
	echo		 For 7.0 use was.base.v7						
	echo
	echo wsdlsource: The full path of the service WSDL file
	echo             or the full path of the folder that contains one or more
	echo             services WSDL files.
	echo
	echo project:    The name of the project where the migrated artifacts will be generated.
	echo             Do not include a path, just a Name for the project.  
	echo             You can specify web, Java, or EJB project to be created.
	echo             If no project is specified, a default Java project will be created.
	echo             If you do not specify the -p option, then the migrated artifacts
	echo             will be generated to the project specified in the service WSDL file.
	echo
	echo type:       WEB or EJB or JAVA
	echo             Project type of the output project
	echo
	echo option:     databindingonly or commandbean
	echo             databindingonly: Specify this option if you want only data binding 
	echo                              beans to be generated during migration.    
	echo             commandbean:     Specify this option if you want 
	echo                              a command bean to be generated. 
	echo             If you specify databindingonly, 
	echo             the commandbean option will be ignored.
	echo
	echo suffix      impl, proxy or any suffix you want
	echo             impl the J2C bean implementation name will be ending with Impl
	echo 			 Proxy the J2C bean implementation name will be ending with Proxy	
	echo             If this option is not specfified:   the implementation name will be ending with Proxy 
	echo
	echo summary:    The name of migration summary "("without .xml")".
	echo             If none is specified, the default summary file will be 
	echo             j2cmigration_timestamp.xml 
	echo             If the summary file say summary.xml already exists,
	echo             we will write the summary to the summary_timestamp.xml.
	echo
	echo migrationinputfile: The migration file which contains the above options to be
	echo                     passed into the command line migration tool
	echo                     This method is useful when you command line options are too 
	echo                     long. 
	echo 
	echo 
	echo 
	echo =================================================================================
	echo 
	echo Example: 
	echo 
	echo  
	echo J2CMigration.bat -d "/root/myworkspace" -w "/root/mywsdl.wsdl" -c "6.0.2.2" -p "OutputProject"
	echo J2CMigration.bat  -w "/root/mywsdl.wsdl" -i "9.1.0.2.5a" -p "OutputProject" -s "MigrationReport"
	echo J2CMigration.bat  -w "/root/mywsdlFolder" -r "was.base.v7" -p "OutputProject" -s "MigrationReport"
	echo J2CMigration.bat -w "/root/myfolder" -o databindingonly  
	echo J2CMigration.bat -w "/root/myfolder" -o commandbean -t EJB  -suffix impl
	echo J2CMigration.bat -f "/root/mymigrationinputs"
	echo 
fi
