/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.lang.ui.wizards;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.registry.IConfiguration;
import com.ibm.ccl.discpub.ui.core.internal.data.ResourceWriterInfo;
import com.ibm.ccl.discpub.ui.core.internal.environment.UICoreImportEnvironment;
import com.ibm.j2c.lang.ui.internal.data.J2CLanguageImportUIController;
import com.ibm.j2c.lang.ui.internal.datastore.AntFile;
import com.ibm.j2c.lang.ui.internal.datastore.GenerateDataBindingTypeScript;
import com.ibm.j2c.lang.ui.internal.messages.LangUIMessageBundle;
import com.ibm.j2c.lang.ui.internal.model.IOMessageSubInfo;
import com.ibm.j2c.lang.ui.internal.model.SubMPOInfo;
import com.ibm.j2c.lang.ui.internal.properties.SessionAntPropertyGroup;
import com.ibm.j2c.lang.ui.internal.utilities.LangUIHelper;
import com.ibm.j2c.lang.ui.internal.wizards.J2CLanguageImportWizard_ImportPropertiesPage;
import com.ibm.j2c.lang.ui.internal.wizards.J2CLanguageImportWizard_ImporterPage;
import com.ibm.j2c.lang.ui.internal.wizards.J2CLanguageImportWizard_InitPage;
import com.ibm.j2c.lang.ui.internal.wizards.J2CLanguageImportWizard_SavingPage;
import com.ibm.j2c.lang.ui.plugin.LangUIPlugin;
import com.ibm.j2c.ui.core.CoreConstants;
import com.ibm.j2c.ui.core.internal.datastore.GenerateDynamicProp;
import com.ibm.j2c.ui.core.internal.datastore.GenerateProjectName;
import com.ibm.j2c.ui.core.internal.utilities.J2CUICoreHelper;
import com.ibm.j2c.ui.core.internal.utilities.J2CUIPropertyUtil;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.common.FileProperty;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import com.ibm.propertygroup.ui.utilities.PropertyGroupUIHelper;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage_PropertyGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class J2CLanguageImportWizard
extends Wizard
implements INewWizard {
    protected LangUIMessageBundle messageBundle_;
    protected J2CLanguageImportWizard_InitPage initPage_;
    protected J2CLanguageImportWizard_ImporterPage importerPage_;
    protected J2CLanguageImportWizard_ImportPropertiesPage importPropertiesPage_;
    protected J2CLanguageImportWizard_SavingPage savingPage_;
    protected IEnvironment environment_;
    public String projectName_;
    protected IResource importFile_;
    protected IConfiguration selectedImportConfiguration_;
    protected ResourceWriterInfo writerInfo_;
    protected IImportResult importResult_;
    protected boolean isForMPOData_ = false;
    protected ArrayList dataTypes_;
    protected ArrayList mpoImportedData_;
    protected ArrayList originalImportedData_;
    protected boolean recordSession_ = true;
    private IConfiguration[] importConfigurations_;
    private J2CLanguageImportUIController uiController_;
    protected Hashtable MPOHash = null;
    protected Hashtable MPOqueryHash = null;
    protected ArrayList MPOHashList = null;
    protected ArrayList MPOHashList1 = null;
    protected Object[] context_ = null;
    private boolean status_;

    public J2CLanguageImportWizard(LangUIMessageBundle newBundle) {
        this(newBundle, null);
    }

    public J2CLanguageImportWizard(LangUIMessageBundle newBundle, IEnvironment env) {
        this.environment_ = env;
        if (this.environment_ == null) {
            this.environment_ = new UICoreImportEnvironment("com.ibm.j2c.lang.ui");
        }
        this.messageBundle_ = newBundle;
        if (this.messageBundle_ == null) {
            this.messageBundle_ = new LangUIMessageBundle(null);
        }
        this.dataTypes_ = new ArrayList(4);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_WIN_TITLE_CIMPORT"));
    }

    public void init(IWorkbench desktop, IStructuredSelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.context_ = selection.toArray();
            Iterator iterator = selection.iterator();
            if (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!iterator.hasNext()) {
                    if (obj instanceof IResource) {
                        IResource r = (IResource)obj;
                        if (this.projectName_ == null || this.projectName_.length() < 1) {
                            this.projectName_ = r.getProject().getName();
                        }
                        if (r.getType() == 1) {
                            this.importFile_ = r;
                        }
                    } else if (obj instanceof IJavaElement && (this.projectName_ == null || this.projectName_.length() < 1)) {
                        this.projectName_ = ((IJavaElement)obj).getJavaProject().getElementName();
                    }
                }
            }
        }
    }

    public void addPages() {
        ArrayList pages = this.createWizardPages();
        int i = 0;
        while (i < pages.size()) {
            this.addPage((IWizardPage)pages.get(i));
            ++i;
        }
    }

    protected ArrayList createWizardPages() {
        ArrayList<MessageBundleWizardDynamicPage_PropertyGroup> pages = new ArrayList<MessageBundleWizardDynamicPage_PropertyGroup>();
        pages.add(this.getInitPage());
        pages.add(this.getImporterPage());
        pages.add(this.getImportPropertiesPage());
        pages.add(this.getSavingPage());
        return pages;
    }

    public J2CLanguageImportWizard_InitPage getInitPage() {
        if (this.initPage_ == null) {
            this.initPage_ = new J2CLanguageImportWizard_InitPage("com.ibm.j2c.languageimport.ui.wizards.J2CLanguageImportWizard_InitPage", this.messageBundle_);
        }
        return this.initPage_;
    }

    public J2CLanguageImportWizard_ImporterPage getImporterPage() {
        if (this.importerPage_ == null) {
            this.importerPage_ = new J2CLanguageImportWizard_ImporterPage("com.ibm.j2c.languageimport.ui.wizards.J2CLanguageImportWizard_ImporterPage", this.messageBundle_);
        }
        return this.importerPage_;
    }

    public J2CLanguageImportWizard_ImportPropertiesPage getImportPropertiesPage() {
        if (this.importPropertiesPage_ == null) {
            this.importPropertiesPage_ = new J2CLanguageImportWizard_ImportPropertiesPage("com.ibm.j2c.languageimport.ui.wizards.J2CLanguageImportWizard_ImportPropertiesPage", this.messageBundle_);
        }
        return this.importPropertiesPage_;
    }

    public J2CLanguageImportWizard_SavingPage getSavingPage() {
        if (this.savingPage_ == null) {
            this.savingPage_ = new J2CLanguageImportWizard_SavingPage("com.ibm.j2c.languageimport.ui.wizards.J2CLanguageImportWizard_SavingPage", this.messageBundle_);
        }
        return this.savingPage_;
    }

    public boolean performFinish() {
        if (!this.beforePerformFinish()) {
            return false;
        }
        this.status_ = true;
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        J2CLanguageImportWizard.this.status_ = J2CLanguageImportWizard.this.doPerformFinish(monitor);
                    }
                    catch (BaseException ie) {
                        PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)LangUIPlugin.getInstance(), (Throwable)ie, J2CLanguageImportWizard.this.getShell(), J2CLanguageImportWizard.this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), PropertyGroupUIHelper.getDefault().getMessageFromCoreException((CoreException)((Object)ie)));
                        J2CLanguageImportWizard.this.status_ = false;
                    }
                    catch (Exception e) {
                        PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)LangUIPlugin.getInstance(), (Throwable)e, J2CLanguageImportWizard.this.getShell(), J2CLanguageImportWizard.this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), e.getMessage());
                        e.printStackTrace();
                        J2CLanguageImportWizard.this.status_ = false;
                    }
                }
            });
        }
        catch (Exception e) {
            PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)LangUIPlugin.getInstance(), (Throwable)e, this.getShell(), this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), e.getMessage());
            this.status_ = false;
        }
        if (this.status_ && !this.afterPerformFinish()) {
            return false;
        }
        return this.status_;
    }

    protected boolean beforePerformFinish() {
        File file;
        J2CLanguageImportWizard_SavingPage page = this.getSavingPage();
        SessionAntPropertyGroup sapg = LangUIHelper.instance().getSessionAntPropertyGroup(page.getSessionOutputProperties());
        if (sapg != null && sapg.isSelected() && sapg.getOutputStyle() == 0 && !this.validateSessionOutput(sapg)) {
            return false;
        }
        if (sapg != null && sapg.getOutputStyle() == 1 && (file = new File(sapg.getAntIFile().getLocation().toString())) != null && file.exists()) {
            file.delete();
        }
        return true;
    }

    protected boolean afterPerformFinish() {
        return true;
    }

    protected boolean doPerformFinish(IProgressMonitor monitor) throws Exception {
        boolean status = true;
        if (this.isForMPOData_) {
            ArrayList importedData = this.originalImportedData_ != null ? (ArrayList)this.originalImportedData_.clone() : new ArrayList(6);
            try {
                IResultNodeSelection resultNodeSelection = this.initPage_.getSearchTree().createResultNodeSelection();
                IResultNode node = null;
                ArrayList<IResultNode> selectedResultNodes = this.importerPage_.getSelectedResultNodes();
                int i = 0;
                while (i < selectedResultNodes.size()) {
                    if (node != null) {
                        resultNodeSelection.remove(node);
                    }
                    node = selectedResultNodes.get(i);
                    resultNodeSelection.add(node);
                    this.importResult_ = this.initPage_.getDiscoveryAgent().performImport(this.environment_, resultNodeSelection);
                    Object data = this.getImportedData(importedData);
                    if (data != null) {
                        IOMessageSubInfo ioSubInfo = new IOMessageSubInfo(node.getName(), node);
                        ioSubInfo.setSource(this.initPage_.getPropertyGroup());
                        ioSubInfo.setQueryProperties(this.importerPage_.getPropertyGroup());
                        this.dataTypes_.add(ioSubInfo);
                        if (this.mpoImportedData_ == null) {
                            this.mpoImportedData_ = new ArrayList(6);
                        }
                        this.mpoImportedData_.add(data);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.rollBackImportResult();
                throw e;
            }
        } else {
            status = this.performOutput(monitor);
        }
        if (status) {
            this.saveToStore();
        }
        return status;
    }

    protected boolean performOutput(IProgressMonitor monitor) throws Exception {
        return true;
    }

    protected void saveToStore() {
        this.initPage_.saveToStore();
        this.importerPage_.saveToStore();
        this.savingPage_.saveToStore();
        IPropertyGroup sessiongp = this.savingPage_.getSessionOutputProperties();
        if (sessiongp != null) {
            String antFile = AntFile.getAntFile(sessiongp);
            if (AntFile.recordSession()) {
                this.saveToAnt(antFile, AntFile.antProjectName);
            }
        }
    }

    public void setImportConfigurations(IConfiguration[] newIICs) {
        this.importConfigurations_ = newIICs;
    }

    public IConfiguration[] getImportConfigurations() {
        return this.importConfigurations_;
    }

    public void setUIController(J2CLanguageImportUIController newHelper) {
        this.uiController_ = newHelper;
    }

    public J2CLanguageImportUIController getUIController() {
        return this.uiController_;
    }

    public void setImportResult(IImportResult newValue) {
        this.importResult_ = newValue;
        if (this.importResult_ != null) {
            Object data = this.importResult_.getImportData();
            if (data instanceof Collection) {
                this.originalImportedData_ = new ArrayList(((Collection)data).size());
                this.originalImportedData_.addAll((Collection)data);
            } else {
                this.originalImportedData_ = new ArrayList(1);
                this.originalImportedData_.add(data);
            }
        }
    }

    public IImportResult getImportResult() {
        return this.importResult_;
    }

    public IResource getImportFile() {
        return this.importFile_;
    }

    public void setImportFile(IResource file) {
        this.importFile_ = file;
    }

    public void setForMPOData(boolean forMPOData) {
        this.isForMPOData_ = forMPOData;
    }

    public boolean isForMPOData() {
        return this.isForMPOData_;
    }

    public ArrayList getMPOImportedData() {
        return this.mpoImportedData_;
    }

    public void setRecordSession(boolean record) {
        this.recordSession_ = record;
    }

    public boolean getRecordSession() {
        return this.recordSession_;
    }

    public String getSelectedNodeName() {
        IResultNode[] nodes;
        if (this.importerPage_.getResultNodeSelection() != null && (nodes = this.importerPage_.getResultNodeSelection().getSelection()).length > 0 && nodes[0].getName() != null) {
            return nodes[0].getName();
        }
        return "";
    }

    public boolean isMPODiscoveryAgent() {
        return this.initPage_.getPropertyGroup() == null;
    }

    public String getProjectName() {
        return this.projectName_;
    }

    public IEnvironment getImportEnvironment() {
        return this.environment_;
    }

    public ArrayList getDataTypes() {
        return this.dataTypes_;
    }

    public ResourceWriterInfo getResourceWriterInfo() {
        return this.writerInfo_;
    }

    public void setResourceWriterInfo(ResourceWriterInfo info) {
        this.writerInfo_ = info;
    }

    public void setSelectedImportConfiguration(IConfiguration newValue) {
        this.selectedImportConfiguration_ = newValue;
    }

    public IConfiguration getSelectedImportConfiguration() {
        return this.selectedImportConfiguration_;
    }

    private void rollBackImportResult() {
        Object data;
        if (this.dataTypes_ != null) {
            this.dataTypes_.clear();
        }
        if (this.mpoImportedData_ != null) {
            this.mpoImportedData_.clear();
        }
        if (this.importResult_ != null && (data = this.importResult_.getImportData()) instanceof Collection) {
            if (this.originalImportedData_ != null) {
                Iterator iterator = ((Collection)data).iterator();
                while (iterator.hasNext()) {
                    Object tmp = iterator.next();
                    if (this.originalImportedData_.contains(tmp)) continue;
                    iterator.remove();
                }
            } else {
                ((Collection)data).clear();
            }
        }
    }

    private Object getImportedData(ArrayList importedData) {
        Object data;
        if (this.importResult_ != null && (data = this.importResult_.getImportData()) instanceof Collection) {
            for (Object tmp : (Collection)data) {
                if (importedData.contains(tmp)) continue;
                importedData.add(tmp);
                return tmp;
            }
        }
        return null;
    }

    public IDiscoveryAgent getDiscoveryAgent() {
        return this.initPage_.getDiscoveryAgent();
    }

    public boolean buildMPO() {
        boolean mpocase = false;
        if (this.initPage_.getMPOData() != null && this.initPage_.getMPOData().size() > 0) {
            mpocase = true;
            Hashtable<String, ArrayList<String>> mpoHash = new Hashtable<String, ArrayList<String>>();
            ArrayList<Hashtable> mpoHashList = new ArrayList<Hashtable>(this.initPage_.getMPOData().size());
            ArrayList<Object> mpoHashList1 = new ArrayList<Object>(this.initPage_.getMPOData().size());
            Hashtable<String, IPropertyGroup> mpoqueryHash = new Hashtable<String, IPropertyGroup>();
            FileProperty fileProp = null;
            IPropertyGroup fproperties = null;
            int i = 0;
            while (i < this.initPage_.getMPOData().size()) {
                SubMPOInfo mpoinfo = this.initPage_.getMPOData().get(i);
                IOMessageSubInfo subInfo = mpoinfo.getIOMessageSubInfo();
                Object source = subInfo.getSource();
                if (source != null) {
                    Enumeration mposource;
                    IPropertyGroup mposrc;
                    Hashtable mymy;
                    if (source instanceof URI) {
                        CoreConstants.dump((String)source.toString());
                        try {
                            ArrayList files;
                            if (fproperties == null) {
                                fproperties = this.initPage_.getDiscoveryAgent().getInitializeProperties();
                            }
                            if (fileProp == null && (files = J2CUIPropertyUtil.getProperties((IPropertyGroup)fproperties, (int)4)) != null && !files.isEmpty()) {
                                fileProp = (FileProperty)files.get(0);
                                CoreConstants.dump((String)("fileprop=" + fileProp.getName()));
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        URI fileuri = (URI)source;
                        Hashtable<String, String> myfilevar = new Hashtable<String, String>();
                        CoreConstants.dump((String)(String.valueOf(fileProp.getName()) + " " + fileuri.toFileString()));
                        myfilevar.put(fileProp.getName(), fileuri.toFileString());
                        mpoHashList.add(myfilevar);
                        mpoHashList1.add(source);
                    } else if (source instanceof IPropertyGroup && (mymy = GenerateDynamicProp.generatePropertyGroups((IPropertyGroup)(mposrc = (IPropertyGroup)source))) != null && (mposource = mymy.keys()) != null) {
                        while (mposource.hasMoreElements()) {
                            ArrayList<String> datasources;
                            String resultnodeName = subInfo.getName();
                            if (subInfo.getData() instanceof IResultNode) {
                                IResultNode resnode = (IResultNode)subInfo.getData();
                                resultnodeName = resnode.getLocation();
                            }
                            String mpoKey = mposource.nextElement().toString();
                            String mpoValue = mymy.get(mpoKey).toString();
                            if (subInfo.getQueryProperties() != null) {
                                mpoqueryHash.put(mpoValue, subInfo.getQueryProperties());
                            }
                            if (mpoHash.containsKey(mpoValue)) {
                                datasources = (ArrayList<String>)mpoHash.get(mpoValue);
                                datasources.add(resultnodeName);
                                mpoHash.put(mpoValue, datasources);
                                continue;
                            }
                            mpoHashList.add(mymy);
                            mpoHashList1.add(mposrc);
                            datasources = new ArrayList<String>(1);
                            datasources.add(resultnodeName);
                            mpoHash.put(mpoValue, datasources);
                        }
                    }
                }
                ++i;
            }
            if (CoreConstants.isDebug_) {
                System.out.println(">>>>buildMPO  result>>>" + mpoHash.size());
                Enumeration mpodata = mpoHash.keys();
                if (mpodata != null) {
                    while (mpodata.hasMoreElements()) {
                        String mpodatakey = (String)mpodata.nextElement();
                        ArrayList mpoDS = (ArrayList)mpoHash.get(mpodatakey);
                        CoreConstants.dump((String)("mpoDS=" + mpoDS.size()));
                        int i2 = 0;
                        while (i2 < mpoDS.size()) {
                            System.out.println(String.valueOf(i2) + ":key=" + mpodatakey + " value=" + mpoDS.get(i2));
                            ++i2;
                        }
                    }
                }
                int j = 0;
                while (j < mpoHashList.size()) {
                    Hashtable mympoHash;
                    Enumeration mposrc;
                    if (mpoHashList.get(j) != null && (mposrc = (mympoHash = (Hashtable)mpoHashList.get(j)).keys()) != null) {
                        while (mposrc.hasMoreElements()) {
                            String mposrckey = (String)mposrc.nextElement();
                            String mposrcfile = (String)mympoHash.get(mposrckey);
                            System.out.println("name=" + mposrckey + " value=" + mposrcfile);
                            ArrayList mpoDS = (ArrayList)mpoHash.get(mposrcfile);
                            int i3 = 0;
                            while (i3 < mpoDS.size()) {
                                System.out.println(String.valueOf(i3) + ":key=" + mposrcfile + " value=" + mpoDS.get(i3));
                                ++i3;
                            }
                        }
                    }
                    ++j;
                }
                System.out.println(">>>>buildMPO result>>>>");
            }
            this.MPOHashList = mpoHashList;
            this.MPOHash = mpoHash;
            this.MPOqueryHash = mpoqueryHash;
            this.MPOHashList1 = mpoHashList1;
        }
        return mpocase;
    }

    public String getCurrentProjectType() {
        return J2CUICoreHelper.getDefault().getCurrentProjectType(this.getCurrentProjectName());
    }

    public String getCurrentProjectName() {
        ArrayList myarray = J2CUIPropertyUtil.getProperties((IPropertyGroup)this.savingPage_.getPropertyGroup(), (int)1);
        String projectName = null;
        CoreConstants.dump((String)("array=" + myarray.size()));
        int i = 0;
        while (i < myarray.size()) {
            JavaProjectProperty pf = (JavaProjectProperty)myarray.get(i);
            CoreConstants.dump((String)(String.valueOf(pf.getName()) + ": " + pf.getValueAsString()));
            projectName = pf.getValueAsString();
            CoreConstants.dump((String)("mpo project= " + projectName));
            CoreConstants.dump((String)("length=" + pf.getValidValuesAsStrings().length));
            ++i;
        }
        return projectName;
    }

    public void saveToAnt(String antFile, String antProjectName) {
        ArrayList queryResult = null;
        if (this.importerPage_.getSelectedResultNodes() != null && this.importerPage_.getSelectedResultNodes().size() > 0) {
            CoreConstants.dump((String)"importPage..selectedResultNodes");
            queryResult = GenerateDataBindingTypeScript.buildQueryResult(this.importerPage_.getSelectedResultNodes());
        }
        boolean mpocase = this.buildMPO();
        ArrayList importProperties = null;
        ArrayList importProperties1 = null;
        if (this.MPOHashList1 != null && this.MPOHashList1.size() > 0) {
            importProperties1 = GenerateDataBindingTypeScript.buildImportResourceMPO1(this.MPOHashList1);
        }
        if (this.MPOHashList != null && this.MPOHashList.size() > 0) {
            importProperties = GenerateDataBindingTypeScript.buildImportResourceMPO(this.MPOHashList);
        }
        Hashtable queryResultMPO = null;
        if (this.MPOHash != null && this.MPOHash.size() > 0) {
            queryResultMPO = GenerateDataBindingTypeScript.buildQueryResultMPO(this.MPOHash);
        }
        Hashtable queryPropertiesMPO = null;
        if (this.MPOqueryHash != null && this.MPOqueryHash.size() > 0) {
            queryPropertiesMPO = GenerateDataBindingTypeScript.buildQueryPropertiesMPO(this.MPOqueryHash);
        }
        GenerateDataBindingTypeScript.buildDiscoveryAgent(this.initPage_.getDiscoveryAgent().getMetaData().getAgentName().toString());
        GenerateDataBindingTypeScript.buildImportResource(this.initPage_.getPropertyGroup());
        if (mpocase) {
            String mpoProjectName = this.getCurrentProjectName();
            GenerateDataBindingTypeScript.buildCreateProject(mpoProjectName, J2CUICoreHelper.getDefault().getCurrentProjectType(mpoProjectName), J2CUICoreHelper.getDefault().getCurrentProjectRuntime(mpoProjectName));
        } else {
            String tmp = GenerateProjectName.generatePropertyGroups((IPropertyGroup)this.savingPage_.getPropertyGroup());
            if (tmp != null) {
                GenerateDataBindingTypeScript.buildCreateProject(tmp, J2CUICoreHelper.getDefault().getCurrentProjectType(tmp), J2CUICoreHelper.getDefault().getCurrentProjectRuntime(tmp));
            }
        }
        ArrayList queryProperties = new ArrayList();
        queryProperties = GenerateDataBindingTypeScript.buildQueryProperties(this.importPropertiesPage_.getPropertyGroup(), queryProperties);
        queryProperties = GenerateDataBindingTypeScript.buildQueryProperties(this.importerPage_.getPropertyGroup(), queryProperties);
        GenerateDataBindingTypeScript.buildWriteProperty(this.savingPage_.getPropertyGroup());
        GenerateDataBindingTypeScript.buildWriter(this.writerInfo_.getResourceWriter().getName().toString());
        CoreConstants.dump((String)antFile);
        if (mpocase) {
            GenerateDataBindingTypeScript.saveToAntMPO(antFile, antProjectName, queryPropertiesMPO, queryResultMPO, importProperties, importProperties1);
        } else {
            GenerateDataBindingTypeScript.saveToAnt(antFile, antProjectName, queryProperties, queryResult);
        }
    }

    public boolean checkSessionOutput(SessionAntPropertyGroup sapg) {
        File ioFile = sapg.getAntIFile().getLocation().toFile();
        if (!ioFile.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), (String)this.messageBundle_.getMessage("ERROR_WIZARDS_CANNOT_GENERATE_FILE", J2CUICoreHelper.getDefault().getDisplayString(sapg.getAntFileAsString())));
            return false;
        }
        return true;
    }

    public boolean validateSessionOutput(SessionAntPropertyGroup sapg) {
        if (sapg != null) {
            return LangUIHelper.instance().validateSessionOutput(this.getShell(), this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_DIALOG_TITLE_CONFIRM_OVERWRITE"), this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_DIALOG_MSG_OVERWRITE", J2CUICoreHelper.getDefault().getDisplayString(sapg.getAntFileAsString())), new String[]{this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_DIALOG_MSG_SELECTION_OVERWRITE"), this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_DIALOG_MSG_SELECTION_APPEND")}, sapg);
        }
        return true;
    }

    public LangUIMessageBundle getUIMessageBundle() {
        return this.messageBundle_;
    }

    public Object[] getContext() {
        return this.context_;
    }
}

