/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.lang.ui.internal.wizards;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.registry.IConfiguration;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.ccl.discpub.ui.core.internal.data.ResourceWriterInfo;
import com.ibm.j2c.lang.ui.internal.data.J2CLanguageImportUIController;
import com.ibm.j2c.lang.ui.internal.datastore.ImportStore;
import com.ibm.j2c.lang.ui.internal.messages.LangUIMessageBundle;
import com.ibm.j2c.lang.ui.internal.model.SubMPOInfo;
import com.ibm.j2c.lang.ui.internal.utilities.J2CLangUIInfoPopHelper;
import com.ibm.j2c.lang.ui.internal.wizards.J2CLanguageImportWizard_ImporterPage;
import com.ibm.j2c.lang.ui.internal.wizards.J2CLanguageImportWizard_SavingPage;
import com.ibm.j2c.lang.ui.plugin.LangUIPlugin;
import com.ibm.j2c.lang.ui.wizards.J2CLanguageImportWizard;
import com.ibm.j2c.ui.core.internal.utilities.J2CLogUtil;
import com.ibm.j2c.ui.core.internal.utilities.J2CUICoreHelper;
import com.ibm.j2c.ui.core.internal.utilities.J2CUIPropertyUtil;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.common.FileProperty;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.utilities.PropertyGroupUIHelper;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage_PropertyGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class J2CLanguageImportWizard_InitPage
extends MessageBundleWizardDynamicPage_PropertyGroup
implements ISelectionChangedListener,
IStructuredContentProvider {
    protected Combo mapping_;
    protected PropertyUIScrollableComposite scroller_;
    protected Button mpoBrowseButton_;
    protected Button mpoImportButton_;
    protected Button mpoRemoveButton_;
    protected TableViewer mpoTableViewer_;
    protected Label mpoTableLabel_;
    protected J2CLanguageImportWizard wizard_;
    protected IPropertyUIWidgetFactory factory_;
    protected Hashtable<String, LayoutInfo> layouts_;
    protected ImportStore istore = null;
    public String currentMapping_ = null;
    protected IPropertyGroup properties_;
    protected IDiscoveryAgent agent_;
    protected ISearchTree searchTree_;
    protected ArrayList<SubMPOInfo> mpoData_;
    protected final String mpoLayoutKey_ = "MPO_DISCOVERY_AGENT";
    protected final String COBOL_TO_JAVA = "COBOL_TO_JAVA";
    protected final String COBOL_MPO_TO_JAVA = "COBOL_MPO_TO_JAVA";
    protected final String COBOL_CICS_CHANNEL_TO_JAVA = "COBOL_CICS_CHANNEL_TO_JAVA";

    public J2CLanguageImportWizard_InitPage(String name, LangUIMessageBundle newBundle) {
        super(name, (PropertyUIMessageBundle)newBundle);
        this.setTitle(this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_DATAIMPORTCONFIG"));
        this.setDescription(this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_DATAIMPORTCONFIG_DESC"));
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_J2CLANGIMPORT_WIZARD_INIT_PAGE")));
        this.layouts_ = new Hashtable();
        this.istore = new ImportStore(LangUIPlugin.getInstance());
        this.mpoData_ = new ArrayList();
        this.setHelpContextIdPrefix(J2CLangUIInfoPopHelper.instance().getHelpPrefix(this.getName(), J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE));
    }

    public Composite createContents(IPropertyUIWidgetFactory factory, Composite parent) {
        this.factory_ = factory;
        this.wizard_ = (J2CLanguageImportWizard)this.getWizard();
        Composite main = factory.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 12;
        layout.numColumns = 2;
        main.setLayout((Layout)layout);
        this.createMappingArea(factory, main);
        Label sep = factory.createSeparator(main, 256);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        sep.setLayoutData((Object)gd);
        this.createPropertiesArea(factory, main);
        this.populateImportConfigurationList();
        this.setInfoHelp(main);
        return main;
    }

    protected void createMappingArea(IPropertyUIWidgetFactory factory, Composite main) {
        factory.createLabel(main, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_LABEL_CHOOSE_MAPING"), 64);
        this.mapping_ = factory.createNormalCombo(main, factory.getBorderStyle() | 8);
        this.mapping_.setToolTipText(this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_LABEL_CHOOSE_MAPING_DESC"));
        GridData gd = new GridData(768);
        this.mapping_.setLayoutData((Object)gd);
        this.mapping_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                J2CLanguageImportWizard_InitPage.this.handleMappingChanged();
            }
        });
    }

    protected void createPropertiesArea(IPropertyUIWidgetFactory factory, Composite main) {
        this.scroller_ = factory.createPropertyUIScrollableComposite(main, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.scroller_.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.scroller_.setLayoutData((Object)gd);
    }

    protected void handleMappingChanged() {
        if (this.mapping_.isEnabled()) {
            this.firstOpens(false);
            String key = this.mapping_.getText();
            IConfiguration ic = (IConfiguration)this.mapping_.getData(key);
            IConfiguration configuration = this.wizard_.getSelectedImportConfiguration();
            if (ic != null && configuration != ic) {
                this.wizard_.setSelectedImportConfiguration(ic);
                this.wizard_.setResourceWriterInfo(null);
                this.wizard_.setImportResult(null);
                this.mpoData_.clear();
                if (this.mpoTableViewer_ != null) {
                    this.mpoTableViewer_.refresh();
                }
                this.isModified(true);
                this.displayDetails();
            }
        } else {
            this.firstOpens(false);
            this.displayDetails();
        }
    }

    protected void populateImportConfigurationList() {
        String selectedConfiguration = null;
        if (this.wizard_.getSelectedImportConfiguration() == null) {
            IConfiguration[] dataImportConfigurations = this.wizard_.getImportConfigurations();
            if (dataImportConfigurations != null && dataImportConfigurations.length > 0) {
                IResource importFile = this.wizard_.getImportFile();
                if (importFile != null) {
                    IConfiguration[] tmp = this.getQualifiedImportConfigurations(dataImportConfigurations, importFile.getFileExtension());
                    if (tmp.length < 1) {
                        this.wizard_.setImportFile(null);
                    } else {
                        selectedConfiguration = tmp[0].getDisplayName();
                    }
                }
                this.buildMapping(dataImportConfigurations);
            }
        } else {
            selectedConfiguration = this.wizard_.getSelectedImportConfiguration().getDisplayName();
            this.mapping_.add(selectedConfiguration);
            this.mapping_.setEnabled(false);
        }
        if (this.mapping_.getItemCount() > 0) {
            if (selectedConfiguration != null) {
                this.mapping_.setText(selectedConfiguration);
            } else {
                this.mapping_.select(0);
            }
            if (this.scroller_.getContent() == null) {
                this.handleMappingChanged();
            }
        } else {
            this.setPageComplete(this.validatePage());
            this.scroller_.setVisible(false);
        }
    }

    protected void buildMapping(IConfiguration[] dataImportConfigurations) {
        ArrayList<String> cobolList = new ArrayList<String>(3);
        ArrayList<String> otherList = new ArrayList<String>(6);
        int index = 0;
        int i = 0;
        while (i < dataImportConfigurations.length) {
            if ("COBOL_TO_JAVA".equals(dataImportConfigurations[i].getName().getLocalPart())) {
                cobolList.add(index++, dataImportConfigurations[i].getDisplayName());
            } else if ("COBOL_MPO_TO_JAVA".equals(dataImportConfigurations[i].getName().getLocalPart())) {
                cobolList.add(index, dataImportConfigurations[i].getDisplayName());
            } else if ("COBOL_CICS_CHANNEL_TO_JAVA".equals(dataImportConfigurations[i].getName().getLocalPart())) {
                cobolList.add(dataImportConfigurations[i].getDisplayName());
            } else {
                otherList.add(dataImportConfigurations[i].getDisplayName());
            }
            this.mapping_.setData(dataImportConfigurations[i].getDisplayName(), (Object)dataImportConfigurations[i]);
            ++i;
        }
        i = 0;
        while (i < cobolList.size()) {
            this.mapping_.add((String)cobolList.get(i), i);
            ++i;
        }
        Collections.sort(otherList);
        i = 0;
        while (i < otherList.size()) {
            this.mapping_.add((String)otherList.get(i));
            ++i;
        }
    }

    protected void setInfoHelp(Composite main) {
        String pageName = this.getName();
        J2CLangUIInfoPopHelper.instance().setInfoHelp(main, pageName, J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE);
        J2CLangUIInfoPopHelper.instance().setInfoHelp(this.mapping_, pageName, "ChooseMapping", J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE);
        J2CLangUIInfoPopHelper.instance().setInfoHelp(this.mpoBrowseButton_, pageName, "MPOBrowse", J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE);
        J2CLangUIInfoPopHelper.instance().setInfoHelp(this.mpoImportButton_, pageName, "MPOImport", J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE);
        J2CLangUIInfoPopHelper.instance().setInfoHelp(this.mpoRemoveButton_, pageName, "MPORemove", J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE);
        if (this.mpoTableViewer_ != null) {
            J2CLangUIInfoPopHelper.instance().setInfoHelp(this.mpoTableViewer_.getControl(), pageName, J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE);
        }
        if (this.scroller_ != null) {
            J2CLangUIInfoPopHelper.instance().setInfoHelp(this.scroller_.getParent(), pageName, J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE);
        }
    }

    public void displayDetails() {
        Shell shell = this.getShell();
        Cursor cursor = null;
        if (shell != null) {
            Display d = shell.getDisplay();
            cursor = new Cursor((Device)d, 1);
            shell.setCursor(cursor);
        }
        try {
            String keyText;
            IConfiguration ic;
            String key;
            this.agent_ = this.wizard_.getSelectedImportConfiguration().createDiscoveryAgent();
            this.properties_ = this.agent_.getInitializeProperties();
            if (((BaseDiscoveryAgent)this.agent_).isSupportedConfiguration("SUPPORTS_ITERATION") && this.mapping_.isEnabled()) {
                this.properties_ = null;
                key = "MPO_DISCOVERY_AGENT";
            } else {
                key = this.mapping_.getText().trim();
            }
            LayoutInfo info = this.layouts_.get(key);
            if (info != null) {
                this.displayLayout(info);
            } else {
                this.generateLayout(key, this.properties_);
            }
            if (this.properties_ == null && (ic = (IConfiguration)this.mapping_.getData(keyText = this.mapping_.getText())) != null) {
                String name = ic.getName().getLocalPart();
                if (name.endsWith("CICS_CHANNEL_TO_JAVA")) {
                    this.mpoTableLabel_.setText(this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_LABEL_CONTAINERS"));
                } else {
                    this.mpoTableLabel_.setText(this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_LABEL_MPO"));
                }
            }
            this.setClassName(this.wizard_.getImportFile());
            this.setPageComplete(this.validatePage());
        }
        catch (BaseException ex) {
            PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)LangUIPlugin.getInstance(), (Throwable)ex, shell, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), PropertyGroupUIHelper.getDefault().getMessageFromCoreException((CoreException)ex));
        }
        catch (Exception e) {
            PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)LangUIPlugin.getInstance(), (Throwable)e, shell, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), e.getMessage());
        }
        if (shell != null) {
            shell.setCursor(null);
        }
        if (cursor != null) {
            cursor.dispose();
        }
    }

    public void displayLayout(LayoutInfo info) {
        this.uiComposite_ = info.uiLayout_;
        Composite main = info.Layout_;
        this.scroller_.setContent((Control)main);
        this.scroller_.reflow(true);
    }

    public void generateLayout(String key, IPropertyGroup properties) {
        if (properties != null) {
            PropertyUIFactory uiFactory = this.getPropertyUIFactory();
            uiFactory.setHelpContextIdPrefix(J2CLangUIInfoPopHelper.instance().getHelpPrefix(this.getName(), J2CLangUIInfoPopHelper.J2CLANGUI_WIZARD_PACKAGE));
            this.generateDynamicLayout((Composite)this.scroller_, uiFactory, properties);
            Composite main = this.uiComposite_.getComposite();
            GridLayout layout = (GridLayout)main.getLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.restoreFromStore(this.mapping_.getText(), this.getUIWidgets(), properties);
        } else {
            Composite main = this.factory_.createComposite((Composite)this.scroller_, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            main.setLayout((Layout)layout);
            this.createMPOArea(this.factory_, main);
            this.uiComposite_ = null;
            LayoutInfo info = new LayoutInfo();
            info.uiLayout_ = null;
            info.Layout_ = main;
            this.layouts_.put(key, info);
            this.scroller_.setContent((Control)main);
            this.scroller_.reflow(true);
        }
    }

    public void showAdvancedSection(boolean show, IPropertyGroup properties) {
        super.showAdvancedSection(show, properties);
        this.restoreFromStore(this.mapping_.getText(), this.getUIWidgets(), properties);
        this.setPageComplete(this.validatePage());
    }

    protected void createMPOArea(IPropertyUIWidgetFactory factory, Composite main) {
        this.mpoTableLabel_ = factory.createLabel(main, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_LABEL_MPO"), 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mpoTableLabel_.setLayoutData((Object)gd);
        Table table = this.factory_.createTable(main, 0x300 | this.factory_.getBorderStyle());
        this.mpoTableViewer_ = this.factory_.createTableViewer(table);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 128;
        gd.verticalSpan = 4;
        this.mpoTableViewer_.getTable().setLayoutData((Object)gd);
        this.mpoTableViewer_.addSelectionChangedListener((ISelectionChangedListener)this);
        this.mpoTableViewer_.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.mpoTableViewer_.setContentProvider((IContentProvider)this);
        this.mpoTableViewer_.setInput(this.mpoData_);
        this.mpoBrowseButton_ = this.factory_.createButton(main, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIDGETS_BUTTON_BROWSE"), 0x1000008);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.mpoBrowseButton_.setLayoutData((Object)gd);
        this.mpoBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        J2CLanguageImportWizard_InitPage.this.browseDataType();
                    }
                });
            }
        });
        this.mpoImportButton_ = this.factory_.createButton(main, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIDGETS_BUTTON_NEW"), 0x1000008);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.mpoImportButton_.setLayoutData((Object)gd);
        this.mpoImportButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2CLanguageImportWizard_InitPage.this.languageImport();
            }
        });
        this.mpoRemoveButton_ = this.factory_.createButton(main, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIDGETS_BUTTON_REMOVE"), 0x1000008);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.mpoRemoveButton_.setLayoutData((Object)gd);
        this.mpoRemoveButton_.setEnabled(false);
        this.mpoRemoveButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((StructuredSelection)J2CLanguageImportWizard_InitPage.this.mpoTableViewer_.getSelection()).getFirstElement();
                if (selection == null) {
                    return;
                }
                J2CLanguageImportWizard_InitPage.this.removeDataType(((SubMPOInfo)selection).getImportResult());
                J2CLanguageImportWizard_InitPage.this.mpoData_.remove(selection);
                J2CLanguageImportWizard_InitPage.this.mpoTableViewer_.setSelection(null);
                J2CLanguageImportWizard_InitPage.this.mpoTableViewer_.refresh();
                J2CLanguageImportWizard_InitPage.this.isModified(true);
                J2CLanguageImportWizard_InitPage.this.setPageComplete(J2CLanguageImportWizard_InitPage.this.validatePage());
            }
        });
    }

    public boolean validateMPOStatus() {
        String errMsg = null;
        if (this.mpoData_.size() < 1) {
            errMsg = this.messageBundle_.getMessage("ERROR_WIZARDS_VALUE_CANNOT_BE_EMPTY", (Object[])J2CUICoreHelper.getDefault().getDisplayString(this.mpoTableLabel_.getText()));
        }
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        return true;
    }

    public boolean validatePage() {
        boolean valid = true;
        this.hasMessage_ = false;
        if (this.properties_ == null && this.mpoTableLabel_ != null) {
            valid = this.validateMPOStatus();
        } else if (this.mapping_.getText() == null || this.mapping_.getText().trim().length() < 1) {
            valid = false;
            this.setErrorMessage(this.messageBundle_.getMessage("ERROR_WIZARDS_VALUE_CANNOT_BE_EMPTY", (Object[])J2CUICoreHelper.getDefault().getDisplayString(this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_LABEL_CHOOSE_MAPING"))));
        } else {
            valid = this.determinePageCompletion();
        }
        if (valid) {
            this.cleanMessage();
        }
        return valid;
    }

    protected void browseDataType() {
        IPath[] paths;
        J2CLanguageImportUIController controller = this.wizard_.getUIController();
        if (controller != null && (paths = controller.browseDataTypeForMPO(this.wizard_)) != null && paths.length > 0) {
            URI dataTypeURI = null;
            SubMPOInfo subInfo = null;
            IPropertyGroup properties = null;
            FileProperty fileProp = null;
            int i = 0;
            while (i < paths.length) {
                block12: {
                    try {
                        String dataTypeName = paths[i].lastSegment();
                        dataTypeName = dataTypeName.substring(0, dataTypeName.lastIndexOf(46));
                        dataTypeURI = J2CUICoreHelper.getDefault().createEMFURI(paths[i].toString(), 2);
                        if (properties == null) {
                            properties = this.agent_.getInitializeProperties();
                        }
                        if (fileProp == null) {
                            ArrayList files = J2CUIPropertyUtil.getProperties((IPropertyGroup)properties, (int)4);
                            if (files == null || files.isEmpty()) break block12;
                            fileProp = (FileProperty)files.get(0);
                        }
                        fileProp.setValue((Object)dataTypeURI);
                        IEnvironment env = this.wizard_.getImportEnvironment();
                        IImportResult iResult = this.wizard_.getImportResult();
                        this.agent_.initializeContext(new Object[]{iResult});
                        this.agent_.initialize(env, properties);
                        ISearchTree searchTree = this.agent_.getSearchTree();
                        IPropertyGroup searchProps = searchTree.getFilterProperties();
                        IResultNodeResponse queryResult = searchTree.performQuery(searchProps, env);
                        IResultNodeSelection resultNodeSelection = searchTree.createResultNodeSelection();
                        resultNodeSelection.add(queryResult.getResultNodeIterator().nextResultNode());
                        IImportResult result = this.agent_.performImport(env, resultNodeSelection);
                        if (iResult == null) {
                            this.wizard_.setImportResult(result);
                        }
                        if (subInfo == null) {
                            subInfo = this.setSubMPOInfo(dataTypeName);
                        } else {
                            this.setSubMPOInfo(dataTypeName);
                        }
                        if (subInfo != null) {
                            subInfo.getIOMessageSubInfo().setSource(dataTypeURI);
                        }
                        this.isModified(true);
                    }
                    catch (CoreException e) {
                        PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)LangUIPlugin.getInstance(), (Throwable)e, this.getShell(), this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), e.getStatus().getMessage());
                    }
                }
                ++i;
            }
            this.mpoTableViewer_.refresh();
            if (subInfo != null) {
                this.mpoTableViewer_.setSelection((ISelection)new StructuredSelection(subInfo));
            }
            this.setPageComplete(this.validatePage());
        }
    }

    protected void languageImport() {
        SubMPOInfo[] infos;
        J2CLanguageImportUIController controller = this.wizard_.getUIController();
        if (controller != null && (infos = controller.languageImportForMPO(this.wizard_)) != null && infos.length > 0) {
            SubMPOInfo selection = null;
            int i = 0;
            while (i < infos.length) {
                this.mpoData_.add(infos[i]);
                if (selection == null) {
                    selection = infos[i];
                }
                ++i;
            }
            this.mpoTableViewer_.refresh();
            this.mpoTableViewer_.setSelection((ISelection)new StructuredSelection(selection));
            this.isModified(true);
            this.setPageComplete(this.validatePage());
        }
    }

    protected void removeDataType(IImportResult importData) {
        Object dataList = ((J2CLanguageImportWizard)this.getWizard()).getImportResult().getImportData();
        if (dataList instanceof ArrayList) {
            ((ArrayList)dataList).remove(importData);
        }
    }

    public SubMPOInfo setSubMPOInfo(String dataName) {
        ArrayList dataList;
        SubMPOInfo subInfo = null;
        Object importData = this.wizard_.getImportResult().getImportData();
        if (importData instanceof ArrayList && (dataList = (ArrayList)importData).size() > this.mpoData_.size()) {
            int i = dataList.size() - 1;
            while (i >= 0) {
                Object subData = dataList.get(i);
                boolean isFound = false;
                int j = this.mpoData_.size() - 1;
                while (j >= 0) {
                    SubMPOInfo info = this.mpoData_.get(j);
                    if (info.getImportResult().equals(subData)) {
                        isFound = true;
                        if (!info.getIOMessageSubInfoName().equals(dataName)) break;
                        return info;
                    }
                    --j;
                }
                if (!isFound) {
                    subInfo = new SubMPOInfo();
                    subInfo.getIOMessageSubInfo().setName(dataName);
                    subInfo.setImportResult((IImportResult)subData);
                    this.mpoData_.add(subInfo);
                    return subInfo;
                }
                --i;
            }
        }
        return subInfo;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        MessageBundleWizardDynamicPage_PropertyGroup nextPage = this;
        Shell shell = this.getShell();
        Cursor cur = null;
        if (shell != null) {
            Display d = shell.getDisplay();
            cur = new Cursor((Device)d, 1);
            shell.setCursor(cur);
        }
        try {
            if (this.properties_ != null) {
                nextPage = super.getNextPage();
                if (this.wizard_.isForMPOData()) {
                    this.agent_.initializeContext(new Object[]{this.wizard_.getImportResult()});
                    this.agent_.initialize(this.wizard_.getImportEnvironment(), this.properties_);
                } else {
                    this.agent_.initializeContext(this.wizard_.getContext());
                    this.agent_.initialize(this.wizard_.getImportEnvironment(), this.properties_);
                }
                this.searchTree_ = this.agent_.getSearchTree();
                IPropertyGroup searchProps = this.searchTree_.getFilterProperties();
                this.isModified(false);
                ((J2CLanguageImportWizard_ImporterPage)nextPage).resultNodeSelection_ = null;
                ((J2CLanguageImportWizard_ImporterPage)nextPage).displayPage(searchProps);
                ((J2CLanguageImportWizard_ImporterPage)nextPage).updateTreeViewer(searchProps);
            } else {
                nextPage = this.wizard_.getSavingPage();
                this.wizard_.getImporterPage().setPageComplete(true);
                if (this.isModified()) {
                    ResourceWriterInfo info = new ResourceWriterInfo(this.wizard_.getSelectedImportConfiguration().createResourceWriter(), this.wizard_.getImportEnvironment(), this.wizard_.getImportResult(), this.wizard_.getContext());
                    this.wizard_.setResourceWriterInfo(info);
                    ((J2CLanguageImportWizard_SavingPage)nextPage).displayPage(info.getWriteProperties());
                    this.isModified(false);
                }
            }
        }
        catch (BaseException ie) {
            PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)LangUIPlugin.getInstance(), (Throwable)ie, shell, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), PropertyGroupUIHelper.getDefault().getMessageFromCoreException((CoreException)((Object)ie)));
            if (ie.getStatus().getSeverity() == 4) {
                nextPage = this;
            }
        }
        catch (Exception e) {
            PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)LangUIPlugin.getInstance(), (Throwable)e, shell, this.messageBundle_.getMessage("J2CLANGUAGEIMPORT_WIZARDS_TITLE_ERROR"), e.getMessage());
            nextPage = this;
        }
        if (shell != null) {
            shell.setCursor(null);
        }
        if (cur != null) {
            cur.dispose();
        }
        return nextPage;
    }

    public void inputChanged(Viewer v, Object old, Object nw) {
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        if (((StructuredSelection)this.mpoTableViewer_.getSelection()).size() > 0) {
            this.mpoRemoveButton_.setEnabled(true);
        } else {
            this.mpoRemoveButton_.setEnabled(false);
        }
    }

    public Object[] getElements(Object input) {
        if (input instanceof ArrayList) {
            return ((ArrayList)input).toArray();
        }
        return new Object[0];
    }

    public void isModified(boolean newValue) {
        super.isModified(newValue);
        if (newValue) {
            if (!this.wizard_.isForMPOData()) {
                this.wizard_.getSavingPage().setPageComplete(false);
            } else {
                this.wizard_.getImporterPage().setPageComplete(false);
            }
            this.setPageComplete(this.isPageComplete());
        }
    }

    public void restoreFromStore(String lang, ArrayList<PropertyUIWidget> Widgets, IPropertyGroup properties) {
        this.currentMapping_ = lang;
        if (this.istore != null) {
            this.istore.restoreFromStore("Mapping", lang, Widgets, properties);
        }
    }

    public void saveToStore() {
        this.currentMapping_ = this.mapping_.getText();
        if (this.istore != null) {
            this.istore.saveToStore("Mapping", this.mapping_.getText(), this.properties_);
        }
    }

    protected IConfiguration[] getQualifiedImportConfigurations(IConfiguration[] ics, String fileExtension) {
        ArrayList<IConfiguration> qICs = new ArrayList<IConfiguration>();
        if (fileExtension != null && fileExtension.length() > 0) {
            int i = 0;
            while (i < ics.length) {
                block6: {
                    IDiscoveryAgent agent = ics[i].createDiscoveryAgent();
                    try {
                        IPropertyGroup initProperties = agent.getInitializeProperties();
                        ArrayList files = J2CUIPropertyUtil.getProperties((IPropertyGroup)initProperties, (int)4);
                        if (files == null || files.size() <= 0) break block6;
                        FileProperty fProperty = (FileProperty)files.get(0);
                        String[] extensions = fProperty.getFileExtensions();
                        int j = 0;
                        while (j < extensions.length) {
                            if (extensions[j].equals(fileExtension)) {
                                qICs.add(ics[i]);
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (BaseException ie) {
                        J2CLogUtil.log((String)ie.getMessage(), (short)60);
                    }
                }
                ++i;
            }
        }
        IConfiguration[] retICs = new IConfiguration[qICs.size()];
        qICs.toArray(retICs);
        return retICs;
    }

    protected void setClassName(IResource file) {
        ArrayList classes;
        if (file != null && (classes = J2CUIPropertyUtil.getProperties((IPropertyGroup)this.properties_, (int)4)) != null && classes.size() > 0) {
            try {
                URI newURI = URI.createFileURI((String)file.getLocation().toString());
                ((FileProperty)classes.get(0)).setValue((Object)newURI);
            }
            catch (CoreException e) {
                J2CLogUtil.log((String)e.getMessage(), (short)60);
            }
        }
    }

    public ArrayList<SubMPOInfo> getMPOData() {
        return this.mpoData_;
    }

    public IDiscoveryAgent getDiscoveryAgent() {
        return this.agent_;
    }

    public ISearchTree getSearchTree() {
        return this.searchTree_;
    }

    private class LayoutInfo {
        PropertyUIComposite uiLayout_;
        Composite Layout_;

        private LayoutInfo() {
        }
    }

    private class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof SubMPOInfo) {
                return ((SubMPOInfo)element).getIOMessageSubInfoName();
            }
            return element == null ? "" : element.toString();
        }
    }
}

