/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.lang.ui.internal.providers;

import com.ibm.adapter.framework.IResultNode;
import com.ibm.j2c.lang.ui.internal.messages.LangUIMessageBundle;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class LanguageElementLabelProvider
implements ILabelProvider {
    private Hashtable allocatedImages_ = new Hashtable();
    private int elementType_ = 0;
    private LangUIMessageBundle bundle_;
    public static final int ELEMENT_DATA_TYPE = 0;
    public static final int ELEMENT_PORT_TYPE = 1;

    public LanguageElementLabelProvider(LangUIMessageBundle bundle) {
        this.bundle_ = bundle;
    }

    public Image getImage(Object element) {
        if (element instanceof String) {
            return this.getImage(this.bundle_.getMessage("ICON_INFORMATION_OBJECT"));
        }
        if (element instanceof IResultNode) {
            switch (this.elementType_) {
                case 1: {
                    if (((IResultNode)element).isLeafNode()) {
                        return this.getImage(this.bundle_.getMessage("ICON_OPERATION_OBJECT"));
                    }
                    return this.getImage(this.bundle_.getMessage("ICON_BUSINESS_OBJECT"));
                }
            }
            return this.getImage(this.bundle_.getMessage("ICON_DATATYPE_OBJECT"));
        }
        return null;
    }

    public Image getImage(String iconPath) {
        if (iconPath != null) {
            Image im = (Image)this.allocatedImages_.get(iconPath);
            if (im != null) {
                return im;
            }
            ImageDescriptor imD = this.bundle_.getImageDescriptor(iconPath);
            if (imD != null) {
                im = imD.createImage();
                this.allocatedImages_.put(iconPath, im);
            }
            return im;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IResultNode) {
            String name = ((IResultNode)element).getName();
            if (name != null) {
                return name;
            }
        } else if (element instanceof String) {
            return (String)element;
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Enumeration ims = this.allocatedImages_.elements();
        while (ims.hasMoreElements()) {
            Image i = (Image)ims.nextElement();
            if (i.isDisposed()) continue;
            i.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setElementType(int newType) {
        this.elementType_ = newType;
    }
}

