/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.lang.ui.internal.properties;

import com.ibm.j2c.lang.ui.internal.messages.LangUIMessages;
import com.ibm.j2c.lang.ui.internal.properties.BooleanPropertyGroup;
import com.ibm.j2c.lang.ui.internal.properties.PlatformFileProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.common.FileProperty;
import com.ibm.propertygroup.spi.common.JavaClassNameProperty;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class SessionAntPropertyGroup
extends BooleanPropertyGroup {
    public static final int OUTPUT_STYLE_NEWFILE = 0;
    public static final int OUTPUT_STYLE_OVERWRITE = 1;
    public static final int OUTPUT_STYLE_APPEND = 2;
    public static final String FILE_EXTENSION = "xml";
    protected FileProperty file_;
    protected BaseSingleValuedProperty outputDefaultSettings_;
    protected int outputStyle_ = 0;
    protected Composite container_;
    protected JavaProjectProperty project_;
    protected JavaClassNameProperty class_;
    protected boolean isModified_ = false;

    public SessionAntPropertyGroup() throws CoreException {
        super(LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_RECORD_SESSION, LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_RECORD_SESSION, LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_RECORD_SESSION, false, false);
    }

    @Override
    protected void initializePropertyGroup(String name, String dName, String desc, boolean selected, boolean expert) throws CoreException {
        super.initializePropertyGroup(name, dName, desc, selected, expert);
        this.file_ = new PlatformFileProperty(LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_FILE, LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_FILE, LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_FILE_DESC, this, new String[]{FILE_EXTENSION});
        this.file_.setRequired(true);
        this.file_.assignID("com.ibm.j2c.lang.ui.session_output_property");
        this.file_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.outputDefaultSettings_ = new BaseSingleValuedProperty(LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_OUTPUT_DEFAULT_SETTINGS, LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_OUTPUT_DEFAULT_SETTINGS, LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_OUTPUT_DEFAULT_SETTINGS_DESC, Boolean.class, (BasePropertyGroup)this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SessionAntPropertyGroup clone = (SessionAntPropertyGroup)((Object)super.clone());
        FileProperty property = (FileProperty)clone.getProperty(LangUIMessages.J2CLANGUAGEIMPORT_WIZARDS_FILE);
        if (property != null) {
            clone.file_ = property;
            property.addPropertyChangeListener((IPropertyChangeListener)clone);
        }
        return clone;
    }

    public FileProperty getAntFileProperty() {
        return this.file_;
    }

    public URI getAntFile() {
        return (URI)this.file_.getValue();
    }

    public String getAntFileAsString() {
        return this.file_.getValueAsString();
    }

    public IFile getAntIFile() {
        URI uri = this.getAntFile();
        if (uri != null) {
            String path = this.file_.getValueAsString();
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        return null;
    }

    public int getOutputStyle() {
        return this.outputStyle_;
    }

    public void setOutputStyle(int style) {
        this.outputStyle_ = style;
    }

    public BaseSingleValuedProperty getOutputDefaultSettingsProperty() {
        return this.outputDefaultSettings_;
    }

    public boolean outputDefaultSettings() {
        Boolean value;
        if (this.outputDefaultSettings_ != null && (value = (Boolean)this.outputDefaultSettings_.getValue()) != null) {
            return value;
        }
        return false;
    }

    public Composite getContainer() {
        return this.container_;
    }

    public void setContainer(Composite container) {
        this.container_ = container;
        if (container != null) {
            container.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (e.widget == SessionAntPropertyGroup.this.container_) {
                        SessionAntPropertyGroup.this.disposeProperty();
                    }
                }
            });
        }
        this.container_.setVisible(this.isSelected());
    }

    public void setProjectProperty(JavaProjectProperty jpp) {
        if (this.project_ != null) {
            this.project_.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.project_ = jpp;
        if (this.project_ != null) {
            if (this.isSelected() && !this.isModified_) {
                this.updateFileProperty();
            }
            this.project_.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public JavaProjectProperty getProjectProperty() {
        return this.project_;
    }

    public void setClassProperty(JavaClassNameProperty jcnp) {
        if (this.class_ != null) {
            this.class_.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.class_ = jcnp;
        if (this.class_ != null) {
            if (this.isSelected() && !this.isModified_) {
                this.updateFileProperty();
            }
            this.class_.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public JavaClassNameProperty getClassProperty() {
        return this.class_;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyChangeType()) {
            case 0: {
                Object source = evt.getSource();
                if (source == this.file_) {
                    if (this.isModified_) break;
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (newValue == oldValue || (newValue == null || newValue.equals(oldValue)) && (oldValue == null || oldValue.equals(newValue))) break;
                    this.isModified_ = true;
                    break;
                }
                if (source == this.project_ || source == this.class_) {
                    if (this.isModified_ || !this.isSelected()) break;
                    this.updateFileProperty();
                    break;
                }
                super.propertyChange(evt);
                break;
            }
            default: {
                super.propertyChange(evt);
            }
        }
    }

    @Override
    protected void enableProperties(IPropertyGroup group, boolean enable) {
        this.container_.setVisible(enable);
        if (enable && !this.isModified_) {
            this.updateFileProperty();
        }
    }

    protected void updateFileProperty() {
        if (this.project_ != null && this.class_ != null) {
            String project = this.project_.getValueAsString();
            String clazz = this.class_.getValueAsString();
            if (project != null && project.length() > 0 && clazz != null && clazz.length() > 0) {
                Path fullPath = new Path(project);
                int index = clazz.lastIndexOf(".");
                if (index != -1) {
                    clazz = clazz.substring(0, index);
                }
                fullPath = fullPath.append(clazz);
                fullPath = fullPath.addFileExtension(FILE_EXTENSION);
                this.file_.removePropertyChangeListener((IPropertyChangeListener)this);
                try {
                    this.file_.setValueAsString(fullPath.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.file_.addPropertyChangeListener((IPropertyChangeListener)this);
            }
        }
    }

    public void disposeProperty() {
        if (this.project_ != null) {
            this.project_.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if (this.class_ != null) {
            this.class_.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }
}

