/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.jsf.ui.wizards;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.spi.Environment;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.MethodInvokingJBData;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.MethodSelectionPage;
import com.ibm.etools.webtools.pagedatamodel.wizards.Util;
import com.ibm.j2c.javabean.ui.wizards.J2CJavaBeanWizard;
import com.ibm.j2c.jsf.ui.internal.data.J2CJSFWizardData;
import com.ibm.j2c.jsf.ui.internal.data.J2CJavaBeanData;
import com.ibm.j2c.jsf.ui.internal.messages.J2CJSFUIMessages;
import com.ibm.j2c.jsf.ui.internal.utilities.J2CJSFUIHelper;
import com.ibm.j2c.jsf.ui.plugin.J2CJSFUIPlugin;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.model.J2CUIInfo;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.j2c.ui.internal.utilities.J2CUIHelper;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class J2CJSFWizard_SelectionPage
extends MethodSelectionPage {
    protected TreeViewer treeViewer_;
    protected Button fGenerateUIButton;
    protected Hashtable addedProjectNames_;
    private IEnvironment environment_;

    public J2CJSFWizard_SelectionPage(MethodInvokingJBData data) {
        super(data);
        this.setTitle(J2CJSFUIMessages.J2CJSF_WIZARD_JBSELECTION_PAGE_TITLE);
        this.setDescription(J2CJSFUIMessages.J2CJSF_WIZARD_JBSELECTION_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createPageControl(parent);
        this.setPageComplete(this.isPageComplete());
        this.setControl((Control)composite);
    }

    public boolean validatePage() {
        boolean status = super.isPageComplete();
        if (!status) {
            this.setErrorMessage(J2CJSFUIMessages.ERROR_WIZARDS_SELECT_JAVAMETHOD);
        } else {
            this.setErrorMessage(null);
        }
        return status;
    }

    protected Composite createPageControl(Composite parent) {
        IPropertyUIWidgetFactory factory = J2CUIHelper.instance().getFactory();
        Composite composite = factory.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.treeViewer_ = this.createTreeViewer(factory, composite);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        this.treeViewer_.getTree().setLayoutData((Object)gd);
        this.createButton(factory, composite, J2CJSFUIMessages.J2CJSF_WIZARD_BUTTON_ADD, J2CJSFUIMessages.J2CJSF_WIZARD_BUTTON_ADD_DESC, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2CJSFWizard_SelectionPage.this.handleAddButton();
            }
        });
        this.createButton(factory, composite, J2CJSFUIMessages.J2CJSF_WIZARD_BUTTON_NEW, J2CJSFUIMessages.J2CJSF_WIZARD_BUTTON_NEW_DESC, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2CJSFWizard_SelectionPage.this.handleNewButton();
            }
        });
        if (this.fWizardData.isGenerateUI()) {
            this.createGenerateUIArea(factory, composite);
        }
        this.initTreeViewer();
        return composite;
    }

    protected TreeViewer createTreeViewer(IPropertyUIWidgetFactory factory, Composite parent) {
        Tree tree = factory.createTree(parent, 2052);
        TreeViewer viewer = factory.createTreeViewer(tree);
        return viewer;
    }

    protected Button createButton(IPropertyUIWidgetFactory factory, Composite parent, String text, String toolTip, SelectionAdapter sAdapter) {
        Button button = factory.createButton(parent, text, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        button.setLayoutData((Object)gd);
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        }
        if (sAdapter != null) {
            button.addSelectionListener((SelectionListener)sAdapter);
        }
        return button;
    }

    protected void createGenerateUIArea(IPropertyUIWidgetFactory factory, Composite parent) {
        int columnNo = ((GridLayout)parent.getLayout()).numColumns;
        Label label = factory.createLabel(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnNo;
        label.setLayoutData((Object)gd);
        this.fGenerateUIButton = factory.createButton(parent, J2CJSFUIMessages.J2CJSF_WIZARD_BUTTON_CREATE_UI, 16416);
        gd = new GridData(8);
        gd.horizontalSpan = columnNo;
        this.fGenerateUIButton.setLayoutData((Object)gd);
        this.fGenerateUIButton.setSelection(this.fWizardData.isGenerateUI());
        this.fGenerateUIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2CJSFWizard_SelectionPage.this.handleCreateFormButton(e);
            }
        });
    }

    protected void initTreeViewer() {
        this.treeViewer_.setContentProvider((IContentProvider)new J2CJavaBeanMethodTreeContentProvider());
        this.treeViewer_.setLabelProvider((IBaseLabelProvider)new J2CJavaBeanMethodTreeLabelProvider());
        this.treeViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        J2CJSFWizard_SelectionPage.this.handleTreeNodeSelectionChanged(event);
                    }
                });
            }
        });
        this.treeViewer_.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(final DoubleClickEvent event) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        J2CJSFWizard_SelectionPage.this.handleTreeNodeDoubleClick(event);
                    }
                });
            }
        });
        this.treeViewer_.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof J2CJavaBeanData && e2 instanceof J2CJavaBeanData) {
                    return ((J2CJavaBeanData)e1).getDisplayLabel().compareTo(((J2CJavaBeanData)e2).getDisplayLabel());
                }
                if (e1 instanceof Method && e2 instanceof Method) {
                    return ((Method)e1).getName().compareTo(((Method)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.treeViewer_.setInput((Object)((J2CJSFWizardData)this.fWizardData).getBeanDataList());
    }

    protected void handleTreeNodeSelectionChanged(SelectionChangedEvent e) {
        Object selection = ((StructuredSelection)this.treeViewer_.getSelection()).getFirstElement();
        J2CJavaBeanData selectedBean = null;
        if (selection != null) {
            if (selection instanceof J2CJavaBeanData) {
                this.treeViewer_.expandToLevel(2);
                selectedBean = (J2CJavaBeanData)selection;
                selectedBean.setSelectedMethod(null);
            } else {
                selectedBean = (J2CJavaBeanData)this.treeViewer_.getTree().getSelection()[0].getParentItem().getData();
                selectedBean.setSelectedMethod((Method)selection);
                this.setMethod((Method)selection);
            }
        }
        ((J2CJSFWizardData)this.fWizardData).setSelectedBean(selectedBean);
        this.setPageComplete(this.validatePage());
    }

    protected void handleTreeNodeDoubleClick(DoubleClickEvent e) {
        IWizardPage page;
        if (this.isPageComplete() && (page = this.getNextPage()) != null) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    protected void handleAddButton() {
        IVirtualComponent comp = this.fWizardData.getComponent();
        IProject currentProject = comp.getProject();
        IResource[] resources = J2CUIHelper.instance().getSearchProjects(currentProject.getName());
        final IType tp = J2CUIHelper.instance().browseJ2CJavaBeanFromWorkspace(this.getShell(), resources);
        if (tp != null) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    J2CServiceDescription osd;
                    if (J2CJSFWizard_SelectionPage.this.environment_ == null) {
                        J2CJSFWizard_SelectionPage.this.environment_ = (IEnvironment)new Environment((IProgressMonitor)new NullProgressMonitor(), null);
                    }
                    if ((osd = J2CJSFUIHelper.instance().createOutboundModel(tp, J2CJSFWizard_SelectionPage.this.environment_, J2CJSFWizard_SelectionPage.this.getShell())) != null) {
                        J2CJSFWizard_SelectionPage.this.addBeanToTreeView(tp.getResource().getProject(), tp.getFullyQualifiedName(), osd);
                    } else {
                        MessageDialog.openError((Shell)J2CJSFWizard_SelectionPage.this.getShell(), (String)J2CUIMessages.J2C_UI_WIZARDS_ERRTITLE_UI_, (String)J2CJSFUIMessages.ERROR_J2CJSF_CANNOT_CREATE_MODEL);
                    }
                }
            });
        }
    }

    protected void handleNewButton() {
        Shell shell = this.getShell();
        Cursor cursor = null;
        if (shell != null) {
            Display d = shell.getDisplay();
            cursor = new Cursor((Device)d, 1);
            shell.setCursor(cursor);
        }
        J2CJavaBeanWizard wiz = new J2CJavaBeanWizard();
        wiz.showGeneratedJavaBean(false);
        wiz.wizardSupportsOutboundOnly(true);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wiz);
        dialog.create();
        dialog.getShell().setSize(610, 610);
        dialog.open();
        if (dialog.getReturnCode() != 1) {
            final J2CUIInfo info = wiz.getUIInfo();
            final String[] implPath = wiz.getImplPathSegments();
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    J2CServiceDescription oid = info.JavaInterface_;
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(info.ProjectName_);
                    Util.ensureBuildComplete((IProject)project, (boolean)false);
                    if (implPath[1] != null && implPath[1].length() > 0 && implPath[2] != null && implPath[2].length() > 0) {
                        StringBuffer fullName = new StringBuffer(implPath[1]);
                        fullName.append(".").append(implPath[2]);
                        J2CJSFWizard_SelectionPage.this.addBeanToTreeView(project, fullName.toString(), oid);
                    }
                }
            });
        }
        if (shell != null) {
            shell.setCursor(null);
        }
        if (cursor != null) {
            cursor.dispose();
        }
    }

    protected void addBeanToTreeView(IProject project, String name, J2CServiceDescription oid) {
        if (oid != null && project != null && name != null && name.length() > 0) {
            try {
                this.updateClassPath(project);
                JavaClass beanClass = (JavaClass)J2CJSFUIHelper.instance().introspect(name, project);
                J2CJavaBeanData newData = new J2CJavaBeanData(beanClass, oid);
                ((J2CJSFWizardData)this.fWizardData).getBeanDataList().clear();
                ((J2CJSFWizardData)this.fWizardData).addJ2CJavaBeanData(newData);
                this.treeViewer_.refresh();
                this.selectTreeNode(newData);
                ArrayList methods = newData.getMethods();
                if (methods != null && methods.size() > 0) {
                    this.selectTreeNode(methods.get(0));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void updateClassPath(IProject project) {
        IVirtualComponent comp = this.fWizardData.getComponent();
        IProject currentProject = comp.getProject();
        if (!currentProject.equals((Object)project)) {
            ArrayList<String> projects;
            String projectName = project.getName();
            DeploymentUtils.addUtilityProjectToModule((String)projectName, (String)projectName, (IVirtualComponent)comp);
            ResourceUtils.updateClassPath((String)projectName, (IProject)currentProject);
            Util.ensureBuildComplete((IProject)project, (boolean)false);
            if (this.addedProjectNames_ == null) {
                this.addedProjectNames_ = new Hashtable();
            }
            if ((projects = (ArrayList<String>)this.addedProjectNames_.get(currentProject)) == null) {
                projects = new ArrayList<String>(3);
                this.addedProjectNames_.put(currentProject, projects);
            }
            if (projects.indexOf(projectName) == -1) {
                projects.add(projectName);
            }
        }
    }

    protected void selectTreeNode(Object newSelection) {
        StructuredSelection selection = new StructuredSelection(newSelection);
        this.treeViewer_.setSelection((ISelection)selection, true);
        this.treeViewer_.getTree().setFocus();
    }

    protected void handleCreateFormButton(SelectionEvent e) {
        this.fWizardData.setGenerateUI(this.fGenerateUIButton.getSelection());
        this.canFlipToNextPage();
        this.setPageComplete(this.isPageComplete());
    }

    private class J2CJavaBeanMethodTreeContentProvider
    implements ITreeContentProvider {
        private J2CJavaBeanMethodTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ArrayList) {
                return ((ArrayList)parentElement).toArray();
            }
            if (parentElement instanceof J2CJavaBeanData) {
                ArrayList methods = ((J2CJavaBeanData)parentElement).getMethods();
                if (methods == null || methods.isEmpty()) {
                    return new Object[0];
                }
                return methods.toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class J2CJavaBeanMethodTreeLabelProvider
    implements ILabelProvider {
        private Hashtable allocatedImages_ = new Hashtable();

        public String getText(Object element) {
            if (element instanceof J2CJavaBeanData) {
                return ((J2CJavaBeanData)element).getDisplayLabel();
            }
            if (element instanceof Method) {
                return ((Method)element).getMethodElementSignature();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof J2CJavaBeanData) {
                return this.getTreeNodeImage("icons/obj16/j2c_jb_pal.gif");
            }
            if (element instanceof Method) {
                return this.getTreeNodeImage("icons/method.gif");
            }
            return null;
        }

        protected Image getTreeNodeImage(String path) {
            Image im = (Image)this.allocatedImages_.get(path);
            if (im != null) {
                return im;
            }
            im = J2CJSFUIPlugin.getImageDescriptor(path).createImage();
            this.allocatedImages_.put(path, im);
            return im;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            Enumeration ims = this.allocatedImages_.elements();
            while (ims.hasMoreElements()) {
                Image i = (Image)ims.nextElement();
                if (i.isDisposed()) continue;
                i.dispose();
            }
        }
    }
}

