/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.utils;

import com.ibm.j2c.emd.internal.ui.model.BusinessTypeJavaRecordInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class JavaResourceVisitor
implements IResourceVisitor {
    private static String XSD_LOCATION = "xsdLocation";
    private static String XSD_TYPE_NAME = "typeName";
    private Hashtable allInfosByXSDFile = new Hashtable();

    public boolean visit(IResource resource) throws CoreException {
        BusinessTypeJavaRecordInfo info;
        IFile f;
        String sName;
        if (resource instanceof IFile && (sName = (f = (IFile)resource).getName()).endsWith(".java") && (info = this.getJavaRecordInfo(f)) != null) {
            ArrayList<BusinessTypeJavaRecordInfo> lst = (ArrayList<BusinessTypeJavaRecordInfo>)this.allInfosByXSDFile.get(info.getXsdLocation());
            if (lst != null) {
                lst.add(info);
                this.allInfosByXSDFile.put(info.getXsdLocation(), lst);
            } else {
                lst = new ArrayList<BusinessTypeJavaRecordInfo>();
                lst.add(info);
                this.allInfosByXSDFile.put(info.getXsdLocation(), lst);
            }
        }
        return true;
    }

    private String getStringFromInputStream(InputStream in) {
        try {
            StringBuffer out = new StringBuffer();
            byte[] b = new byte[1024];
            int n = in.read(b);
            out.append(new String(b, 0, n));
            return out.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BusinessTypeJavaRecordInfo getJavaRecordInfo(IFile file) {
        String sContent = null;
        try {
            InputStream is = file.getContents();
            sContent = this.getStringFromInputStream(is);
            is.close();
        }
        catch (Exception exception) {}
        if (sContent != null && sContent.indexOf("J2C7004") > 0) {
            int indx1 = sContent.indexOf(XSD_LOCATION);
            int indx2 = sContent.indexOf(XSD_TYPE_NAME);
            if (indx1 > 0 && indx2 > 0) {
                String xsdLocation = this.getValueForTheKey(XSD_LOCATION, sContent);
                String xsdTypeName = this.getValueForTheKey(XSD_TYPE_NAME, sContent);
                if (xsdLocation != null && xsdTypeName != null) {
                    return new BusinessTypeJavaRecordInfo(xsdLocation, xsdTypeName, file);
                }
            } else {
                return null;
            }
        }
        return null;
    }

    private String getValueForTheKey(String key, String target) {
        String temp1;
        int indx2;
        int indx = target.indexOf(key);
        if (indx > 0 && (indx2 = (temp1 = target.substring(indx + key.length())).indexOf(61)) >= 0) {
            String temp2 = temp1.substring(indx2 + 1);
            int ind3 = (temp2 = temp2.trim()).indexOf(" ");
            if (ind3 > 0) {
                String value = temp2.substring(0, ind3);
                return value;
            }
        }
        return null;
    }

    public Hashtable getAllInfosByXSDFileLocation() {
        return this.allInfosByXSDFile;
    }
}

