/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.refactor;

import com.ibm.j2c.emd.internal.refactor.J2CEmdXSDRefactoringChange;
import com.ibm.j2c.emd.internal.ui.messages.J2CEMDUIMessages;
import com.ibm.j2c.emd.internal.utils.J2CEmdHelper;
import com.ibm.j2c.emd.internal.utils.J2CEmdUtils;
import commonj.connector.metadata.description.DataBindingGenerator;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class JavaRefactoringParticipant
extends RenameParticipant {
    XSDTypeDefinition component;
    protected Refactoring[] delegatingRefactoring;
    private DataBindingGenerator generator;
    private final String PLATFORM_RESOURCE = "platform:/resource";
    private String genName = null;
    private IFile[] files = null;

    protected boolean initialize(Object element) {
        if (element instanceof XSDTypeDefinition) {
            IProject pr;
            this.component = (XSDTypeDefinition)element;
            XSDSchema xsdSc = ((XSDTypeDefinition)element).getSchema();
            J2CEmdHelper emdHelper = J2CEmdUtils.getEMDHelper();
            this.generator = emdHelper.getDataBindingGenerator(xsdSc, null);
            this.genName = emdHelper.getGeneratorName();
            String sPlatU = xsdSc.eResource().getURI().toString();
            if (sPlatU.startsWith("platform:/resource")) {
                sPlatU = sPlatU.substring("platform:/resource".length());
            }
            if ((pr = J2CEmdUtils.getProjectFromWorkspaceRelativePath(sPlatU)) != null) {
                String sRecName;
                IFile jFile;
                IType[] derivedElement;
                QName qn = new QName(this.component.getTargetNamespace(), this.component.getName());
                String[] jRecNames = null;
                try {
                    jRecNames = this.generator.getDataBindingClassNames(qn, null);
                }
                catch (Exception exception) {
                    return false;
                }
                if (jRecNames != null && jRecNames.length > 0 && (derivedElement = this.findDerivedJavaTypes(jFile = J2CEmdUtils.getIFileFromFullJavaRecordName(sRecName = jRecNames[0], pr))) != null) {
                    this.delegatingRefactoring = new Refactoring[derivedElement.length];
                    boolean resB = false;
                    int i = 0;
                    while (i < derivedElement.length) {
                        IType type = derivedElement[i];
                        RenameTypeProcessor processor = new RenameTypeProcessor(type);
                        this.delegatingRefactoring[i] = new RenameRefactoring((RenameProcessor)processor);
                        String[] jRecNames2 = null;
                        try {
                            QName newQName = new QName(this.component.getTargetNamespace(), this.getArguments().getNewName());
                            jRecNames2 = this.generator.getDataBindingClassNames(newQName, null);
                            if (jRecNames2 != null && jRecNames2.length > 0) {
                                String sNewName = jRecNames2[0];
                                int idx = sNewName.lastIndexOf(".");
                                if (idx > 0) {
                                    sNewName = sNewName.substring(idx + 1);
                                }
                                if (!this.component.getName().equals(sNewName)) {
                                    processor.setNewElementName(sNewName);
                                    processor.setUpdateReferences(this.getArguments().getUpdateReferences());
                                    resB = true;
                                    IFile xsdFF = J2CEmdUtils.getIFileFromWorkspaceRelativePath(sPlatU);
                                    this.files = new IFile[1];
                                    this.files[0] = xsdFF;
                                }
                            }
                        }
                        catch (Exception exception) {
                            return false;
                        }
                        ++i;
                    }
                    return resB;
                }
            }
        }
        return false;
    }

    private IType[] findDerivedJavaTypes(IFile jFile) {
        boolean bExists;
        ArrayList derivedJavaTypes = new ArrayList();
        if (jFile != null && (bExists = jFile.exists())) {
            ICompilationUnit icu = JavaCore.createCompilationUnitFrom((IFile)jFile);
            try {
                return icu.getTypes();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return derivedJavaTypes.toArray(new IType[derivedJavaTypes.size()]);
    }

    public String getName() {
        return J2CEMDUIMessages.REFACTORING_NAME;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        pm.beginTask("", 11);
        RefactoringStatus result = new RefactoringStatus();
        try {
            int i = 0;
            while (i < this.delegatingRefactoring.length) {
                Refactoring refactoring = this.delegatingRefactoring[i];
                result.merge(refactoring.checkAllConditions((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                ++i;
            }
        }
        catch (CoreException coreException) {
            pm.setCanceled(true);
        }
        if (!result.hasFatalError() && pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<Change> changes = new ArrayList<Change>();
        int i = 0;
        while (i < this.delegatingRefactoring.length) {
            Refactoring refactoring = this.delegatingRefactoring[i];
            Change change = refactoring.createChange(pm);
            if (change != null) {
                changes.add(change);
            }
            ++i;
        }
        if (changes.isEmpty()) {
            return null;
        }
        return new J2CEmdXSDRefactoringChange(this.getName(), changes.toArray(new Change[changes.size()]), this.files, this.genName);
    }
}

