/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.refactor;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public abstract class DelegatingRefactoringParticipant
extends RenameParticipant {
    protected Refactoring[] delegatingRefactoring;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        pm.beginTask("", 11);
        RefactoringStatus result = new RefactoringStatus();
        try {
            int i = 0;
            while (i < this.delegatingRefactoring.length) {
                Refactoring refactoring = this.delegatingRefactoring[i];
                result.merge(refactoring.checkAllConditions((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                ++i;
            }
        }
        catch (CoreException coreException) {
            pm.setCanceled(true);
        }
        if (!result.hasFatalError() && pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<Change> changes = new ArrayList<Change>();
        int i = 0;
        while (i < this.delegatingRefactoring.length) {
            Refactoring refactoring = this.delegatingRefactoring[i];
            Change change = refactoring.createChange(pm);
            if (change != null) {
                changes.add(change);
            }
            ++i;
        }
        if (changes.isEmpty()) {
            return null;
        }
        return new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()]));
    }
}

