/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.action;

import com.ibm.j2c.emd.internal.ui.messages.J2CEMDUIMessages;
import com.ibm.j2c.emd.internal.ui.model.XSDContainementModel;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class RemoveWarningMarkersJob
extends Job {
    private IProject proj;
    private List cMs;

    public RemoveWarningMarkersJob(IProject proj, List cMs) {
        super(J2CEMDUIMessages.REMOVE_WARNINGS_JOB);
        this.proj = proj;
        this.cMs = cMs;
        this.setPriority(50);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.removeMarkersIfNeeded(this.cMs);
        return Status.OK_STATUS;
    }

    private Path getProjectRelativePath(String projectName, String fullPath) {
        Path path = null;
        int indx = fullPath.indexOf(projectName);
        if (indx >= 0) {
            String temp = fullPath.substring(indx + projectName.length(), fullPath.length());
            path = new Path(temp);
        }
        return path;
    }

    private void removeMarkersIfNeeded(List models) {
        int i = 0;
        while (i < models.size()) {
            XSDContainementModel model = (XSDContainementModel)models.get(i);
            this.removeMarkerIfNeeded(model);
            ++i;
        }
    }

    private void removeMarkerIfNeeded(XSDContainementModel model) {
        List lst;
        String sFileName = model.getFileName();
        Path path = this.getProjectRelativePath(this.proj.getName(), sFileName);
        IFile file = this.proj.getFile((IPath)path);
        if (file.exists()) {
            try {
                file.deleteMarkers("com.ibm.j2c.emd.problem", false, 2);
            }
            catch (Exception exception) {}
        }
        if ((lst = model.getChildren()) != null) {
            int i = 0;
            while (i < lst.size()) {
                XSDContainementModel mod = (XSDContainementModel)lst.get(i);
                this.removeMarkerIfNeeded(mod);
                ++i;
            }
        }
    }
}

