/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.action;

import com.ibm.j2c.emd.internal.action.CleanUpPreparationRunnable;
import com.ibm.j2c.emd.internal.action.FileDeletionJob;
import com.ibm.j2c.emd.internal.ui.CleanUpConfirmationDialog;
import com.ibm.j2c.emd.internal.ui.messages.J2CEMDUIMessages;
import com.ibm.j2c.emd.internal.ui.model.BusinessTypeJavaRecordInfo;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ProjectCleanUpAction
implements IObjectActionDelegate {
    private IJavaProject javaProject;
    private Shell shell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (action.isEnabled()) {
            try {
                ProgressMonitorDialog dia = new ProgressMonitorDialog(this.shell);
                CleanUpPreparationRunnable rr = new CleanUpPreparationRunnable(this.javaProject);
                try {
                    dia.run(true, true, (IRunnableWithProgress)rr);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                Hashtable sortedRecords = rr.getObsoleteFilesSortedByPackageName();
                CleanUpConfirmationDialog cleanD = new CleanUpConfirmationDialog(this.shell, sortedRecords);
                int iRes = cleanD.open();
                if (iRes == 0) {
                    List lH = rr.getObsoleteBusinessTypeInfos();
                    int i = 0;
                    while (i < lH.size()) {
                        BusinessTypeJavaRecordInfo info = (BusinessTypeJavaRecordInfo)lH.get(i);
                        IFile file = info.getJavaRecord();
                        FileDeletionJob job1 = new FileDeletionJob(J2CEMDUIMessages.DELETING_JOB_MESSAGE, file);
                        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().deleteRule((IResource)file);
                        job1.setRule(rule);
                        job1.schedule();
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object obj = iss.toList().get(0);
            try {
                if (obj instanceof IProject) {
                    action.setEnabled(true);
                    IProject pr = (IProject)obj;
                    this.javaProject = JavaCore.create((IProject)pr);
                    return;
                }
                if (obj instanceof IJavaProject) {
                    action.setEnabled(true);
                    this.javaProject = (IJavaProject)obj;
                    return;
                }
                if (obj instanceof IPackageFragmentRoot) {
                    action.setEnabled(true);
                    IPackageFragmentRoot pfr = (IPackageFragmentRoot)obj;
                    this.javaProject = pfr.getJavaProject();
                    return;
                }
                if (obj instanceof IPackageFragment) {
                    action.setEnabled(true);
                    IPackageFragment pf = (IPackageFragment)obj;
                    this.javaProject = pf.getJavaProject();
                    return;
                }
                if (obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    IProject pr = file.getProject();
                    boolean enabled = pr.hasNature("org.eclipse.jdt.core.javanature");
                    if (enabled) {
                        this.javaProject = JavaCore.create((IProject)pr);
                    }
                    action.setEnabled(enabled);
                    return;
                }
            }
            catch (Exception exception) {}
            action.setEnabled(false);
        }
    }
}

