/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.action;

import com.ibm.adapter.asi.registry.ApplicationSpecificSchemaProperties;
import com.ibm.adapter.asi.registry.ApplicationSpecificSchemaRegistryFactory;
import com.ibm.j2c.emd.internal.ui.messages.J2CEMDUIMessages;
import com.ibm.j2c.emd.internal.utils.EventMappingWriter;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateEventMappingAction
implements IObjectActionDelegate {
    private ICompilationUnit javaFile = null;
    private IJavaProject javaProj = null;
    private Hashtable eventMap = new Hashtable();
    private String packageName = "";
    private String EventMappingXMLloc = null;
    private boolean noeventfound;
    private String xsdLoc_ = null;

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public String getXSDLocation(InputStream is) {
        this.xsdLoc_ = null;
        try {
            int avail = is.available();
            int canRead = is.read();
            int remain = avail;
            while (canRead != -1 && remain > 0) {
                byte[] dataread = new byte[avail];
                is.read(dataread);
                remain = is.available();
                char[] cArr = new char[avail];
                int ii = 0;
                while (ii < dataread.length) {
                    cArr[ii] = (char)dataread[ii];
                    ++ii;
                }
                String sourceString = new String(cArr);
                canRead = is.read();
                int endIndex = -1;
                int beginIndex = sourceString.indexOf("xsdLocation=");
                if (beginIndex != -1) {
                    endIndex = sourceString.indexOf(".xsd", beginIndex);
                }
                if (beginIndex == -1 || endIndex == -1) continue;
                this.xsdLoc_ = sourceString.substring(beginIndex + 12, endIndex + 4);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return this.xsdLoc_;
    }

    public String getMappingOutputDirectory() {
        String eventMappingXMLloc = this.javaFile.getJavaProject().getProject().getLocation().toString();
        String eventMappingXSDLoc = "";
        int xsdPathindex = this.xsdLoc_.lastIndexOf("/");
        String xsdFolder = null;
        StringBuffer tbuf = new StringBuffer(eventMappingXMLloc);
        if (xsdPathindex != -1) {
            xsdFolder = this.xsdLoc_.substring(0, xsdPathindex);
            tbuf = tbuf.append("/");
            tbuf = tbuf.append(xsdFolder);
            tbuf = tbuf.append("/");
        } else {
            tbuf = tbuf.append("/");
        }
        eventMappingXSDLoc = tbuf.toString();
        return eventMappingXSDLoc;
    }

    public void run(IAction action) {
        try {
            if (action.isEnabled()) {
                this.eventMap = new Hashtable();
                this.noeventfound = true;
                IType[] itypes = this.javaFile.getAllTypes();
                if (itypes != null) {
                    int i = 0;
                    while (i < itypes.length) {
                        IMethod[] allMethods = itypes[i].getMethods();
                        if (allMethods != null && allMethods.length > 0) {
                            int m = 0;
                            while (m < allMethods.length) {
                                String eventName = null;
                                IAnnotation anEvent = allMethods[m].getAnnotation("Event");
                                if (anEvent != null && anEvent.exists()) {
                                    int totallength = anEvent.getSourceRange().getLength();
                                    eventName = anEvent.getSource().substring(15, totallength - 2);
                                    this.noeventfound = false;
                                    String[] ptypes = allMethods[m].getParameterTypes();
                                    int l = 0;
                                    while (l < ptypes.length) {
                                        InputStream is;
                                        String xsdLocation;
                                        String fName = ptypes[l].substring(1, ptypes[l].length() - 1);
                                        String fName1 = fName.replace('.', '/');
                                        while (fName1.contains(".")) {
                                            fName1 = fName.replace('.', '/');
                                        }
                                        IFile fdbinding = this.javaProj.getProject().getFile("ejbModule/" + fName1 + ".java");
                                        if (fdbinding != null && fdbinding.exists() && (xsdLocation = this.getXSDLocation(is = fdbinding.getContents())) != null && eventName != null) {
                                            int xsdPathindex = xsdLocation.lastIndexOf("/");
                                            String xsdBOFile = xsdLocation;
                                            if (xsdPathindex != -1) {
                                                xsdBOFile = this.xsdLoc_.substring(xsdPathindex + 1);
                                            }
                                            this.eventMap.put(eventName, xsdBOFile);
                                        }
                                        ++l;
                                    }
                                }
                                ++m;
                            }
                        }
                        ++i;
                    }
                }
                if (!this.eventMap.isEmpty()) {
                    String boXSDLocation;
                    ApplicationSpecificSchemaProperties[] asiProp = ApplicationSpecificSchemaRegistryFactory.getFactory().getApplicationSpecificSchemaRegistry().getAllApplicationSpecificSchemaProperties();
                    if (asiProp == null || asiProp.length == 0) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)J2CEMDUIMessages.info_label, (String)(String.valueOf(J2CEMDUIMessages.NO_EVENTSMAPPINGFILE_GENERATE) + J2CEMDUIMessages.NO_BOMETADATA_FOUND));
                    }
                    String EventMappingXSDLoc = this.EventMappingXMLloc = (boXSDLocation = this.getMappingOutputDirectory());
                    StringBuffer tbuf = new StringBuffer(this.EventMappingXMLloc);
                    tbuf = tbuf.append("EventBOTypeMapping.xml");
                    this.EventMappingXMLloc = tbuf.toString();
                    StringBuffer tbuf2 = new StringBuffer(EventMappingXSDLoc);
                    tbuf2.append("EventBOTypeMapping.xsd");
                    EventMappingXSDLoc = tbuf2.toString();
                    EventMappingWriter eventMapObj = new EventMappingWriter(this.EventMappingXMLloc, this.eventMap, this.javaProj.getProject(), boXSDLocation);
                    eventMapObj.create();
                    EventMappingWriter eventXSDMapObj = new EventMappingWriter(EventMappingXSDLoc, this.eventMap, this.javaProj.getProject(), boXSDLocation);
                    eventXSDMapObj.createXSD(EventMappingXSDLoc);
                }
                if (this.eventMap.isEmpty()) {
                    if (this.noeventfound) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)J2CEMDUIMessages.info_label, (String)(String.valueOf(J2CEMDUIMessages.NO_EVENTSMAPPINGFILE_GENERATE) + J2CEMDUIMessages.NO_EVENTS_FOUND));
                    } else {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)J2CEMDUIMessages.info_label, (String)(String.valueOf(J2CEMDUIMessages.NO_EVENTSMAPPINGFILE_GENERATE) + J2CEMDUIMessages.NO_BO_FOUND));
                    }
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)J2CEMDUIMessages.info_label, (String)(String.valueOf(J2CEMDUIMessages.EVENTS_MAPPING_GENERATED) + "\n" + this.EventMappingXMLloc));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        block8: {
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                IStructuredSelection iss = (IStructuredSelection)selection;
                Object obj = iss.toList().get(0);
                action.setEnabled(false);
                if (obj instanceof ICompilationUnit) {
                    this.javaFile = (ICompilationUnit)obj;
                    this.javaProj = this.javaFile.getJavaProject();
                    boolean isEJB = ResourceUtils.isEJBProject((IProject)this.javaProj.getProject());
                    if (isEJB) {
                        try {
                            IType[] itypes = this.javaFile.getAllTypes();
                            IPackageDeclaration[] pkg = this.javaFile.getPackageDeclarations();
                            if (pkg == null) break block8;
                            String ppath = pkg[0].getPath().toString();
                            int index = ppath.lastIndexOf("/");
                            if (index != -1) {
                                this.packageName = ppath.substring(0, index);
                            }
                            if (itypes == null) break block8;
                            int i = 0;
                            while (i < itypes.length) {
                                IAnnotation anSB = itypes[i].getAnnotation("Stateless");
                                if (anSB != null && anSB.exists()) {
                                    action.setEnabled(true);
                                    break;
                                }
                                ++i;
                            }
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

