/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.action;

import com.ibm.j2c.emd.internal.ui.messages.J2CEMDUIMessages;
import com.ibm.j2c.emd.internal.ui.model.BusinessTypeJavaRecordInfo;
import com.ibm.j2c.emd.internal.utils.J2CEmdUtils;
import com.ibm.j2c.emd.internal.utils.JavaResourceVisitor;
import com.ibm.j2c.emd.internal.xml.PIHandler;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import commonj.connector.metadata.description.DataBindingGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public class CleanUpPreparationJob
extends Job {
    private IJavaProject javaProject;
    private JavaResourceVisitor visitor;
    private List obsoleteFiles = new ArrayList();
    private PIHandler parser = new PIHandler();
    private Hashtable obsoleteFilesSortedByPackageName = new Hashtable();

    public CleanUpPreparationJob(String name, IJavaProject javaProject) {
        super(name);
        this.javaProject = javaProject;
    }

    public IStatus run(IProgressMonitor monitor) {
        int units = 100;
        int counter = 0;
        monitor.beginTask(J2CEMDUIMessages.RETRIEVING_INFORMATION, units);
        this.visitor = new JavaResourceVisitor();
        try {
            this.javaProject.getProject().accept((IResourceVisitor)this.visitor);
        }
        catch (Exception exception) {}
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Hashtable hash = this.visitor.getAllInfosByXSDFileLocation();
        if (hash.isEmpty()) {
            return Status.OK_STATUS;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Enumeration en = hash.keys();
        while (en.hasMoreElements()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            String key = (String)en.nextElement();
            ArrayList lst = (ArrayList)hash.get(key);
            Path xsdPath = new Path(key);
            IFile xsdFile = this.javaProject.getProject().getFile((IPath)xsdPath);
            if (xsdFile.exists()) {
                URI uri = URI.createFileURI((String)xsdFile.getRawLocation().toString());
                resourceSet.createResource(uri);
                Resource resource = resourceSet.getResource(uri, false);
                XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
                try {
                    xsdResource.load(resourceSet.getLoadOptions());
                    XSDSchema schema = xsdResource.getSchema();
                    Hashtable byTypes = this.sortJavaRecordsByXSDType(lst);
                    EList listOfXSDTypes = schema.getTypeDefinitions();
                    Enumeration byTypesEnum = byTypes.keys();
                    while (byTypesEnum.hasMoreElements()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        String typeName = (String)byTypesEnum.nextElement();
                        ArrayList jRecs = (ArrayList)byTypes.get(typeName);
                        QName qn = this.getQNameFromString(typeName);
                        if (qn == null) continue;
                        boolean typeFound = false;
                        int c = 0;
                        while (c < listOfXSDTypes.size()) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            XSDTypeDefinition tD = (XSDTypeDefinition)listOfXSDTypes.get(c);
                            String sName = tD.getName();
                            String sNS = tD.getTargetNamespace();
                            if (sNS.equalsIgnoreCase(qn.getNamespaceURI()) && sName.equalsIgnoreCase(qn.getLocalPart())) {
                                typeFound = true;
                            }
                            ++c;
                        }
                        if (typeFound) {
                            ClassLoader classLoader;
                            this.parser.parse(xsdFile.getContents());
                            String generatorName = this.parser.getGeneratorName();
                            if (generatorName == null || (classLoader = J2CEmdUtils.getClassLoader(this.javaProject.getProject())) == null) continue;
                            Class<?> cl = null;
                            try {
                                cl = classLoader.loadClass(generatorName);
                            }
                            catch (Exception exception) {}
                            if (cl == null) continue;
                            String[] javaRecordNamesFromGenerator = new String[]{};
                            monitor.worked(counter += 10);
                            DataBindingGenerator recordGenerator = (DataBindingGenerator)cl.newInstance();
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            try {
                                File f = xsdFile.getRawLocation().toFile();
                                javaRecordNamesFromGenerator = recordGenerator.getDataBindingClassNames(qn, f.toURL());
                            }
                            catch (Exception exception) {}
                            monitor.worked(counter);
                            counter += 10;
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            Hashtable<String, String> namesLookUp = new Hashtable<String, String>();
                            if (javaRecordNamesFromGenerator != null) {
                                int z = 0;
                                while (z < javaRecordNamesFromGenerator.length) {
                                    String sNa = javaRecordNamesFromGenerator[z];
                                    namesLookUp.put(sNa, sNa);
                                    ++z;
                                }
                            }
                            IPath[] sourceLocs = ResourceUtils.getAllJavaSourceLocations((IProject)this.javaProject.getProject());
                            int n = 0;
                            while (n < jRecs.size()) {
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                BusinessTypeJavaRecordInfo inf = (BusinessTypeJavaRecordInfo)jRecs.get(n);
                                IPath recordPath = inf.getJavaRecord().getProjectRelativePath();
                                int m = 0;
                                while (m < sourceLocs.length) {
                                    IPath sourceLoc = sourceLocs[m];
                                    int sourcePathCount = sourceLoc.segmentCount();
                                    if (sourcePathCount > 1) {
                                        sourceLoc = sourceLoc.removeFirstSegments(1);
                                        if (sourcePathCount != 0 && recordPath.matchingFirstSegments(sourceLoc) == sourceLoc.segmentCount()) {
                                            recordPath = recordPath.removeFirstSegments(sourceLoc.segmentCount());
                                            break;
                                        }
                                    }
                                    ++m;
                                }
                                recordPath = recordPath.removeFileExtension();
                                String javaFileName = recordPath.lastSegment();
                                recordPath = recordPath.removeLastSegments(1);
                                String packageName = recordPath.toString().replace('/', '.');
                                String qualifiedName = String.valueOf(packageName) + "." + javaFileName;
                                if (namesLookUp.get(qualifiedName) == null) {
                                    inf.setJavaRecordName(javaFileName);
                                    inf.setJavaRecordPackageName(packageName);
                                    this.obsoleteFiles.add(inf);
                                }
                                monitor.worked(counter);
                                counter += 10;
                                ++n;
                            }
                            continue;
                        }
                        this.obsoleteFiles.addAll(jRecs);
                    }
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            this.obsoleteFiles.addAll(lst);
        }
        return Status.OK_STATUS;
    }

    private Hashtable sortJavaRecordsJavaPackageName(List lst) {
        Hashtable<String, ArrayList<BusinessTypeJavaRecordInfo>> res = new Hashtable<String, ArrayList<BusinessTypeJavaRecordInfo>>();
        int g = 0;
        while (g < lst.size()) {
            BusinessTypeJavaRecordInfo info = (BusinessTypeJavaRecordInfo)lst.get(g);
            String qnName = info.getJavaRecordPackageName(this.javaProject.getProject());
            ArrayList<BusinessTypeJavaRecordInfo> ls = (ArrayList<BusinessTypeJavaRecordInfo>)res.get(qnName);
            if (ls == null) {
                ls = new ArrayList<BusinessTypeJavaRecordInfo>();
                ls.add(info);
                res.put(qnName, ls);
            } else {
                ls.add(info);
                res.put(qnName, ls);
            }
            ++g;
        }
        return res;
    }

    private Hashtable sortJavaRecordsByXSDType(List lst) {
        Hashtable<String, ArrayList<BusinessTypeJavaRecordInfo>> res = new Hashtable<String, ArrayList<BusinessTypeJavaRecordInfo>>();
        int g = 0;
        while (g < lst.size()) {
            BusinessTypeJavaRecordInfo info = (BusinessTypeJavaRecordInfo)lst.get(g);
            String qnName = info.getGlobalTypeQN();
            ArrayList<BusinessTypeJavaRecordInfo> ls = (ArrayList<BusinessTypeJavaRecordInfo>)res.get(qnName);
            if (ls == null) {
                ls = new ArrayList<BusinessTypeJavaRecordInfo>();
                ls.add(info);
                res.put(qnName, ls);
            } else {
                ls.add(info);
                res.put(qnName, ls);
            }
            ++g;
        }
        return res;
    }

    private QName getQNameFromString(String st2) {
        String sNS = "";
        String sLocal = st2;
        int i3 = st2.indexOf("{");
        if (i3 >= 0) {
            String st3 = st2.substring(i3 + 1);
            int i4 = st3.indexOf("}");
            sNS = st3.substring(0, i4);
            sLocal = st3.substring(i4 + 1);
            return new QName(sNS, sLocal);
        }
        return null;
    }

    public List getObsoleteBusinessTypeInfos() {
        return this.obsoleteFiles;
    }

    public Hashtable getObsoleteFilesSortedByPackageName() {
        this.obsoleteFilesSortedByPackageName = this.sortJavaRecordsJavaPackageName(this.obsoleteFiles);
        return this.obsoleteFilesSortedByPackageName;
    }
}

