      **********************************************************
      *
      * Module Name        EC03.CCP
      *
      * Descriptive Name   CICS External Call Interface
      *
      * @start_copyright_sample_CTG@
      * Licensed Materials - Property of IBM
      *
      * 5724-I81 5724-J09
      *
      * (c) Copyright IBM Corp. 2007
      *
      * US Government Users Restricted Rights - Use, duplication or
      * disclosure restricted by GSA ADP Schedule Contract with
      * IBM Corp.
      *
      * Status: Version 7 Release 1
      * @end_copyright_sample_CTG@
      * Notes :-
      *
      * This server program demonstrates the use of channels and
      * containers in a CICS program. It queries the length of data
      * in a container and places the length, the current date and
      * the current time into containers InputDataLength, CurrentDate
      * and CurrentTime respectively. A message indicating success or
      * failure is returned in container OutputMessage. If no channel
      * is passed to the program it abends with abend code NOCH.
      *
      * EC03 is a Basic CICS Server Cobol sample program which is used
      * with the frontend sample programs to demonstrate the use of
      * External Call Interface (ECI) with channels and containers.
      *
      * The following code is sample code created by IBM Corporation.
      * This sample code is not part of any standard IBM product and
      * is provided to you solely for the purpose of assisting you in
      * the development of your applications.  The code is provided
      * 'as is', without warranty or condition of any kind.  IBM shall
      * not be liable for any damages arising out of your use of the
      * sample code, even if IBM has been advised of the possibility
      * of such damages.
      *

       IDENTIFICATION DIVISION.
       PROGRAM-ID. EC03.
       
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.

      *  Container names
       01 DATECONTAINER      PIC X(16) VALUE 'CurrentDate'.
       01 TIMECONTAINER      PIC X(16) VALUE 'CurrentTime'.
       01 INPUTCONTAINER     PIC X(16) VALUE 'InputData'.
       01 OUTPUTCONTAINER    PIC X(16) VALUE 'OutputMessage'.
       01 LENGTHCONTAINER    PIC X(16) VALUE 'InputDataLength'.

      *  Data fields used by the program
       01 INPUTLENGTH        PIC S9(8) COMP-5.
       01 CURRENTTIME        PIC S9(15) COMP-3.
       01 CHANNELNAME        PIC X(16) VALUE SPACES.
       01 OUTPUTSTRING       PIC X(72) VALUE SPACES.
       01 DATESTRING         PIC X(16) VALUE SPACES.
       01 TIMESTRING         PIC X(16) VALUE SPACES.
       01 RESPCODE           PIC S9(8) COMP-5.
       01 RESPCODE2          PIC S9(8) COMP-5.

       PROCEDURE DIVISION.
       MAIN-PROCESSING SECTION.

      *  Get name of channel
           EXEC CICS ASSIGN CHANNEL(CHANNELNAME)
                            END-EXEC.

      *  If no channel passed in, terminate with abend code NOCH
           IF CHANNELNAME = SPACES THEN
                EXEC CICS ABEND ABCODE('NOCH') NODUMP
                            END-EXEC
           END-IF.

      *  Read content length of container InputData
           EXEC CICS GET CONTAINER(INPUTCONTAINER)
                            CHANNEL(CHANNELNAME)
                            NODATA FLENGTH(INPUTLENGTH)
                            INTOCCSID(037)
                            RESP(RESPCODE)
                            RESP2(RESPCODE2)
                            END-EXEC.

      *  Check response code
           EVALUATE RESPCODE

      *  Container not passed in
             WHEN DFHRESP(CONTAINERERR)
               STRING INPUTCONTAINER
                            DELIMITED BY SPACE
                      ' container was not passed to the program'
                            DELIMITED BY SIZE
                            INTO OUTPUTSTRING END-STRING

      *  Container is BIT not CHAR
             WHEN DFHRESP(CCSIDERR)
               IF RESPCODE2 = 3
                 STRING 'Container '
                            DELIMITED BY SIZE
                        INPUTCONTAINER
                            DELIMITED BY SPACE
                        ' type is BIT, not CHAR'
                            DELIMITED BY SIZE
                            INTO OUTPUTSTRING END-STRING
               END-IF

      *  Read from container OK
             WHEN DFHRESP(NORMAL)
               STRING 'Read from '
                            DELIMITED BY SIZE
                      INPUTCONTAINER
                            DELIMITED BY SPACE
                      ' container successfully'
                            DELIMITED BY SIZE
                            INTO OUTPUTSTRING END-STRING

               EXEC CICS PUT CONTAINER(LENGTHCONTAINER)
                            FROM(INPUTLENGTH)
                            FLENGTH(LENGTH OF INPUTLENGTH)
                            BIT NOHANDLE END-EXEC

      *  Other response code
             WHEN OTHER
               STRING 'The GET CONTAINER command returned an',
                      ' unexpected response code'
                            DELIMITED BY SIZE
                            INTO OUTPUTSTRING END-STRING

           END-EVALUATE.

      *  Place output string in container OutputData
           EXEC CICS PUT CONTAINER(OUTPUTCONTAINER)
                            FROM(OUTPUTSTRING)
                            FLENGTH(LENGTH OF OUTPUTSTRING)
                            CHAR FROMCCSID(037)
                            END-EXEC.

      *  Get the current time and date
           EXEC CICS ASKTIME ABSTIME(CURRENTTIME)
                            END-EXEC.

      *  Format date and time
           EXEC CICS FORMATTIME ABSTIME(CURRENTTIME)
                            DDMMYYYY(DATESTRING) DATESEP('/')
                            TIME(TIMESTRING) TIMESEP(':')
                            END-EXEC.

      *  Place current date in container CurrentDate
           EXEC CICS PUT CONTAINER(DATECONTAINER)
                            FROM(DATESTRING)
                            FLENGTH(LENGTH OF DATESTRING)
                            CHAR FROMCCSID(037)
                            END-EXEC.

      *  Place current time in container CurrentTime
           EXEC CICS PUT CONTAINER(TIMECONTAINER)
                            FROM(TIMESTRING)
                            FLENGTH(LENGTH OF TIMESTRING)
                            CHAR FROMCCSID(037)
                            END-EXEC.

      *  Finish
           EXEC CICS RETURN END-EXEC.

           EXIT.

