/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.webtools;

import com.ibm.cic.licensing.common.LicenseCheck;
import com.ibm.etools.webtools.nls.ResourceHandler;
import com.ibm.itp.wt.ui.IWebToolingUIConstants;
import com.ibm.iwt.ui.filespreferences.FilesPreferenceUtil;
import com.ibm.iwt.ui.filespreferences.IFilesPreferences;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class WebToolsPlugin
extends AbstractUIPlugin {
    public static final String IBMWEBAS_JAR = "\\jars\\ibmwebas.jar";
    public static final String WEBTLSRN_JAR = "/jars/webtlsrn.jar";
    public static final String WEB_TOOLS_PLUGIN_ID = "com.ibm.etools.webtools";
    private static WebToolsPlugin fWebToolsPlugin;
    static boolean TRACING;
    public static final char[] invalidXMLChars;
    public static final String FILE = "file";
    public static final String JAR = "jar";
    public static final String BUNDLE = "bundle";

    static {
        TRACING = false;
        invalidXMLChars = new char[]{':', ';', '*', '+', '?', '\"', '\'', '<', '>', '|', '%', '!', '\'', '(', ')', '[', ']', '{', '}', '&', '@'};
    }

    public WebToolsPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fWebToolsPlugin = this;
        this.getPreferenceStore();
    }

    public static void displayError(Shell shell, String message) {
        MessageDialog.openError((Shell)shell, (String)ResourceHandler.Error_UI_, (String)message);
    }

    public static WebToolsPlugin getDefault() {
        return fWebToolsPlugin;
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, this.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(this.getDescriptor().getInstallURL(), "icons/" + key + ".gif"));
        }
        catch (MalformedURLException ex) {
            WebToolsPlugin.getWebToolsPlugin().write(ex);
        }
        return imageDescriptor;
    }

    public ImageDescriptor getImgWizardBanner() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)WEB_TOOLS_PLUGIN_ID, (String)"icons/full/wizban/newwprj_wiz.gif");
    }

    public static IPath getInstallLocation() {
        URL url = WebToolsPlugin.getInstallURL();
        String protocol = url.getProtocol();
        Path retPath = null;
        if (!(protocol.equals(FILE) || protocol.equals(JAR) || protocol.startsWith(BUNDLE))) {
            String installLocation = url.getFile();
            retPath = new Path(installLocation);
        } else {
            WebToolsPlugin.getWebToolsPlugin().write(NLS.bind((String)ResourceHandler._28concat_ERROR_, (Object)url));
        }
        return retPath;
    }

    public static URL getInstallURL() {
        return WebToolsPlugin.getDefault().getDescriptor().getInstallURL();
    }

    public ILog getMsgLogger() {
        return this.getLog();
    }

    public void write(Throwable t) {
        this.getLog().log((IStatus)new Status(4, WEB_TOOLS_PLUGIN_ID, 0, t.toString(), t));
    }

    public void write(Object o) {
        this.getLog().log((IStatus)new Status(4, WEB_TOOLS_PLUGIN_ID, 0, o.toString(), null));
    }

    public boolean getPreferenceAutoModifyLink() {
        return this.getPreferenceStore().getBoolean("com.ibm.etools.webtools.automodify");
    }

    public boolean getPreferenceCheckDocType() {
        return FilesPreferenceUtil.getCheckDocType();
    }

    public String getPreferenceDefaultSuffix() {
        return FilesPreferenceUtil.getDefaultSuffix();
    }

    public String getPreferenceEndOfLineCode() {
        return FilesPreferenceUtil.getEndOfLineCode();
    }

    public boolean getPreferenceGeneratorContentType() {
        return FilesPreferenceUtil.getGeneratorContentType();
    }

    public boolean getPreferenceGeneratorOut() {
        return FilesPreferenceUtil.getGeneratorOut();
    }

    public String getPreferenceInputCodeset() {
        return FilesPreferenceUtil.getInputCodeset();
    }

    public String getPreferenceOutputCodeset() {
        return FilesPreferenceUtil.getOutputCodeset();
    }

    public String getPreferencePublicID() {
        return FilesPreferenceUtil.getPublicID();
    }

    public String getPreferencePublicIDFrame() {
        return FilesPreferenceUtil.getPublicIDFrame();
    }

    public String getPreferenceSystemID() {
        return FilesPreferenceUtil.getSystemID();
    }

    public String getPreferenceSystemIDFrame() {
        return FilesPreferenceUtil.getSystemIDFrame();
    }

    public static WebToolsPlugin getWebToolsPlugin() {
        return fWebToolsPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void initializeDefaultPreferences(IPreferenceStore preferenceStore) {
        FilesPreferenceUtil.initializeDefaults();
    }

    private IStatus newStatus(int severity, int code, String message) {
        Assert.isTrue((message != null ? 1 : 0) != 0);
        Assert.isTrue((message.trim().length() != 0 ? 1 : 0) != 0);
        return new Status(severity, this.getDescriptor().getUniqueIdentifier(), code, message, null);
    }

    public static void openDialogForException(Throwable exception) {
        Object status = null;
        WebToolsPlugin plugin = WebToolsPlugin.getWebToolsPlugin();
        status = exception instanceof CoreException ? ((CoreException)exception).getStatus() : new Status(4, plugin.getDescriptor().getUniqueIdentifier(), -1, NLS.bind((String)ResourceHandler._27concat_ERROR_, (Object)exception), exception);
        Shell shell = plugin.getWorkbench().getActiveWorkbenchWindow().getShell();
        ErrorDialog.openError((Shell)shell, (String)ResourceHandler.Web_Tooling_Error_UI_, (String)ResourceHandler.An_error_has_occurred_ERROR_, (IStatus)status);
    }

    public void setFilesInterface(IFilesPreferences files) {
        FilesPreferenceUtil.fFiles = files;
    }

    public void setPreferenceCheckDocType(boolean bSet) {
        FilesPreferenceUtil.setCheckDocType(bSet);
    }

    public void setPreferenceDefaultSuffix(String str) {
        FilesPreferenceUtil.setDefaultSuffix(str);
    }

    public void setPreferenceEndOfLineCode(String str) {
        FilesPreferenceUtil.setEndOfLineCode(str);
    }

    public void setPreferenceGeneratorContentType(boolean bSet) {
        FilesPreferenceUtil.setGeneratorContentType(bSet);
    }

    public void setPreferenceGeneratorOut(boolean bSet) {
        FilesPreferenceUtil.setGeneratorOut(bSet);
    }

    public void setPreferenceInputCodeset(String str) {
        FilesPreferenceUtil.setInputCodeset(str);
    }

    public void setPreferenceOutputCodeset(String str) {
        FilesPreferenceUtil.setOutputCodeset(str);
    }

    public void setPreferencePublicID(String str) {
        FilesPreferenceUtil.setPublicID(str);
    }

    public void setPreferencePublicIDFrame(String str) {
        FilesPreferenceUtil.setPublicIDFrame(str);
    }

    public void setPreferenceSystemID(String str) {
        FilesPreferenceUtil.setSystemID(str);
    }

    public void setPreferenceSystemIDFrame(String str) {
        FilesPreferenceUtil.setSystemIDFrame(str);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LicenseCheck.requestLicense((Plugin)this, (String)"com.ibm.etools.webtools.core.feature", (String)"7.0.0");
    }

    public IStatus validateXML(String segment, boolean checkEmpty) {
        if (checkEmpty & segment.length() == 0) {
            return this.newStatus(4, 77, IWebToolingUIConstants.EMPTY_VALUE_ERROR);
        }
        int i = 0;
        while (i < segment.length()) {
            if (Character.isWhitespace(segment.charAt(i))) {
                return this.newStatus(4, 77, IWebToolingUIConstants.INVALID_WHITESPACE_ERROR);
            }
            ++i;
        }
        if (segment.endsWith(".")) {
            return this.newStatus(4, 77, String.valueOf(IWebToolingUIConstants.INVALID_DOT_ERROR) + segment);
        }
        i = 0;
        while (i < invalidXMLChars.length) {
            if (segment.indexOf(invalidXMLChars[i]) != -1) {
                return this.newStatus(4, 77, String.valueOf(IWebToolingUIConstants.INVALID_CHARACTER_ERROR) + String.valueOf(invalidXMLChars[i]));
            }
            ++i;
        }
        return this.newStatus(0, 0, IWebToolingUIConstants.OK_STATUS);
    }

    public String getJ2EEVersionPreference() {
        return this.getPreferenceStore().getString("org.eclipse.jst.j2ee.internal.internal.ui.preference.j2eeVersion");
    }
}

