/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.webtools;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.iwt.webtools.IURI;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.Assert;

public class URI
implements IURI,
Cloneable {
    protected String scheme = "";
    protected String host = "";
    protected int port = -1;
    protected IPath pathPrefix = new Path("");
    protected IPath path = new Path("");
    protected String query = "";
    protected String fragment = "";
    private static String[] PROTOCOLS = new String[]{"ftp", "http", "gopher", "mailto", "news", "nntp", "telnet", "wais", "file", "prospero", "z39.50s", "z39.50r", "cid", "mid", "vemmi", "service", "imap", "nfs", "acap", "rtsp", "tip", "pop", "data", "dav", "opaquelocktoken", "sip", "tel", "fax", "modem", "ldap", "afs", "tn3270", "mailserver", "javascript", "https", "soap.beep", "soap.beeps", "urn", "clsid"};

    public URI(String spec) {
        try {
            URL url = new URL(spec);
            this.initializeFromURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            this.initializePath(spec);
        }
    }

    public URI(String scheme, String host, int port, String path) {
        this(scheme, host, port, (IPath)new Path(""), (IPath)new Path(path), "", "");
    }

    public URI(String scheme, String host, int port, IPath path) {
        this(scheme, host, port, (IPath)new Path(""), path, "", "");
    }

    public URI(String scheme, String host, int port, IPath prefix, IPath path, String query, String fragment) {
        Assert.isLegal((scheme != null && host != null && prefix != null && path != null && query != null && fragment != null ? 1 : 0) != 0);
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.pathPrefix = prefix;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    public URI(String scheme, String host, IPath path) {
        this(scheme, host, -1, (IPath)new Path(""), path, "", "");
    }

    public URI(URL url) {
        this.initializeFromURL(url);
    }

    @Override
    public IURI addTrailingSeparator() {
        if (this.hasTrailingSeparator()) {
            return this;
        }
        return new URI(this.scheme, this.host, this.port, this.pathPrefix, this.path.addTrailingSeparator(), this.query, this.fragment);
    }

    @Override
    public IURI appendPath(String tail) {
        return new URI(this.scheme, this.host, this.port, this.pathPrefix, this.path.append(tail), this.query, this.fragment);
    }

    @Override
    public IURI appendPath(IPath tail) {
        return new URI(this.scheme, this.host, this.port, this.pathPrefix, this.path.append(tail), this.query, this.fragment);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public IURI copyUptoPathSegment(int count) {
        return new URI(this.scheme, this.host, this.port, this.pathPrefix, this.path.uptoSegment(count), this.query, this.fragment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.toString().equals(((IURI)obj).toString());
    }

    @Override
    public IURI getBasicURI() {
        return new URI(this.scheme, this.host, this.port, this.path);
    }

    @Override
    public String getFileExtension() {
        return this.path.getFileExtension();
    }

    @Override
    public String getFragment() {
        return this.fragment;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public static String getOnlyScheme(String passedSpec) {
        if (passedSpec == null) {
            return "";
        }
        String spec = passedSpec.trim();
        if (spec.length() == 0) {
            return "";
        }
        int limit = spec.length();
        String newProtocol = null;
        int index = 0;
        while (index < limit) {
            char p = spec.charAt(index);
            if (p == '/') break;
            if (p == ':') {
                newProtocol = spec.substring(0, index);
                break;
            }
            ++index;
        }
        if (newProtocol != null) {
            int i = 0;
            while (i < PROTOCOLS.length) {
                if (newProtocol.compareToIgnoreCase(PROTOCOLS[i]) == 0) {
                    return newProtocol;
                }
                ++i;
            }
        }
        return "";
    }

    @Override
    public IURI getParentURI() {
        return new URI(this.scheme, this.host, this.port, this.pathPrefix, this.path.removeLastSegments(1), this.query, this.fragment);
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public IPath getPathPrefix() {
        return this.pathPrefix;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean hasTrailingSeparator() {
        return this.path.hasTrailingSeparator();
    }

    private void initializeFromURL(URL url) {
        this.scheme = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        String s = url.getRef() == null ? "" : "#" + url.getRef();
        this.initializePath(String.valueOf(url.getFile()) + s);
    }

    private void initializePath(String s) {
        String str;
        this.pathPrefix = new Path("");
        if (s.length() == 0) {
            this.path = Path.ROOT;
            this.fragment = "";
            this.query = "";
            return;
        }
        this.path = new Path(s);
        this.query = null;
        this.fragment = null;
        StringTokenizer parser = new StringTokenizer(s, "?");
        int tokenCount = parser.countTokens();
        if (tokenCount == 2) {
            this.path = new Path((String)parser.nextElement());
            this.query = (String)parser.nextElement();
        }
        if ((tokenCount = (parser = new StringTokenizer(str = this.query == null ? this.path.toString() : this.query, "#")).countTokens()) == 2) {
            if (this.query == null) {
                this.path = new Path((String)parser.nextElement());
            } else {
                this.query = (String)parser.nextElement();
            }
            this.fragment = (String)parser.nextElement();
        }
        this.fragment = this.fragment == null ? "" : this.fragment;
        this.query = this.query == null ? "" : this.query;
    }

    @Override
    public boolean isAbsolute() {
        return this.scheme.length() > 0;
    }

    @Override
    public boolean isPrefixOf(IURI identifier) {
        if (!this.scheme.equals(identifier.getScheme())) {
            return false;
        }
        if (!this.host.equals(identifier.getHost())) {
            return false;
        }
        if (this.port != identifier.getPort()) {
            return false;
        }
        return identifier.toString().startsWith(this.toString());
    }

    @Override
    public String lastPathSegment() {
        return this.path.lastSegment();
    }

    @Override
    public IURI makeAbsolute(IURI baseURI) {
        URI answer = null;
        try {
            answer = new URI(new URL(baseURI.toURL(), this.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return answer;
    }

    @Override
    public String pathSegment(int index) {
        return this.path.segment(index);
    }

    @Override
    public String[] pathSegments() {
        return this.path.segments();
    }

    @Override
    public IURI removeFirstPathSegments(int count) {
        return new URI(this.scheme, this.host, this.port, this.pathPrefix, this.path.removeFirstSegments(count), this.query, this.fragment);
    }

    @Override
    public IURI removeLastPathSegments(int count) {
        return new URI(this.scheme, this.host, this.port, this.pathPrefix, this.path.removeLastSegments(count), this.query, this.fragment);
    }

    @Override
    public IURI removeTrailingSeparator() {
        if (!this.hasTrailingSeparator()) {
            return this;
        }
        return new URI(this.scheme, this.host, this.port, this.pathPrefix, this.path.removeTrailingSeparator(), this.query, this.fragment);
    }

    @Override
    public IURI resolve(String reference) {
        try {
            return new URI(new URL(this.toURL(), reference));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void setFragment(String value) {
        this.fragment = value;
    }

    @Override
    public void setHost(String value) {
        this.host = value;
    }

    @Override
    public void setPath(String value) {
        this.setPath((IPath)new Path(value));
    }

    @Override
    public void setPath(IPath value) {
        Assert.isNotNull((Object)value);
        this.path = value;
    }

    @Override
    public void setPathPrefix(String prefix) {
        this.setPathPrefix((IPath)new Path(prefix));
    }

    @Override
    public void setPathPrefix(IPath prefix) {
        Assert.isNotNull((Object)prefix);
        this.pathPrefix = prefix;
    }

    @Override
    public void setPort(int value) {
        this.port = value;
    }

    @Override
    public void setQuery(String value) {
        this.query = value;
    }

    @Override
    public void setScheme(String value) {
        this.scheme = value;
    }

    @Override
    public String toString() {
        String result = "";
        String fullPath = this.pathPrefix.append(this.path).toString();
        if (this.scheme.length() > 0) {
            result = String.valueOf(this.scheme) + ":";
        }
        if (this.host.length() > 0) {
            result = String.valueOf(result) + '/' + '/' + this.host;
            if (this.port != -1) {
                result = String.valueOf(result) + ":" + this.port;
            }
            if (fullPath.length() == 0 || fullPath.charAt(0) != '/') {
                result = String.valueOf(result) + '/';
            }
        }
        return String.valueOf(result) + this.urlPath();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return new URL(this.scheme, this.host, this.port, this.urlPath());
    }

    private String urlPath() {
        String result = "";
        String filePath = this.pathPrefix.append(this.path).toString();
        result = String.valueOf(result) + filePath;
        if (this.query.length() > 0) {
            result = String.valueOf(result) + "?" + this.query;
        }
        if (this.fragment.length() > 0) {
            result = String.valueOf(result) + "#" + this.fragment;
        }
        return result;
    }
}

