/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.webtools;

import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class LinksBuilderBackwardsMigrationOperation
extends AbstractDataModelOperation {
    public static final String LINKS_BUILDER_ID = "com.ibm.etools.links.management.linksbuilder";

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = OK_STATUS;
        if (MigrationPlugin.getDefault().getPluginPreferences().getBoolean("backward_compatible")) {
            String projName = (String)this.model.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            if (proj != null) {
                try {
                    this.replaceExistingStaleLinksBuilder(proj, monitor);
                }
                catch (Exception e) {
                    status = new Status(4, LINKS_BUILDER_ID, 4, "LinksBuilderBackwardsMigrationOperation failed", (Throwable)e);
                }
            }
        }
        return status;
    }

    public static boolean addToBuildSpecBefore(String builderID, String successorID, IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            boolean successorFound = false;
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            int j = 0;
            int index = 0;
            while (j < commands.length) {
                if (successorID != null && commands[j].getBuilderName().equals(successorID)) {
                    successorFound = true;
                    newCommands[index++] = command;
                }
                newCommands[index] = commands[j];
                ++j;
                ++index;
            }
            if (!successorFound) {
                newCommands[newCommands.length - 1] = command;
            }
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        return !found;
    }

    private void replaceExistingStaleLinksBuilder(IProject p, IProgressMonitor monitor) {
        try {
            int newIdIndex = -1;
            int oldIdIndex = -1;
            if (p.exists() && p.isOpen()) {
                IProjectDescription description = p.getDescription();
                ICommand[] commands = description.getBuildSpec();
                boolean found = false;
                int index = 0;
                int j = 0;
                while (j < commands.length) {
                    ICommand c = commands[j];
                    String name = c.getBuilderName();
                    if (name.equals("com.ibm.etools.webtools.webappbuilder") || name.equals("com.ibm.etools.links.management.webappbuilder2") || name.equals("com.ibm.etools.webtools.additions.linksbuilder")) {
                        oldIdIndex = j;
                    } else if (name.equals(LINKS_BUILDER_ID)) {
                        newIdIndex = j;
                    } else if (name.equals("org.eclipse.wst.validation.validationbuilder")) {
                        index = j;
                        found = true;
                    }
                    ++j;
                }
                if (oldIdIndex > -1 && newIdIndex > -1) {
                    ICommand[] newCommands = new ICommand[commands.length - 1];
                    if (oldIdIndex == 0) {
                        System.arraycopy(commands, 1, newCommands, 0, commands.length - 1);
                    } else if (oldIdIndex == commands.length - 1) {
                        System.arraycopy(commands, 0, newCommands, 0, commands.length - 1);
                    } else {
                        System.arraycopy(commands, 0, newCommands, 0, oldIdIndex);
                        System.arraycopy(commands, oldIdIndex + 1, newCommands, oldIdIndex, commands.length - oldIdIndex - 1);
                    }
                    description.setBuildSpec(newCommands);
                    p.setDescription(description, null);
                } else if (oldIdIndex > -1) {
                    ICommand command = description.newCommand();
                    command.setBuilderName(LINKS_BUILDER_ID);
                    commands[oldIdIndex] = command;
                    description.setBuildSpec(commands);
                    p.setDescription(description, null);
                } else if (newIdIndex == -1) {
                    if (!found) {
                        LinksBuilderBackwardsMigrationOperation.addToBuildSpecBefore(LINKS_BUILDER_ID, null, p);
                    } else {
                        ICommand command = description.newCommand();
                        command.setBuilderName(LINKS_BUILDER_ID);
                        ICommand[] newCommands = new ICommand[commands.length + 1];
                        System.arraycopy(commands, 0, newCommands, 0, index);
                        newCommands[index] = command;
                        System.arraycopy(commands, index, newCommands, index + 1, commands.length - index);
                        description.setBuildSpec(newCommands);
                        p.setDescription(description, null);
                    }
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public String getLabel() {
        return "LinksBuilderBackwardsMigrationOperation";
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

