/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.webtools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;

public abstract class AbstractBaseWebProjectURIResolver
extends ProjectResolver
implements org.eclipse.wst.sse.core.internal.util.URIResolver {
    protected IVirtualComponent fComponent = null;
    protected URIResolver webResolver = null;

    public AbstractBaseWebProjectURIResolver(IVirtualComponent component) {
        super(component.getProject());
        this.fComponent = component;
    }

    public String getLocationByURI(String uri) {
        return this.getLocationByURI(uri, this.getFileBaseLocation());
    }

    public String getLocationByURI(String uri, String baseReference) {
        String newUri;
        IPath projectLoc;
        if (uri == null) {
            return null;
        }
        String platformResourcePrefix = "platform:/resource";
        String filePrefix = "file:";
        String valoaderPrefix = "valoader:";
        if (uri.startsWith(platformResourcePrefix) || uri.startsWith(filePrefix) || uri.startsWith(valoaderPrefix)) {
            return super.getLocationByURI(uri, baseReference);
        }
        IProject project = this.fComponent.exists() ? this.fComponent.getProject() : null;
        String docRoot = null;
        if (this.fComponent.exists()) {
            IPath docRootPath = this.fComponent.getRootFolder().getProjectRelativePath();
            IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
            IResource docRootRes = workspaceRoot.findMember(docRootPath);
            if (docRootRes != null) {
                docRoot = docRootRes.getLocation().addTrailingSeparator().toString();
            }
        }
        if (docRoot == null && project != null && (projectLoc = project.getLocation()) != null) {
            docRoot = projectLoc.addTrailingSeparator().toString();
        }
        if (docRoot == null && baseReference != null) {
            Path srcPath = new Path(baseReference);
            docRoot = srcPath.removeLastSegments(1).addTrailingSeparator().toString();
        }
        if ((newUri = this.removeServerContextRoot(uri)) == null) {
            return null;
        }
        return super.getLocationByURI(newUri, baseReference);
    }

    public IContainer getRootLocation() {
        return this.fComponent != null ? this.fComponent.getRootFolder().getUnderlyingFolder() : super.getRootLocation();
    }

    protected String getRootLocationString() {
        if (this.getProject() != null) {
            String rootLocation = this.getProject().getLocation().toString();
            IContainer root = this.getRootLocation();
            if (root != null) {
                rootLocation = root.getLocation().toString();
            }
            return rootLocation;
        }
        return super.getRootLocationString();
    }

    protected String getServerContextRoot() {
        return this.fComponent.getRootFolder().getName();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream bufferInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (is != null) {
            int available = is.available();
            int totalRead = 0;
            byte[] read = new byte[available];
            while (totalRead < available) {
                int numRead = is.read(read, 0, available);
                output.write(read, 0, numRead);
                totalRead += numRead;
            }
        }
        output.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
        if (is == null) return byteArrayInputStream;
        try {
            is.close();
            return byteArrayInputStream;
        }
        catch (IOException iOException) {}
        return byteArrayInputStream;
        catch (IOException iOException) {
            try {
                if (is == null) return null;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                is.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    public URIResolver getWebResolver() {
        if (this.webResolver == null) {
            this.webResolver = URIResolverPlugin.createResolver();
        }
        return this.webResolver;
    }

    private String removeServerContextRoot(String uri) {
        String serverContextRoot;
        if (uri != null && uri.length() > 0 && uri.charAt(0) == '/' && (serverContextRoot = this.getServerContextRoot()) != null && serverContextRoot.length() > 0) {
            Path uriLoc = new Path(uri);
            Path serverContextRootIPath = new Path(serverContextRoot);
            IPath webAppPath = serverContextRootIPath.addTrailingSeparator().makeAbsolute();
            if (webAppPath.isPrefixOf((IPath)uriLoc)) {
                IPath newuriLoc = uriLoc.removeFirstSegments(webAppPath.segmentCount());
                uri = newuriLoc.makeAbsolute().toString();
            } else {
                return null;
            }
        }
        return uri;
    }

    protected IVirtualComponent getComponent() {
        return this.fComponent;
    }

    public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
        return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
    }

    public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
        if (uri == null) {
            return null;
        }
        String platformResourcePrefix = "platform:/resource";
        String filePrefix = "file:";
        String valoaderPrefix = "valoader:";
        if (uri.startsWith(platformResourcePrefix) || uri.startsWith(filePrefix) || uri.startsWith(valoaderPrefix)) {
            return super.getLocationByURI(uri, baseReference);
        }
        IProject project = this.fComponent.exists() ? this.fComponent.getProject() : null;
        String absURL = null;
        if (absURL == null) {
            IPath projectLoc;
            String docRoot = null;
            if (this.fComponent.exists()) {
                IPath docRootPath = this.fComponent.getRootFolder().getWorkspaceRelativePath();
                IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
                IResource docRootRes = workspaceRoot.findMember(docRootPath);
                if (docRootRes != null) {
                    docRoot = docRootRes.getLocation().addTrailingSeparator().toString();
                }
            }
            if (docRoot == null && project != null && (projectLoc = project.getLocation()) != null) {
                docRoot = projectLoc.addTrailingSeparator().toString();
            }
            if (docRoot == null && baseReference != null) {
                Path srcPath = new Path(baseReference);
                docRoot = srcPath.removeLastSegments(1).addTrailingSeparator().toString();
            }
        }
        if (absURL != null && absURL.length() > 0) {
            String l;
            String rawLink = absURL;
            String[] links = new String[3];
            if (links[0] != null && (l = links[0].trim()) != null && l.length() > 0) {
                rawLink = l;
            }
            return rawLink;
        }
        String newUri = this.removeServerContextRoot(uri);
        if (newUri == null) {
            return null;
        }
        return super.getLocationByURI(newUri, baseReference, resolveCrossProjectLinks);
    }
}

