/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.util;

import com.ibm.iwt.util.InvalidURLException;
import com.ibm.iwt.util.ProjectUtil;
import com.ibm.iwt.webtools.URI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileURL {
    private static final String FILEURLSCHEME = "file";
    private static final String URLCOLON = ":";
    private static final String FILEURLPREFIX = "file://";
    private static final String URLSEPARATOR = "/";
    private IPath path = null;
    private String host = null;

    public FileURL(String url) throws InvalidURLException {
        URI uri = new URI(url);
        String scheme = URI.getOnlyScheme(url);
        if (scheme.compareToIgnoreCase(FILEURLSCHEME) != 0) {
            throw new InvalidURLException(url);
        }
        this.host = uri.getHost();
        this.setPath(uri.getPath());
    }

    public FileURL(IPath path) {
        this.setPath(path);
    }

    public static boolean exists(String url) {
        FileURL fileURL = null;
        try {
            fileURL = new FileURL(url);
        }
        catch (InvalidURLException invalidURLException) {
            return false;
        }
        IFile file = FileURL.getIFile(fileURL, null);
        if (file != null) {
            return file.exists();
        }
        File javaFile = fileURL.getJavaIoFile();
        if (javaFile != null) {
            return javaFile.exists();
        }
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public IFile getIFile() {
        return FileURL.getIFile(this, null);
    }

    private static IFile getIFile(FileURL fileURL, IProject project) {
        IProject myproject;
        IProject iProject = myproject = project != null ? project : FileURL.getIProject(fileURL);
        if (myproject != null) {
            int projectseg = myproject.getLocation().segmentCount();
            IPath urlIPath = fileURL.getPath();
            IFile file = myproject.getFile(urlIPath.removeFirstSegments(projectseg));
            return file;
        }
        return null;
    }

    public IFile getIFile(IProject project) {
        return FileURL.getIFile(this, project);
    }

    public InputStream getInputStream() {
        InputStream is = null;
        IFile file = this.getIFile();
        if (file != null) {
            try {
                is = file.getContents();
            }
            catch (CoreException coreException) {}
            return is;
        }
        File jfile = this.getJavaIoFile();
        if (jfile != null) {
            try {
                is = new FileInputStream(jfile);
            }
            catch (FileNotFoundException fileNotFoundException) {}
            return is;
        }
        return null;
    }

    public IProject getIProject() {
        return FileURL.getIProject(this);
    }

    private static IProject getIProject(FileURL fileURL) {
        return ProjectUtil.getProjectForIPath(fileURL.getPath());
    }

    public File getJavaIoFile() {
        return this.path.toFile();
    }

    public long getLastModified() {
        IFile file = this.getIFile();
        if (file != null) {
            return file.getModificationStamp();
        }
        File jfile = this.getJavaIoFile();
        if (jfile != null) {
            return jfile.lastModified();
        }
        return -1L;
    }

    public IPath getPath() {
        return this.path;
    }

    public String getURL() {
        return FileURL.getURL(this.path);
    }

    public static String getURL(IPath path) {
        char second;
        char first;
        if (path.isUNC()) {
            return "file:" + path.toString();
        }
        String device = path.getDevice();
        if (device != null && device.length() == 2 && path.isAbsolute() && Character.isLetter(first = device.charAt(0)) && (second = device.charAt(1)) == ':') {
            return "file:///" + path.toString();
        }
        return FILEURLPREFIX + path.toString();
    }

    public boolean isFolder() {
        IFile file = this.getIFile();
        if (file != null) {
            return file.getType() == 2;
        }
        File jfile = this.getJavaIoFile();
        if (jfile != null) {
            return jfile.isDirectory();
        }
        return false;
    }

    public boolean isUNCFileURL() {
        return this.host != null && this.host.length() != 0;
    }

    private void setPath(IPath ipath) {
        this.path = ipath;
        String device = ipath.getDevice();
        if (device != null && device.length() > 0 && device.charAt(0) == '/') {
            String newDevice = device.substring(1);
            this.path = ipath.setDevice(newDevice);
        }
        if (this.isUNCFileURL() && ipath != null) {
            Path newPath = new Path(this.host);
            newPath = newPath.append(ipath);
            this.path = newPath.makeUNC(true);
        }
    }

    public String toString() {
        if (this.path != null) {
            return this.path.toString();
        }
        return super.toString();
    }
}

