/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractOpenWizardAction
extends Action {
    public static final String WIZARD_TITLE = "AbstractOpenWizardAction.title";
    private IWorkbench fWorkbench;
    private Class[] fActivatedOnTypes;
    private boolean fAcceptEmptySelection;

    protected AbstractOpenWizardAction() {
    }

    public AbstractOpenWizardAction(IWorkbench workbench, String label, Class[] activatedOnTypes, boolean acceptEmptySelection) {
        super(label);
        this.fWorkbench = workbench;
        this.fActivatedOnTypes = activatedOnTypes;
        this.fAcceptEmptySelection = acceptEmptySelection;
    }

    public AbstractOpenWizardAction(IWorkbench workbench, String label, boolean acceptEmptySelection) {
        this(workbench, label, null, acceptEmptySelection);
    }

    public boolean canActionBeAdded() {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.isEmpty()) {
            return this.fAcceptEmptySelection;
        }
        if (this.fActivatedOnTypes != null) {
            if (selection instanceof IStructuredSelection) {
                return this.isEnabled(selection.iterator());
            }
            return false;
        }
        return true;
    }

    protected abstract Wizard createWizard();

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    private boolean isEnabled(Iterator iter) {
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (this.isOfAcceptedType(obj) && this.shouldAcceptElement(obj)) continue;
            return false;
        }
        return true;
    }

    private boolean isOfAcceptedType(Object obj) {
        int i = 0;
        while (i < this.fActivatedOnTypes.length) {
            if (this.fActivatedOnTypes[i].isInstance(obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run() {
        Wizard wizard = this.createWizard();
        if (wizard instanceof IWorkbenchWizard) {
            Object sel = null;
            sel = this.getCurrentSelection() instanceof IStructuredSelection ? this.getCurrentSelection() : new StructuredSelection();
            ((IWorkbenchWizard)wizard).init(PlatformUI.getWorkbench(), sel);
        }
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    protected void setWorkbench(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    protected boolean shouldAcceptElement(Object obj) {
        return true;
    }
}

