/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itp.wt.ui;

import com.ibm.etools.webtools.nls.ResourceHandler;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ToggleableDetailsDialog
extends Dialog {
    private static final int LIST_ITEM_COUNT = 7;
    private Button detailsButton;
    private String title;
    private String message;
    private Text text;
    private boolean textCreated = false;
    private IStatus status;
    private List statusList;

    public ToggleableDetailsDialog(Shell parentShell, String dialogTitle, String message, IStatus status) {
        super(parentShell);
        this.status = status;
        this.setTitleOrDefault(dialogTitle);
        this.setMessageOrDefault(message);
        this.statusList = Arrays.asList(status.getChildren());
        this.setShellStyle(67696);
    }

    protected void setTitleOrDefault(String dialogTitle) {
        if (dialogTitle != null) {
            this.title = dialogTitle;
        } else {
            switch (this.status.getSeverity()) {
                case 4: {
                    this.title = ResourceHandler.ErrorTitle_1;
                    break;
                }
                default: {
                    this.title = ResourceHandler.Success_2;
                }
            }
        }
    }

    protected void setMessageOrDefault(String dialogMessage) {
        if (dialogMessage != null) {
            this.message = dialogMessage;
        } else if (this.status.getMessage() != null) {
            this.message = this.status.getMessage();
        } else {
            switch (this.status.getSeverity()) {
                case 4: {
                    this.message = ResourceHandler.Error_3;
                    break;
                }
                case 2: {
                    this.message = ResourceHandler.Warning_4;
                    break;
                }
                case 1: {
                    this.message = ResourceHandler.Information_5;
                    break;
                }
                default: {
                    this.message = ResourceHandler.Success_6;
                }
            }
        }
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.status.isMultiStatus()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected String getImageKey() {
        switch (this.status.getSeverity()) {
            case 4: {
                return "dialog_error_image";
            }
            case 2: {
                return "dialog_warning_image";
            }
        }
        return "dialog_info_imageg";
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Image image = JFaceResources.getImageRegistry().get(this.getImageKey());
        if (image != null) {
            label = new Label(composite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        if (this.message != null) {
            label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        return composite;
    }

    protected Text createDropDownText(Composite parent) {
        this.text = new Text(parent, 2818);
        this.populateText(this.text);
        GridData data = new GridData(1808);
        data.heightHint = this.text.getLineHeight() * 7;
        this.text.setLayoutData((Object)data);
        this.textCreated = true;
        return this.text;
    }

    public static int openDialog(Shell parentShell, String title, String message, IStatus status) {
        ToggleableDetailsDialog dialog = new ToggleableDetailsDialog(parentShell, title, message, status);
        return dialog.open();
    }

    private void populateText(Text text) {
        Iterator i = this.statusList.iterator();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            IStatus childStatus = (IStatus)i.next();
            this.populateText(sb, childStatus, 0);
        }
        text.setText(sb.toString());
    }

    private void populateText(StringBuffer sb, IStatus status, int nesting) {
        int i = 0;
        while (i < nesting) {
            sb.append("  ");
            ++i;
        }
        switch (status.getSeverity()) {
            case 0: {
                sb.append(ResourceHandler.Ok___7);
                break;
            }
            case 4: {
                sb.append(ResourceHandler.Error___8);
                break;
            }
            case 2: {
                sb.append(ResourceHandler.Warning___9);
                break;
            }
            case 1: {
                sb.append(ResourceHandler.Info___10);
            }
        }
        sb.append(status.getMessage());
        sb.append('\n');
        IStatus[] children = status.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.populateText(sb, children[i2], nesting + 1);
            ++i2;
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.textCreated) {
            this.text.dispose();
            this.textCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.text = this.createDropDownText((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }
}

