/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webproject.features.operation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebSettings {
    static final String ELEMENT_WTPMODULES = "project-modules";
    static final String ELEMENT_PROJECTTYPE = "project-type";
    static final String ELEMENT_CONTEXTROOT = "context-root";
    static final String ELEMENT_WEBCONTENT = "webcontent";
    static final String ELEMENT_JSPLEVEL = "jsp-level";
    static final String ELEMENT_LIBMODULES = "lib-modules";
    static final String ELEMENT_LIBMODULE = "lib-module";
    static final String ELEMENT_LIBMODULE_JAR = "jar";
    static final String ELEMENT_LIBMODULE_PROJECT = "project";
    static final String ELEMENT_FEATURES = "features";
    static final String ELEMENT_FEATURE = "feature";
    static final String ELEMENT_FEATUREID = "feature-id";
    static final String[] EMPTY_FEATURES = new String[0];
    static boolean validWebSettings = true;
    private IProject fProject = null;
    private IFile fSettingsFile = null;
    protected Document fDomDocument;

    public WebSettings(IProject project) {
        this.fProject = project;
    }

    public WebSettings(IProject project, IFile webSettings) {
        this(project);
        if (this.getDOMDocument(webSettings) == null) {
            validWebSettings = false;
        }
    }

    protected IFile getSettingsFile() {
        if (this.fSettingsFile == null) {
            this.fSettingsFile = this.fProject.getFile((IPath)IModuleConstants.WTPMODULE_FILE_PATH);
        }
        return this.fSettingsFile;
    }

    public String getContextRoot() {
        return this.getValue(ELEMENT_CONTEXTROOT);
    }

    public String getJSPLevel() {
        return this.getValue(ELEMENT_JSPLEVEL);
    }

    public String getWebContentName() {
        return this.getValue(ELEMENT_WEBCONTENT);
    }

    public String[] getFeatureIds() {
        Element root = this.getRootElement();
        if (root == null) {
            return EMPTY_FEATURES;
        }
        Element featuresNode = this.findChildNode(root, ELEMENT_FEATURES);
        if (featuresNode == null) {
            return EMPTY_FEATURES;
        }
        NodeList children = featuresNode.getChildNodes();
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String featureId = this.getFeatureId(node);
            if (featureId != null) {
                results.add(featureId);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    protected String getFeatureId(Node node) {
        if (!node.getNodeName().equalsIgnoreCase(ELEMENT_FEATURE)) {
            return null;
        }
        String id = this.getNodeValue((Element)node, ELEMENT_FEATUREID);
        return id;
    }

    public String getProjectType() {
        return this.getValue(ELEMENT_PROJECTTYPE);
    }

    protected String getValue(String settingName) {
        Element root = this.getRootElement();
        if (root == null) {
            return null;
        }
        return this.getNodeValue(root, settingName);
    }

    public void addFeatureId(String newFeature) throws CoreException {
        if (!this.hasFeature(newFeature)) {
            String[] oldFeatures = this.getFeatureIds();
            String[] newFeatures = new String[oldFeatures.length + 1];
            int i = 0;
            while (i < oldFeatures.length) {
                newFeatures[i] = oldFeatures[i];
                ++i;
            }
            newFeatures[oldFeatures.length] = newFeature;
            this.setFeatureIds(newFeatures);
        }
    }

    public void setFeatureIds(String[] featureIds) throws CoreException {
        Document doc = this.getDOMDocument();
        if (doc != null) {
            Node featuresNode = this.findOrCreateChildNode(doc.getDocumentElement(), ELEMENT_FEATURES);
            int i = 0;
            while (i < featureIds.length) {
                String sFeatureId = featureIds[i];
                if (sFeatureId != null) {
                    this.addFeatureId(featuresNode, sFeatureId);
                }
                ++i;
            }
        }
        this.write();
    }

    protected void addFeatureId(Node featuresNode, String featureId) {
        Document doc = this.getDOMDocument();
        Element featureNode = doc.createElement(ELEMENT_FEATURE);
        featuresNode.appendChild(featureNode);
        this.setValue(featureNode, ELEMENT_FEATUREID, featureId);
    }

    public boolean isValidWebSettings() {
        return validWebSettings;
    }

    public void removeFeatureId(String removeId) {
        Element featuresNode;
        Element root = this.getRootElement();
        if (root != null && (featuresNode = this.findChildNode(root, ELEMENT_FEATURES)) != null) {
            NodeList children = featuresNode.getChildNodes();
            ArrayList<String> results = new ArrayList<String>();
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                String featureId = this.getFeatureId(node);
                if (featureId != null && !featureId.equals(removeId)) {
                    results.add(featureId);
                }
                ++i;
            }
            Node firstChild = null;
            while ((firstChild = featuresNode.getFirstChild()) != null) {
                featuresNode.removeChild(firstChild);
            }
            if (results.size() > 0) {
                String[] updateFeatureIds = results.toArray(new String[results.size()]);
                int i2 = 0;
                while (i2 < results.size()) {
                    String sFeatureId = updateFeatureIds[i2];
                    if (sFeatureId != null) {
                        this.addFeatureId(featuresNode, sFeatureId);
                    }
                    ++i2;
                }
            }
        }
    }

    public String getRootNodeName() {
        return ELEMENT_WTPMODULES;
    }

    protected Document getDOMDocument(IFile webSettings) {
        if (this.fDomDocument == null) {
            try {
                this.read(webSettings);
            }
            catch (IOException iOException) {}
        }
        return this.fDomDocument;
    }

    /*
     * Exception decompiling
     */
    protected void read() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void read(IFile settings) throws IOException {
        IFile settingsFile = settings;
        InputStream inputStream = null;
        InputStreamReader fileStream = null;
        if (settingsFile == null) return;
        try {
            try {
                ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    inputStream = settingsFile.getContents();
                    fileStream = new InputStreamReader(inputStream, "utf-8");
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    this.fDomDocument = parser.parse(new InputSource(fileStream));
                    return;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(prevClassLoader);
                }
            }
            catch (SAXException sAXException) {
                if (fileStream == null) return;
                fileStream.close();
                return;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (fileStream == null) return;
                fileStream.close();
                return;
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                if (fileStream == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                fileStream.close();
                return;
            }
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
        }
    }

    public boolean hasFeature(String featureID) {
        boolean hasFeature = false;
        String[] featureIds = this.getFeatureIds();
        int i = 0;
        while (!hasFeature && i < featureIds.length) {
            hasFeature = featureID.equals(featureIds[i]);
            ++i;
        }
        return hasFeature;
    }

    public void write() throws CoreException {
        if (this.fDomDocument == null) {
            return;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(this.fDomDocument.getDocumentElement()), new StreamResult(outStream));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
        }
        catch (TransformerException transformerException) {}
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(outStream.toByteArray());
        IFile settingsFile = this.getSettingsFile();
        if (settingsFile.exists()) {
            settingsFile.setContents((InputStream)sourceStream, true, true, null);
        } else {
            settingsFile.create((InputStream)sourceStream, true, null);
        }
    }

    protected Element getRootElement() {
        Document doc = this.getDOMDocument();
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        if (root == null) {
            return null;
        }
        if (!root.getNodeName().equalsIgnoreCase(this.getRootNodeName())) {
            return null;
        }
        return root;
    }

    protected Document getDOMDocument() {
        if (this.fDomDocument == null) {
            try {
                this.read();
            }
            catch (IOException iOException) {}
        }
        return this.fDomDocument;
    }

    protected Element findChildNode(Element parent, String nodeName) {
        NodeList list = parent.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element curElement;
            Node curNode = list.item(i);
            if (curNode.getNodeType() == 1 && (curElement = (Element)curNode).getNodeName().equalsIgnoreCase(nodeName)) {
                return curElement;
            }
            ++i;
        }
        return null;
    }

    protected void setValue(String nodeName, String value) {
        Document doc = this.getDOMDocument();
        if (doc != null) {
            this.setValue(doc.getDocumentElement(), nodeName, value);
        }
    }

    protected void setValue(Element root, String nodeName, String value) {
        Node node = this.findOrCreateChildNode(root, nodeName);
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() == 0) {
            Text newText = this.getDOMDocument().createTextNode(value);
            node.appendChild(newText);
            root.appendChild(node);
        } else {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node curNode = childNodes.item(i);
                if (curNode.getNodeType() == 3) {
                    curNode.setNodeValue(value);
                }
                ++i;
            }
        }
    }

    protected Node findOrCreateChildNode(Element root, String nodeName) {
        Element node = this.findChildNode(root, nodeName);
        if (node == null) {
            node = this.getDOMDocument().createElement(nodeName);
            root.appendChild(node);
        }
        return node;
    }

    protected String getNodeValue(Element parent, String nodeName) {
        Element node;
        if (parent != null && (node = this.findChildNode(parent, nodeName)) != null) {
            return this.getChildText(node);
        }
        return null;
    }

    protected String getChildText(Element node) {
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node curNode = list.item(i);
            if (curNode.getNodeType() == 3) {
                return curNode.getNodeValue();
            }
            ++i;
        }
        return null;
    }
}

