/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webproject.facets;

import com.ibm.etools.webtools.nls.ResourceHandler;
import com.ibm.iwt.webtools.WebToolsPlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class CVSFacetInstallDelegate
implements IDelegate {
    public static final String CVSIGNORE_FILE_NAME = ".cvsignore";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null) {
                Properties props = component.getMetaProperties();
                if (props.containsKey("java-output-path")) {
                    String outputPathString = props.getProperty("java-output-path");
                    Path outputPath = new Path(outputPathString);
                    IPath filePath = outputPath.removeLastSegments(1);
                    filePath = filePath.append(CVSIGNORE_FILE_NAME);
                    IPath fileName = component.getProject().getFullPath().append(filePath);
                    IFile outputFile = ResourcesPlugin.getWorkspace().getRoot().getFile(fileName);
                    outputFile.refreshLocal(2, null);
                    if (!outputFile.exists()) {
                        String contents = outputPath.lastSegment();
                        ByteArrayInputStream sourceStream = new ByteArrayInputStream(contents.getBytes());
                        outputFile.create((InputStream)sourceStream, true, null);
                    }
                } else {
                    WebToolsPlugin.getDefault().write(NLS.bind((String)ResourceHandler.CVSFacetInstallDelegate_could_not_find_output_path, (Object)component.getName()));
                }
            }
        }
        catch (CoreException e) {
            WebToolsPlugin.getDefault().write(e);
        }
    }
}

