/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webproject.facets;

import com.ibm.etools.webtools.webproject.features.templates.MasterCSSFile;
import com.ibm.iwt.webtools.WebToolsPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategyImpl;
import org.eclipse.wst.css.core.internal.cleanup.CleanupProcessorCSS;

public class CSSFacetInstallDelegate
implements IDelegate {
    public static final String DEFAULT_CSS_FILE_NAME = "Master.css";
    public static final String DEFAULT_CSS_FOLDER_NAME = "theme";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IPath fileName = null;
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null) {
                IVirtualFolder cssFolder = component.getRootFolder().getFolder(DEFAULT_CSS_FOLDER_NAME);
                if (!cssFolder.exists()) {
                    cssFolder.create(0, monitor);
                }
                fileName = cssFolder.getProjectRelativePath().append(DEFAULT_CSS_FILE_NAME);
                IPath projectPath = component.getProject().getFullPath();
                IFile outputFile = ResourcesPlugin.getWorkspace().getRoot().getFile(projectPath.append(fileName));
                outputFile.refreshLocal(2, null);
                if (!outputFile.exists()) {
                    String contents = new MasterCSSFile().generate();
                    ByteArrayInputStream sourceStream = new ByteArrayInputStream(contents.getBytes());
                    outputFile.create((InputStream)sourceStream, true, null);
                    CleanupProcessorCSS processor = new CleanupProcessorCSS();
                    CSSFacetInstallDelegate.setCleanUpFormatStrategy();
                    try {
                        processor.cleanupFile(outputFile);
                    }
                    catch (IOException e) {
                        WebToolsPlugin.getDefault().write(e);
                    }
                }
            }
        }
        catch (CoreException e) {
            WebToolsPlugin.getDefault().write(e);
        }
    }

    protected static void setCleanUpFormatStrategy() {
        CSSCleanupStrategy cleanupStrategy = CSSCleanupStrategyImpl.getInstance();
        Preferences cssPrefs = CSSCorePlugin.getDefault().getPluginPreferences();
        int identCaseInt = cssPrefs.getInt("identifierCase");
        cleanupStrategy.setIdentCase(CSSFacetInstallDelegate.convertCSSCasePref(identCaseInt));
        int propNameCaseInt = cssPrefs.getInt("propNameCase");
        cleanupStrategy.setPropNameCase(CSSFacetInstallDelegate.convertCSSCasePref(propNameCaseInt));
        int propValueCaseInt = cssPrefs.getInt("propValueCase");
        cleanupStrategy.setPropValueCase(CSSFacetInstallDelegate.convertCSSCasePref(propValueCaseInt));
        cleanupStrategy.setSelectorTagCase(CSSFacetInstallDelegate.convertCSSCasePref(identCaseInt));
        cleanupStrategy.setQuoteValues(false);
    }

    private static short convertCSSCasePref(int intPref) {
        short shortPref = 0;
        switch (intPref) {
            case 1: {
                shortPref = 1;
                break;
            }
            case 2: {
                shortPref = 2;
                break;
            }
            default: {
                shortPref = 0;
            }
        }
        return shortPref;
    }
}

