/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.taglib;

import com.ibm.iwt.util.FileURL;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;

public class TaglibRecordWrapper {
    private ITaglibRecord taglib;
    private String prefixOverride = null;

    public TaglibRecordWrapper(ITaglibRecord taglib) {
        this.taglib = taglib;
    }

    public boolean isInJar() {
        int type = this.taglib.getRecordType();
        return type == 2 || type == 4;
    }

    public boolean isWebXMLEntry() {
        int type = this.taglib.getRecordType();
        return type == 1;
    }

    public String getPrefix() {
        String retPrefix = null;
        if (this.prefixOverride != null) {
            retPrefix = this.prefixOverride;
        } else {
            int type = this.taglib.getRecordType();
            switch (type) {
                case 2: {
                    retPrefix = ((IJarRecord)this.taglib).getShortName();
                    break;
                }
                case 1: {
                    retPrefix = ((ITLDRecord)this.taglib).getShortName();
                    break;
                }
                case 4: {
                    retPrefix = ((IURLRecord)this.taglib).getShortName();
                    break;
                }
            }
        }
        return retPrefix;
    }

    public void overrideDefaultPrefix(String newPrefix) {
        if (newPrefix != null && !newPrefix.equals("")) {
            this.prefixOverride = newPrefix;
        }
    }

    public String getURI() {
        int type = this.taglib.getRecordType();
        String uri = "";
        switch (type) {
            case 1: {
                ITLDRecord tldRecord = (ITLDRecord)this.taglib;
                uri = tldRecord.getURI();
                break;
            }
            case 4: {
                IURLRecord urlRecord = (IURLRecord)this.taglib;
                uri = urlRecord.getURI();
                break;
            }
            case 2: {
                IJarRecord jarRecord = (IJarRecord)this.taglib;
                uri = jarRecord.getURI();
                break;
            }
        }
        return uri;
    }

    public IPath getLocation() {
        int type = this.taglib.getRecordType();
        IPath path = null;
        switch (type) {
            case 2: {
                path = ((IJarRecord)this.taglib).getLocation();
                break;
            }
            case 1: {
                path = ((ITLDRecord)this.taglib).getPath();
                break;
            }
            case 4: {
                path = new Path(((IURLRecord)this.taglib).getBaseLocation());
                break;
            }
        }
        return path;
    }

    public InputStream getTLDStream() throws IOException {
        InputStream tldStream = null;
        int type = this.taglib.getRecordType();
        URL url = null;
        switch (type) {
            case 4: {
                url = ((IURLRecord)this.taglib).getURL();
                tldStream = url.openStream();
                break;
            }
            case 1: {
                url = new URL(FileURL.getURL(((ITLDRecord)this.taglib).getPath()));
                tldStream = url.openStream();
                break;
            }
        }
        return tldStream;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaglibRecordWrapper) {
            boolean samePrefix;
            TaglibRecordWrapper that = (TaglibRecordWrapper)obj;
            boolean sameURI = this.getURI() != null && this.getURI().equalsIgnoreCase(that.getURI());
            boolean bl = samePrefix = this.getPrefix() != null && this.getPrefix().equalsIgnoreCase(that.getPrefix());
            return sameURI && samePrefix;
        }
        return super.equals(obj);
    }

    public boolean isURIFromTLD() {
        int type = this.taglib.getRecordType();
        return type != 8;
    }

    public static TaglibRecordWrapper[] wrapper(ITaglibRecord[] taglibs) {
        TaglibRecordWrapper[] wrapperArray = new TaglibRecordWrapper[taglibs.length];
        int i = 0;
        while (i < taglibs.length) {
            wrapperArray[i] = new TaglibRecordWrapper(taglibs[i]);
            ++i;
        }
        return wrapperArray;
    }

    public ITaglibRecord getTaglibRecord() {
        return this.taglib;
    }
}

