/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.taglib;

import com.ibm.iwt.webtools.WebToolsPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TLDDigester {
    private InputStream istream;
    private Document document;
    protected static final String PUBLICID_11 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
    protected static final String PUBLICID_12 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    protected static final String PUBLICID_20 = "http://java.sun.com/xml/ns/j2ee web-jsptaglibrary_2_0.xsd";
    private static ErrorHandler errorHandler;
    private static EntityResolver resolver;

    public TLDDigester(InputStream stream) {
        this.istream = stream;
        this.getDocument();
    }

    public void close() {
        if (this.istream != null) {
            try {
                this.istream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int getJSPLevel() {
        if (this.getDocument() != null) {
            Element docElement = this.getDocument().getDocumentElement();
            if (docElement != null && "2.0".equals(docElement.getAttribute("version")) && PUBLICID_20.equals(docElement.getAttribute("xsi:schemaLocation"))) {
                return 20;
            }
            DocumentType docType = this.getDocument().getDoctype();
            if (docType != null && PUBLICID_12.equals(docType.getPublicId())) {
                return 12;
            }
            if (docType != null && PUBLICID_11.equals(docType.getPublicId())) {
                return 11;
            }
        }
        return 12;
    }

    public String getURI() {
        Node taglibNode = this.getTaglibNode();
        if (taglibNode != null) {
            return this.getTagValue(taglibNode, "uri");
        }
        return null;
    }

    public String getShortName() {
        Node taglibNode = this.getTaglibNode();
        String retVal = null;
        if (taglibNode != null && (retVal = this.getTagValue(taglibNode, "shortname")) == null) {
            retVal = this.getTagValue(taglibNode, "short-name");
        }
        return retVal;
    }

    public String getDescription() {
        Node taglibNode = this.getTaglibNode();
        String retVal = null;
        if (taglibNode != null && (retVal = this.getTagValue(taglibNode, "description")) == null) {
            retVal = this.getTagValue(taglibNode, "info");
        }
        return null;
    }

    protected Document createDocument() {
        Document doc = null;
        InputSource inputSource = new InputSource(this.istream);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setValidating(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.setEntityResolver(TLDDigester.getEntityResolver());
            builder.setErrorHandler(TLDDigester.getNullErrorHandler());
            doc = builder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return doc;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        return this.document;
    }

    protected Node getTaglibNode() {
        Document doc = this.getDocument();
        Node taglibNode = null;
        if (doc != null) {
            taglibNode = this.findChildNode(doc, "taglib");
        }
        return taglibNode;
    }

    protected Node findChildNode(Node parent, String nodeName) {
        NodeList list = parent.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element curElement;
            Node curNode = list.item(i);
            if (curNode.getNodeType() == 1 && (curElement = (Element)curNode).getNodeName().equalsIgnoreCase(nodeName)) {
                return curElement;
            }
            ++i;
        }
        return null;
    }

    protected String getTagValue(Node node, String tagName) {
        Node textNode;
        Node childNode = this.findChildNode(node, tagName);
        if (childNode != null && (textNode = childNode.getFirstChild()) != null && textNode.getNodeType() == 3) {
            return this.removeWhitespace(textNode.getNodeValue());
        }
        return null;
    }

    protected String removeWhitespace(String string) {
        return string.trim().replace(' ', '_');
    }

    private static EntityResolver getEntityResolver() {
        if (resolver == null) {
            resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
                    InputSource result = null;
                    if (result == null) {
                        result = new InputSource(new StringReader(""));
                        result.setPublicId(publicID);
                        result.setSystemId(systemID != null ? systemID : "/_" + this.getClass().getName());
                    }
                    return result;
                }
            };
        }
        return resolver;
    }

    private static ErrorHandler getNullErrorHandler() {
        if (errorHandler == null) {
            errorHandler = new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    WebToolsPlugin.getDefault().write(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    WebToolsPlugin.getDefault().write(exception);
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    WebToolsPlugin.getDefault().write(exception);
                }
            };
        }
        return errorHandler;
    }
}

