/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.server.internal;

import com.ibm.etools.webtools.server.internal.HTMLTaglibDirectiveUtil;
import com.ibm.etools.webtools.server.internal.ITagLibChangeListener;
import com.ibm.etools.webtools.server.internal.ITaglibDirective;
import com.ibm.etools.webtools.server.internal.TaglibUtilityAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class TaglibPrefixUtil
implements ITagLibChangeListener {
    private HashMap tagPrefixToTaglibURIMap = new HashMap();
    private IDOMModel model;

    private TaglibPrefixUtil(IDOMModel model) {
        this.model = model;
        HTMLTaglibDirectiveUtil.addListener(model, this);
        this.buildMapping(model);
    }

    public static TaglibPrefixUtil getMapperUtil(Document d) {
        IDOMDocument doc = (IDOMDocument)d;
        if (d == null) {
            return null;
        }
        TaglibUtilityAdapter adapter = (TaglibUtilityAdapter)doc.getAdapterFor((Object)TaglibUtilityAdapter.ADAPTER_KEY);
        if (adapter == null) {
            return new TaglibPrefixUtil(doc.getModel());
        }
        TaglibPrefixUtil util = adapter.getTaglibPrefixUtil();
        if (util == null) {
            util = new TaglibPrefixUtil(doc.getModel());
            adapter.setTaglibPrefixUtil(util);
        }
        return util;
    }

    public String getUriForPrefix(String prefix) {
        return (String)this.tagPrefixToTaglibURIMap.get(prefix);
    }

    public String getPrefixForUri(String uri) {
        if (!this.tagPrefixToTaglibURIMap.containsValue(uri)) {
            return null;
        }
        Set entrySet = this.tagPrefixToTaglibURIMap.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!((String)entry.getValue()).equals(uri)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private void buildMapping(IDOMModel m) {
        this.tagPrefixToTaglibURIMap.clear();
        Object[] taglibs = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx(m);
        int i = 0;
        while (i < taglibs.length) {
            ITaglibDirective taglib = (ITaglibDirective)taglibs[i];
            this.tagPrefixToTaglibURIMap.put(taglib.getPrefix(), taglib.getURI());
            ++i;
        }
    }

    public Iterator getTaglibUris() {
        return this.tagPrefixToTaglibURIMap.values().iterator();
    }

    @Override
    public void taglibDirectiveChanged() {
        if (this.model != null) {
            this.buildMapping(this.model);
        }
    }

    public void addMapping(String prefix, String uri) {
        this.tagPrefixToTaglibURIMap.put(prefix, uri);
    }
}

