/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.server.internal;

import java.util.ArrayList;
import java.util.HashMap;

public class LRUCache {
    private ArrayList elementList = new ArrayList();
    private HashMap cacheMap = new HashMap();
    private int maxElements;

    public LRUCache(int maxElements) {
        this.maxElements = maxElements;
    }

    public void put(Object key, Object value) {
        if (this.cacheMap.get(key) != null) {
            this.touch(key);
            this.cacheMap.put(key, value);
        } else {
            if (!this.checkSpace()) {
                this.removeCacheEntry(this.elementList.get(this.elementList.size() - 1));
            }
            this.addCacheEntry(key, value);
        }
    }

    public Object get(Object key) {
        Object value = this.cacheMap.get(key);
        this.touch(key);
        return value;
    }

    public void remove(Object key) {
        this.removeCacheEntry(key);
    }

    protected void addCacheEntry(Object key, Object value) {
        if (!this.elementList.contains(key)) {
            this.elementList.add(0, key);
            this.cacheMap.put(key, value);
        }
    }

    protected void removeCacheEntry(Object key) {
        this.elementList.remove(key);
        this.cacheMap.remove(key);
    }

    public boolean containsKey(Object key) {
        return this.cacheMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touch(Object key) {
        if (!this.elementList.contains(key)) {
            return;
        }
        ArrayList arrayList = this.elementList;
        synchronized (arrayList) {
            int index = -1;
            int i = 0;
            while (i < this.elementList.size()) {
                if (key.equals(this.elementList.get(i))) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index > -1) {
                this.elementList.add(0, this.elementList.get(index));
                this.elementList.remove(index + 1);
            }
        }
    }

    private boolean checkSpace() {
        return this.elementList.size() <= this.maxElements - 1;
    }

    public void clear() {
        this.elementList.clear();
        this.cacheMap.clear();
    }

    public int size() {
        return this.cacheMap.size();
    }
}

