/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.server.internal;

import com.ibm.etools.webtools.server.internal.LRUCache;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class JsfPageUtil {
    private static final LRUCache isJsfPageCache = new LRUCache(10);

    private JsfPageUtil() {
    }

    public static synchronized List findJsfNodes(Document d) {
        ArrayList<Node> resultnodes = new ArrayList<Node>();
        if (d == null) {
            return resultnodes;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(d);
        while (!nodes.isEmpty()) {
            String nodeName;
            Node idAttr;
            Node currentNode = (Node)nodes.remove(0);
            Node child = currentNode.getFirstChild();
            while (child != null) {
                nodes.add(child);
                child = child.getNextSibling();
            }
            NamedNodeMap attrs = currentNode.getAttributes();
            if (attrs == null || (idAttr = attrs.getNamedItem("id")) == null || (nodeName = currentNode.getNodeName()).equalsIgnoreCase("jsp:useBean") || nodeName.endsWith("useDataObject") || nodeName.endsWith("useDataList")) continue;
            resultnodes.add(currentNode);
        }
        return resultnodes;
    }

    public static boolean isJsfPage(Document d) {
        Integer hashCode = new Integer(d.hashCode());
        if (isJsfPageCache.containsKey(hashCode)) {
            return (Boolean)isJsfPageCache.get(hashCode);
        }
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            if ("jsp:directive.taglib".equalsIgnoreCase(node.getNodeName()) && "http://java.sun.com/jsf/core".equals(((Element)node).getAttribute("uri"))) {
                isJsfPageCache.put(hashCode, Boolean.TRUE);
                return true;
            }
            if ("jsp:root".equalsIgnoreCase(node.getNodeName())) {
                NamedNodeMap attrs = ((Element)node).getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    if ("http://java.sun.com/jsf/core".equals(attrs.item(i).getNodeValue())) {
                        isJsfPageCache.put(hashCode, Boolean.TRUE);
                        return true;
                    }
                    ++i;
                }
            }
            if ("BODY".equalsIgnoreCase(node.getNodeName())) break;
            node = iter.nextNode();
        }
        isJsfPageCache.put(hashCode, Boolean.FALSE);
        return false;
    }

    public static void setJsfPage(Document d, boolean isJsfPage) {
        Integer hashCode = new Integer(d.hashCode());
        isJsfPageCache.put(hashCode, new Boolean(isJsfPage));
    }

    public static void removeFromIsJsfPageCache(Document d) {
        Integer hashCode = new Integer(d.hashCode());
        isJsfPageCache.remove(hashCode);
    }

    public static Node getFirstNodeInstance(Document d, String nodeName) {
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            if (nodeName.equalsIgnoreCase(node.getNodeName())) {
                return node;
            }
            node = iter.nextNode();
        }
        return null;
    }
}

