/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.server.internal;

import com.ibm.etools.webtools.server.internal.HTMLModelChangeAdapter;
import com.ibm.etools.webtools.server.internal.ITagLibChangeListener;
import com.ibm.etools.webtools.server.internal.NodeDataAccessor;
import com.ibm.etools.webtools.server.internal.TaglibDirective;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLTaglibDirectiveUtil {
    private static final String NODENAME_JSPROOT = "jsp:root";
    private static final String NODENAME_TAGLIB = "jsp:directive.taglib";
    private static final String ATTRNAME_PREFIX = "prefix";
    private static final String ATTRNAME_URI = "uri";
    private static final String[] reservedPrefix = new String[]{"jsp", "jspx", "java", "javax", "servlet", "sun", "sunw"};
    private static final String XMLNS = "xmlns:";

    public static void addListener(IDOMModel model, ITagLibChangeListener listner) {
        if (model == null) {
            return;
        }
        HTMLModelChangeAdapter adapter = (HTMLModelChangeAdapter)model.getDocument().getAdapterFor(HTMLModelChangeAdapter.class);
        if (adapter == null) {
            return;
        }
        adapter.addListener(listner);
    }

    public static NodeList getTaglibDirectives(IDOMModel model) {
        if (model == null) {
            return null;
        }
        NodeList nl = model.getDocument().getElementsByTagName(NODENAME_TAGLIB);
        return nl;
    }

    public static void removeListener(IDOMModel model, ITagLibChangeListener listener) {
        if (model == null || listener == null) {
            return;
        }
        HTMLModelChangeAdapter adapter = (HTMLModelChangeAdapter)model.getDocument().getAdapterFor(HTMLModelChangeAdapter.class);
        if (adapter == null) {
            return;
        }
        adapter.removeListener(listener);
    }

    public static Object[] getTaglibDirectivesEx(IDOMModel model) {
        if (model == null) {
            return new Object[0];
        }
        if (HTMLTaglibDirectiveUtil.isJSPDocuments(model)) {
            Vector v = HTMLTaglibDirectiveUtil.getTaglibDirectiveXML(model);
            Vector<Object> w = new Vector<Object>();
            for (Node node : v) {
                Object o = HTMLTaglibDirectiveUtil.getTaglibDirective(node);
                if (o == null) continue;
                w.add(o);
            }
            Object[] p = new Object[w.size()];
            Iterator i = w.iterator();
            int j = 0;
            while (i.hasNext()) {
                p[j] = i.next();
                ++j;
            }
            return p;
        }
        Vector<Object> w = new Vector<Object>();
        NodeList nl = HTMLTaglibDirectiveUtil.getTaglibDirectives(model);
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            Object o = HTMLTaglibDirectiveUtil.getTaglibDirective(node);
            if (o != null) {
                w.add(o);
            }
            ++i;
        }
        Object[] p = new Object[w.size()];
        Iterator i2 = w.iterator();
        int j = 0;
        while (i2.hasNext()) {
            p[j] = i2.next();
            ++j;
        }
        return p;
    }

    public static Object getTaglibDirective(Node node) {
        TaglibDirective td = null;
        if (node.getNodeType() == 2) {
            String nodeName = node.getNodeName();
            String prefix = HTMLTaglibDirectiveUtil.getTaglibPrefix(nodeName);
            if (prefix != null) {
                String uri = NodeDataAccessor.getAttribute((Attr)node);
                td = new TaglibDirective(prefix, uri);
            }
        } else if (node.getNodeName().equals(NODENAME_TAGLIB)) {
            String prefix = NodeDataAccessor.getAttribute((Element)node, ATTRNAME_PREFIX);
            String uri = NodeDataAccessor.getAttribute((Element)node, ATTRNAME_URI);
            td = new TaglibDirective(prefix, uri);
        }
        return td;
    }

    public static boolean isJSPDocuments(IDOMModel model) {
        return HTMLTaglibDirectiveUtil.getJSPRootElement(model) != null;
    }

    public static Element getJSPRootElement(IDOMModel model) {
        if (model == null) {
            return null;
        }
        Element element = model.getDocument().getDocumentElement();
        if (element == null) {
            return null;
        }
        return HTMLTaglibDirectiveUtil.isJSPRootElement(element) ? element : null;
    }

    private static Vector getTaglibDirectiveXML(IDOMModel model) {
        if (model == null) {
            return null;
        }
        Vector<Node> v = new Vector<Node>();
        Element e = model.getDocument().getDocumentElement();
        NamedNodeMap map = e.getAttributes();
        if (map != null) {
            int i = 0;
            while (i < map.getLength()) {
                Node attr = map.item(i);
                if (attr != null && attr.getNodeType() == 2 && HTMLTaglibDirectiveUtil.getTaglibPrefix(attr.getNodeName()) != null) {
                    v.add(attr);
                }
                ++i;
            }
        }
        return v;
    }

    private static String getTaglibPrefix(String attrName) {
        String prefix = null;
        if (!attrName.startsWith(XMLNS)) {
            return null;
        }
        prefix = attrName.substring(XMLNS.length());
        int i = 0;
        while (i < reservedPrefix.length) {
            if (prefix.equals(reservedPrefix[i])) {
                return null;
            }
            ++i;
        }
        return prefix;
    }

    private static boolean isJSPRootElement(Node node) {
        return node.getNodeName().equals(NODENAME_JSPROOT);
    }
}

