/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.natureutils;

import com.ibm.etools.webtools.natureutils.INatureWeighted;
import com.ibm.etools.webtools.natureutils.NatureWeights;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class NatureWeightedUtil {
    public static final int NO_WEIGHT = -1;
    public static final int MIN_WEIGHT = 0;
    public static final int MAX_WEIGHT = 100;
    public static final int DEFAULT_WEIGHT = 0;
    public static final String NatureElementId = "nature";
    public static final String NatureIdAttribute = "natureId";
    public static final String WeightAttribute = "weight";

    public static void readNatureWeights(INatureWeighted weighted, IConfigurationElement element) {
        NatureWeights weights = weighted.getNatureWeights();
        IConfigurationElement[] natureElements = element.getChildren(NatureElementId);
        int i = 0;
        while (i < natureElements.length) {
            IConfigurationElement natureElement = natureElements[i];
            String natureId = natureElement.getAttributeAsIs(NatureIdAttribute);
            if (natureId != null) {
                int weight = 0;
                String weightString = natureElement.getAttributeAsIs(WeightAttribute);
                if (weightString != null) {
                    try {
                        weight = Integer.parseInt(weightString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    weight = Math.min(Math.max(weight, 0), 100);
                }
                weights.put(natureId, weight);
            }
            ++i;
        }
    }

    public static INatureWeighted getHeaviest(Collection weighteds, IProject project) {
        INatureWeighted heaviest = null;
        int heaviestWeight = -1;
        for (INatureWeighted weighted : weighteds) {
            int weight = NatureWeightedUtil.getWeight(weighted, project);
            if (weight <= heaviestWeight) continue;
            heaviestWeight = weight;
            heaviest = weighted;
        }
        return heaviest;
    }

    public static boolean hasWeight(INatureWeighted weighted, IProject project) {
        String[] natureIds = NatureWeightedUtil.getNatureIds(project);
        NatureWeights weights = weighted.getNatureWeights();
        int i = 0;
        while (i < natureIds.length) {
            if (weights.containsNature(natureIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int getWeight(INatureWeighted weighted, IProject project) {
        int maxWeight = -1;
        String[] natureIds = NatureWeightedUtil.getNatureIds(project);
        NatureWeights weights = weighted.getNatureWeights();
        int i = 0;
        while (i < natureIds.length) {
            int weight = weights.get(natureIds[i]);
            if (weight > maxWeight) {
                maxWeight = weight;
            }
            ++i;
        }
        return maxWeight;
    }

    private static String[] getNatureIds(IProject project) {
        if (project != null) {
            try {
                return project.getDescription().getNatureIds();
            }
            catch (CoreException coreException) {}
        }
        return new String[0];
    }
}

