/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webpage.wizard.internal.contributions;

import com.ibm.etools.webtools.expressions.EnablementExpressionFactory;
import com.ibm.etools.webtools.webpage.core.internal.contributions.RegistryReaderUtil;
import com.ibm.etools.webtools.webpage.core.internal.expressions.ForbiddenElementHandler;
import com.ibm.etools.webtools.webpage.core.internal.expressions.RequiredElementHandler;
import com.ibm.etools.webtools.webpage.wizard.internal.contributions.AdvancedOptionDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class ContributionRegistry {
    private static final String ADVANCED_OPTION_PAGES_EXT_POINT = "com.ibm.etools.webtools.webpage.ui.AdvancedOptionPages";
    private List advancedOptionDescriptors = null;
    private static ContributionRegistry instance;

    public ContributionRegistry() {
        instance = this;
    }

    public static ContributionRegistry getDefault() {
        if (instance == null) {
            instance = new ContributionRegistry();
            instance.parseContributors();
        }
        return instance;
    }

    private void parseContributors() {
        this.advancedOptionDescriptors = this.parseAdvancedOptions();
    }

    public List getAdvancedOptionDescriptors() {
        return this.advancedOptionDescriptors;
    }

    private List parseAdvancedOptions() {
        ArrayList<AdvancedOptionDescriptor> advancedOptionContribs = new ArrayList<AdvancedOptionDescriptor>();
        IExtension[] extensions = RegistryReaderUtil.getExtensions((String)ADVANCED_OPTION_PAGES_EXT_POINT);
        int i = 0;
        while (i < extensions.length) {
            IExtension currentExtension = extensions[i];
            if (currentExtension.isValid()) {
                IConfigurationElement[] configElements = currentExtension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement currentElement = configElements[j];
                    AdvancedOptionDescriptor currentContrib = new AdvancedOptionDescriptor(currentElement);
                    ContributionRegistry.processEnablement(currentContrib, currentElement);
                    advancedOptionContribs.add(currentContrib);
                    ++j;
                }
            }
            ++i;
        }
        return advancedOptionContribs;
    }

    private static void processEnablement(AdvancedOptionDescriptor currentContrib, IConfigurationElement configElement) {
        ElementHandler[] handlers = new ElementHandler[]{new RequiredElementHandler(), new ForbiddenElementHandler(), ElementHandler.getDefault()};
        Expression enablementExpression = EnablementExpressionFactory.createEnablementExpression((IConfigurationElement)configElement, (ElementHandler[])handlers);
        if (enablementExpression != null) {
            currentContrib.addEnablementExpression(enablementExpression);
        }
    }
}

