/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webpage.wizard.internal.advancedoptions.providers;

import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webtools.flatui.SnappyTableViewer;
import com.ibm.etools.webtools.taglib.TaglibRecordWrapper;
import com.ibm.etools.webtools.webpage.ui.AdvancedOptionCompositeProvider;
import com.ibm.etools.webtools.webpage.wizard.internal.nls.Messages;
import com.ibm.etools.webtools.wizards.taglibwizard.AddTagLibsDialog;
import com.ibm.etools.webtools.wizards.util.FocusTextCellEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class TaglibsOptionCompositeProvider
extends AdvancedOptionCompositeProvider
implements ISelectionChangedListener,
Listener {
    private Shell shell;
    protected SnappyTableViewer wtTagLibViewer;
    protected Button fAddButton;
    protected Button fRemoveButton;
    protected IStructuredContentProvider wtContentProvider;
    protected ITableLabelProvider wtLabelProvider;
    protected ICellModifier wtCellModifier;

    public Composite getContents(Composite parent) {
        this.shell = parent.getShell();
        Composite baseComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        baseComposite.setLayout((Layout)layout);
        baseComposite.setLayoutData((Object)new GridData(768));
        this.wtTagLibViewer = new SnappyTableViewer(new Table(baseComposite, 67586));
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, false));
        this.wtTagLibViewer.getTable().setLayout((Layout)tlayout);
        GridData data = new GridData(768);
        data.heightHint = 160;
        this.wtTagLibViewer.getTable().setLayoutData((Object)data);
        this.wtTagLibViewer.getTable().setHeaderVisible(true);
        this.wtTagLibViewer.getTable().setLinesVisible(false);
        this.wtTagLibViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.wtTagLibViewer.setInput((Object)this.model);
        TableColumn tc1 = new TableColumn(this.wtTagLibViewer.getTable(), 0);
        tc1.setText(Messages.TaglibsOptionCompositeProvider_Prefix);
        tc1.setResizable(true);
        tc1.setWidth(30);
        TableColumn tc2 = new TableColumn(this.wtTagLibViewer.getTable(), 0);
        tc2.setText("URI");
        tc2.setResizable(true);
        tc2.setWidth(60);
        this.wtTagLibViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.wtTagLibViewer.setCellEditors(new CellEditor[]{new FocusTextCellEditor((Composite)this.wtTagLibViewer.getTable()), new FocusTextCellEditor((Composite)this.wtTagLibViewer.getTable())});
        this.wtTagLibViewer.setColumnProperties(new String[]{"1", "2"});
        this.wtTagLibViewer.setCellModifier(this.getCellModifier());
        this.wtTagLibViewer.getTable().addControlListener((ControlListener)new ControlAdapter(){
            boolean fResized = false;

            public void controlResized(ControlEvent e) {
                if (!this.fResized && e.widget instanceof Table) {
                    final Table table = (Table)e.widget;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (table != null && !table.isDisposed()) {
                                Point size = table.getSize();
                                if (size.x > 4) {
                                    this.setResized();
                                    int newSize = (size.x - 4) / 3;
                                    TableColumn column = table.getColumn(0);
                                    if (column != null && !column.isDisposed()) {
                                        column.setWidth(newSize);
                                    }
                                    if ((column = table.getColumn(1)) != null && !column.isDisposed()) {
                                        column.setWidth(newSize * 2);
                                    }
                                }
                            }
                        }
                    });
                }
            }

            public void setResized() {
                this.fResized = true;
            }
        });
        Composite buttonGroup = new Composite(baseComposite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonGroup.setLayout((Layout)buttonLayout);
        GridData buttonGroupLayout = new GridData(2);
        buttonGroup.setLayoutData((Object)buttonGroupLayout);
        GridData buttonstyle1 = new GridData(768);
        this.fAddButton = new Button(buttonGroup, 0);
        this.fAddButton.setLayoutData((Object)buttonstyle1);
        this.fAddButton.addListener(13, (Listener)this);
        this.fAddButton.setText(Messages.TaglibsOptionCompositeProvider_Add);
        this.fRemoveButton = new Button(buttonGroup, 0);
        GridData buttonstyle3 = new GridData(768);
        this.fRemoveButton.setLayoutData((Object)buttonstyle3);
        this.fRemoveButton.addListener(13, (Listener)this);
        this.fRemoveButton.setText(Messages.TaglibsOptionCompositeProvider_Remove);
        this.wtTagLibViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateButtonStates();
        return baseComposite;
    }

    @Override
    public boolean shouldShow(IDataModel model) {
        boolean shouldShow = false;
        if (model.getStringProperty("IWebPageDataModelProperties.PAGE_TYPE").equals("DYNAMIC")) {
            ITemplateDescriptor template = (ITemplateDescriptor)model.getProperty("IWebPageDataModelProperties.TEMPLATE");
            shouldShow = template.getCategory() == 0;
        }
        return shouldShow;
    }

    @Override
    public void doDispose() {
        this.wtLabelProvider.dispose();
    }

    protected IStructuredContentProvider getContentProvider() {
        if (this.wtContentProvider == null) {
            this.wtContentProvider = new IStructuredContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    IDataModel model = (IDataModel)inputElement;
                    List taglibs = (List)model.getProperty("IJSPWebPageDataModelProperties.TAGLIBS");
                    return taglibs.toArray();
                }
            };
        }
        return this.wtContentProvider;
    }

    protected ITableLabelProvider getLabelProvider() {
        if (this.wtLabelProvider == null) {
            class TagLibInfoLabelProvider
            extends LabelProvider
            implements ITableLabelProvider {
                public String getColumnText(Object element, int columnIndex) {
                    String result = null;
                    TaglibRecordWrapper taglibWrapper = (TaglibRecordWrapper)element;
                    switch (columnIndex) {
                        case 0: {
                            result = taglibWrapper.getPrefix() != null ? taglibWrapper.getPrefix() : "";
                            break;
                        }
                        case 1: {
                            result = taglibWrapper.getURI();
                        }
                    }
                    return result;
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }
            }
            this.wtLabelProvider = new TagLibInfoLabelProvider();
        }
        return this.wtLabelProvider;
    }

    protected ICellModifier getCellModifier() {
        if (this.wtCellModifier == null) {
            this.wtCellModifier = new ICellModifier(){

                public boolean canModify(Object element, String property) {
                    return property.equals("1");
                }

                public Object getValue(Object element, String property) {
                    String result = "";
                    TaglibRecordWrapper taglibWrapper = (TaglibRecordWrapper)element;
                    if (property.equals("1")) {
                        result = taglibWrapper.getPrefix();
                    } else if (property.equals("2")) {
                        result = taglibWrapper.getURI();
                    }
                    return result;
                }

                public void modify(Object element, String property, Object value) {
                    TableItem item = (TableItem)element;
                    TaglibRecordWrapper taglibWrapper = (TaglibRecordWrapper)item.getData();
                    String input = (String)value;
                    if (property.equals("1")) {
                        if (input == null) {
                            input = "";
                        }
                        taglibWrapper.overrideDefaultPrefix(input);
                        item.setText(0, input);
                    }
                    IDataModel model = (IDataModel)TaglibsOptionCompositeProvider.this.wtTagLibViewer.getInput();
                    model.notifyPropertyChange("IJSPWebPageDataModelProperties.TAGLIBS", 1);
                    TaglibsOptionCompositeProvider.this.wtTagLibViewer.update((Object)taglibWrapper, new String[]{"Prefix2"});
                }
            };
        }
        return this.wtCellModifier;
    }

    protected void handleAddButton() {
        IProject project = (IProject)this.model.getProperty("IWebPageCreationDataModelProperties.PROJECT");
        if (project != null) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            AddTagLibsDialog dialog = new AddTagLibsDialog(this.shell, component);
            dialog.setIsReadOnly(true);
            dialog.open();
            Object[] o = dialog.getResult();
            if (o != null) {
                List taglibs = (List)this.model.getProperty("IJSPWebPageDataModelProperties.TAGLIBS");
                int i = 0;
                while (i < o.length) {
                    TaglibRecordWrapper tagLibInfo = (TaglibRecordWrapper)o[i];
                    taglibs.add(tagLibInfo);
                    ++i;
                }
                this.model.setProperty("IJSPWebPageDataModelProperties.TAGLIBS", (Object)taglibs);
                this.model.notifyPropertyChange("IJSPWebPageDataModelProperties.TAGLIBS", 1);
                this.wtTagLibViewer.refresh();
            }
        }
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.fAddButton) {
            this.handleAddButton();
        } else if (widget == this.fRemoveButton) {
            this.handleRemoveButton();
        }
        this.updateButtonStates();
    }

    protected void handleRemoveButton() {
        StructuredSelection select = (StructuredSelection)this.wtTagLibViewer.getSelection();
        Iterator selIterator = select.iterator();
        while (selIterator.hasNext()) {
            List taglibs = (List)this.model.getProperty("IJSPWebPageDataModelProperties.TAGLIBS");
            TaglibRecordWrapper selected = (TaglibRecordWrapper)selIterator.next();
            taglibs.remove(selected);
            this.model.setProperty("IJSPWebPageDataModelProperties.TAGLIBS", (Object)taglibs);
        }
        this.model.notifyPropertyChange("IJSPWebPageDataModelProperties.TAGLIBS", 1);
        this.wtTagLibViewer.refresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.wtTagLibViewer) {
            this.updateButtonStates();
        }
    }

    protected void updateButtonStates() {
        if (this.wtTagLibViewer != null) {
            IStructuredSelection selection = (IStructuredSelection)this.wtTagLibViewer.getSelection();
            this.fRemoveButton.setEnabled(selection.size() > 0);
        }
    }

    protected void whyIsPageNotComplete() {
    }

    @Override
    public List getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("IJSPWebPageDataModelProperties.TAGLIBS");
        return propertyNames;
    }
}

