/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webpage.wizard.internal.advancedoptions.providers;

import com.ibm.etools.common.ui.presentation.FilteredFileSelectionDialog;
import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webtools.webpage.core.internal.util.ProjectFacetsUtil;
import com.ibm.etools.webtools.webpage.ui.AdvancedOptionCompositeProvider;
import com.ibm.etools.webtools.webpage.ui.internal.WebPageGenUIPlugin;
import com.ibm.etools.webtools.webpage.wizard.internal.nls.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class CSSOptionCompositeProvider
extends AdvancedOptionCompositeProvider
implements Listener,
IDataModelListener,
SelectionListener {
    Button wtAddStyleSheetButton;
    Button wtRemoveStyleSheetButton;
    Button wtUpStyleSheetButton;
    Button wtDownStyleSheetButton;
    org.eclipse.swt.widgets.List wtStyleSheetViewer;
    private Image fUpImage;
    private Image fDownImage;
    private Shell shell;
    private List enabledWidgets;

    public Composite getContents(Composite parent) {
        this.shell = parent.getShell();
        this.enabledWidgets = new ArrayList();
        Composite baseComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        baseComposite.setLayout((Layout)layout);
        baseComposite.setLayoutData((Object)new GridData(768));
        Label wtStyleSheetLabel = new Label(baseComposite, 0);
        wtStyleSheetLabel.setText(Messages.CSSOptionCompositeProvider_Style_Sheets);
        wtStyleSheetLabel.setLayoutData((Object)new GridData(2));
        this.enabledWidgets.add(wtStyleSheetLabel);
        this.wtStyleSheetViewer = new org.eclipse.swt.widgets.List(baseComposite, 67588);
        this.synchHelper.synchList(this.wtStyleSheetViewer, "IWebPageDataModelProperties.STYLE_SHEETS", null);
        this.enabledWidgets.add(this.wtStyleSheetViewer);
        GridData data = new GridData(770);
        data.widthHint = 280;
        data.heightHint = 110;
        this.wtStyleSheetViewer.setLayoutData((Object)data);
        this.wtStyleSheetViewer.addSelectionListener((SelectionListener)this);
        Composite buttonComposite = new Composite(baseComposite, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setLayoutData((Object)new GridData(2));
        this.createAddRemoveButtons(buttonComposite);
        this.createUpDownButtons(buttonComposite);
        this.model.addListener((IDataModelListener)this);
        this.handleEnablementChange();
        return baseComposite;
    }

    private void createUpDownButtons(Composite buttonComposite) {
        this.wtUpStyleSheetButton = new Button(buttonComposite, 8);
        this.fUpImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)WebPageGenUIPlugin.getPluginId(), (String)"icons/size16/ArrowUp.gif").createImage();
        this.wtUpStyleSheetButton.setImage(this.fUpImage);
        this.wtUpStyleSheetButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.CSSOptionCompositeProvider_Move_selection_up;
                }
            }
        });
        this.wtUpStyleSheetButton.setToolTipText(Messages.CSSOptionCompositeProvider_Move_selection_up);
        this.wtUpStyleSheetButton.addListener(13, (Listener)this);
        this.wtUpStyleSheetButton.setLayoutData((Object)new GridData(768));
        this.enabledWidgets.add(this.wtUpStyleSheetButton);
        this.wtDownStyleSheetButton = new Button(buttonComposite, 8);
        this.fDownImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)WebPageGenUIPlugin.getPluginId(), (String)"icons/size16/ArrowDown.gif").createImage();
        this.wtDownStyleSheetButton.setImage(this.fDownImage);
        this.enabledWidgets.add(this.wtDownStyleSheetButton);
        this.wtDownStyleSheetButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.CSSOptionCompositeProvider_Move_selection_down;
                }
            }
        });
        this.wtDownStyleSheetButton.setToolTipText(Messages.CSSOptionCompositeProvider_Move_selection_down);
        this.wtDownStyleSheetButton.addListener(13, (Listener)this);
        this.wtDownStyleSheetButton.setLayoutData((Object)new GridData(768));
    }

    private void createAddRemoveButtons(Composite buttonComposite) {
        this.wtAddStyleSheetButton = new Button(buttonComposite, 8);
        this.wtAddStyleSheetButton.setText(Messages.CSSOptionCompositeProvider_Add);
        this.wtAddStyleSheetButton.addListener(13, (Listener)this);
        this.wtAddStyleSheetButton.setLayoutData((Object)new GridData(768));
        this.enabledWidgets.add(this.wtAddStyleSheetButton);
        this.wtRemoveStyleSheetButton = new Button(buttonComposite, 8);
        this.wtRemoveStyleSheetButton.setText(Messages.CSSOptionCompositeProvider_Remove);
        this.wtRemoveStyleSheetButton.addListener(13, (Listener)this);
        this.wtRemoveStyleSheetButton.setLayoutData((Object)new GridData(768));
        this.enabledWidgets.add(this.wtRemoveStyleSheetButton);
    }

    @Override
    public boolean shouldShow(IDataModel model) {
        boolean shouldShow = false;
        ITemplateDescriptor template = (ITemplateDescriptor)model.getProperty("IWebPageDataModelProperties.TEMPLATE");
        if (template.getCategory() == 0) {
            boolean isFragment = model.isProperty("IJSPWebPageDataModelProperties.GENERATE_FRAGMENT") && model.getBooleanProperty("IJSPWebPageDataModelProperties.GENERATE_FRAGMENT");
            shouldShow = !isFragment;
        }
        return shouldShow;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals(this.wtRemoveStyleSheetButton)) {
            this.handleRemoveButtonPressed();
        } else if (event.widget.equals(this.wtAddStyleSheetButton)) {
            this.handleAddButtonPressed();
        } else if (event.widget.equals(this.wtDownStyleSheetButton)) {
            this.handleDownButtonPressed();
        } else if (event.widget.equals(this.wtUpStyleSheetButton)) {
            this.handleUpButtonPressed();
        }
    }

    private void handleUpButtonPressed() {
        this.moveSelection(-1);
    }

    private void moveSelection(int steps) {
        List styleSheets = (List)this.model.getProperty("IWebPageDataModelProperties.STYLE_SHEETS");
        if (this.wtStyleSheetViewer.getSelection().length > 0 && styleSheets != null && styleSheets.size() > 0) {
            String selection = this.wtStyleSheetViewer.getSelection()[0];
            int oldIndex = this.wtStyleSheetViewer.getSelectionIndex();
            int newIndex = oldIndex + steps;
            if (newIndex >= 0 && newIndex < styleSheets.size()) {
                styleSheets.remove(oldIndex);
                styleSheets.add(newIndex, selection);
                this.model.notifyPropertyChange("IWebPageDataModelProperties.STYLE_SHEETS", 1);
                this.wtStyleSheetViewer.select(newIndex);
                this.wtStyleSheetViewer.notifyListeners(13, null);
            }
        }
    }

    private void handleDownButtonPressed() {
        this.moveSelection(1);
    }

    private void handleAddButtonPressed() {
        FilteredFileSelectionDialog dialog = new FilteredFileSelectionDialog(this.shell, Messages.CSSOptionCompositeProvider_Style_Sheet, Messages.CSSOptionCompositeProvider_Choose_a_css_file, new String[]{"css"}, true);
        IProject project = (IProject)this.model.getProperty("IWebPageCreationDataModelProperties.PROJECT");
        dialog.setInput((Object)project);
        dialog.open();
        Object[] filesList = dialog.getResult();
        if (filesList != null) {
            ArrayList newStyleSheets = new ArrayList();
            ArrayList currentStyleSheets = (ArrayList)this.model.getProperty("IWebPageDataModelProperties.STYLE_SHEETS");
            if (currentStyleSheets == null) {
                currentStyleSheets = new ArrayList();
            }
            int j = 0;
            while (j < currentStyleSheets.size()) {
                newStyleSheets.add(currentStyleSheets.get(j));
                ++j;
            }
            int i = 0;
            while (i < filesList.length) {
                IFile cssFile = (IFile)filesList[i];
                String rootRelativePathString = ProjectFacetsUtil.getRootRelativePath((IPath)cssFile.getFullPath(), (IProject)project).toString();
                if (!newStyleSheets.contains(rootRelativePathString)) {
                    newStyleSheets.add(rootRelativePathString);
                }
                ++i;
            }
            this.model.setProperty("IWebPageDataModelProperties.STYLE_SHEETS", newStyleSheets);
            this.wtStyleSheetViewer.deselectAll();
            this.wtStyleSheetViewer.notifyListeners(13, null);
        }
    }

    private void handleRemoveButtonPressed() {
        String[] selections = this.wtStyleSheetViewer.getSelection();
        if (selections != null && selections.length > 0) {
            String selectedStyleSheet = selections[0];
            List styleSheets = (List)this.model.getProperty("IWebPageDataModelProperties.STYLE_SHEETS");
            ArrayList<String> newStyleSheets = new ArrayList<String>();
            int i = 0;
            while (i < styleSheets.size()) {
                String current = (String)styleSheets.get(i);
                if (!current.equals(selectedStyleSheet)) {
                    newStyleSheets.add(current);
                }
                ++i;
            }
            this.model.setProperty("IWebPageDataModelProperties.STYLE_SHEETS", newStyleSheets);
            this.wtStyleSheetViewer.deselectAll();
            this.wtStyleSheetViewer.notifyListeners(13, null);
        }
    }

    @Override
    public void doDispose() {
        this.model.removeListener((IDataModelListener)this);
        if (this.fUpImage != null && !this.fUpImage.isDisposed()) {
            this.fUpImage.dispose();
        }
        if (this.fDownImage != null && !this.fDownImage.isDisposed()) {
            this.fDownImage.dispose();
        }
    }

    @Override
    public List getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("IWebPageDataModelProperties.STYLE_SHEETS");
        return names;
    }

    public void propertyChanged(DataModelEvent event) {
        if ("IWebPageDataModelProperties.STYLE_SHEETS".equals(event.getPropertyName())) {
            this.handleEnablementChange();
        }
    }

    private void handleEnablementChange() {
        boolean enabled = this.model.isPropertyEnabled("IWebPageDataModelProperties.STYLE_SHEETS");
        this.setWidgetsEnabled(enabled);
        if (enabled) {
            int selectionCount = this.wtStyleSheetViewer.getSelectionCount();
            boolean enableSelectionButtons = selectionCount > 0;
            this.wtUpStyleSheetButton.setEnabled(enableSelectionButtons);
            this.wtDownStyleSheetButton.setEnabled(enableSelectionButtons);
            this.wtRemoveStyleSheetButton.setEnabled(enableSelectionButtons);
        }
    }

    private void setWidgetsEnabled(boolean enabled) {
        for (Control current : this.enabledWidgets) {
            current.setEnabled(enabled);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.handleEnablementChange();
    }
}

