/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webpage.wizard.internal.advancedoptions;

import com.ibm.etools.webtools.slickui.SlickControlList;
import com.ibm.etools.webtools.slickui.SlickControlProvider;
import com.ibm.etools.webtools.slickui.validation.IValidationStateChangedListener;
import com.ibm.etools.webtools.slickui.validation.ValidationEvent;
import com.ibm.etools.webtools.webpage.core.internal.util.WebPageModelUtil;
import com.ibm.etools.webtools.webpage.ui.internal.IContextHelpIDs;
import com.ibm.etools.webtools.webpage.wizard.internal.advancedoptions.OptionListContentProvider;
import com.ibm.etools.webtools.webpage.wizard.internal.advancedoptions.StatusUtil;
import com.ibm.etools.webtools.webpage.wizard.internal.contributions.AdvancedOptionDescriptor;
import com.ibm.etools.webtools.webpage.wizard.internal.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AdvancedOptionsDialog
extends TitleAreaDialog
implements ISelectionChangedListener,
IValidationStateChangedListener {
    private IDataModel model;
    private AdvancedOptionDescriptor fSelectedOption;
    private SlickControlList fSlickComposite;

    public AdvancedOptionsDialog(Shell parentShell, IDataModel dataModel) {
        super(parentShell);
        this.setShellStyle(65584);
        this.model = dataModel;
    }

    protected void configureShell(Shell newShell) {
        String dialogTitle = Messages.AdvancedOptionsDialog_dialog_title;
        String fileName = WebPageModelUtil.getPrettyFileName((IDataModel)this.model);
        if (fileName != null && !fileName.equals("")) {
            dialogTitle = String.valueOf(dialogTitle) + " - " + fileName;
        }
        newShell.setText(dialogTitle);
        newShell.setMinimumSize(550, 400);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, IContextHelpIDs.WEBPAGE_WIZARD_OPTIONS);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Label horizontalRule = new Label(parent, 258);
        horizontalRule.setLayoutData((Object)new GridData(768));
        Composite baseComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        baseComposite.setLayout((Layout)layout);
        baseComposite.setLayoutData((Object)new GridData(1808));
        this.fSlickComposite = new SlickControlList(baseComposite, null);
        this.fSlickComposite.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fSlickComposite.addValidationStateChangedListener((IValidationStateChangedListener)this);
        this.fSlickComposite.setContentProvider((IStructuredContentProvider)new OptionListContentProvider());
        this.fSlickComposite.setInput((Object)this.model);
        return baseComposite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        if (id == 0) {
            return super.createButton(parent, id, Messages.AdvancedOptionsDialog_Close, defaultButton);
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource().equals(this.fSlickComposite)) {
            this.fSelectedOption = (AdvancedOptionDescriptor)((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
            this.setTitle(this.fSelectedOption.getTitle());
            this.setMessage(this.fSelectedOption.getDescription());
            this.validateSelection();
        }
    }

    private void validateSelection() {
        if (this.fSelectedOption != null) {
            SlickControlProvider provider = this.fSelectedOption.getControlProvider();
            IStatus status = provider.getValidationState();
            this.setStatus(status);
        }
    }

    private void setStatus(IStatus selectionStatus) {
        IStatus overallStatus = this.fSlickComposite.getValidationState();
        if (overallStatus.getSeverity() != 4) {
            this.setCloseEnabled(true);
        } else {
            this.setCloseEnabled(false);
        }
        if (!selectionStatus.isOK()) {
            String message = StatusUtil.getMostSevereMessage(selectionStatus);
            if (selectionStatus.getSeverity() == 4) {
                this.setErrorMessage(message);
            } else {
                this.setErrorMessage(null);
                this.setMessage(message, selectionStatus.getSeverity());
            }
        } else {
            this.setErrorMessage(null);
            this.setMessage(this.fSelectedOption.getDescription());
        }
    }

    private void setCloseEnabled(boolean enabled) {
        Button closeButton = this.getButton(0);
        if (closeButton != null) {
            closeButton.setEnabled(enabled);
        }
    }

    protected void okPressed() {
        this.fSlickComposite.dispose();
        super.okPressed();
    }

    protected void handleShellCloseEvent() {
    }

    public void validateStateChanged(ValidationEvent event) {
        this.validateSelection();
    }
}

