/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webpage.wizard.internal;

import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webpage.template.selection.ui.TemplateTreeContentProvider;
import com.ibm.etools.webpage.template.selection.ui.TemplateTreeNode;
import com.ibm.etools.webtools.webpage.core.internal.WebPageGenCorePlugin;
import com.ibm.etools.webtools.webpage.core.internal.contributions.BasicTemplateDescriptor;
import com.ibm.etools.webtools.webpage.core.internal.contributions.PageGenerationContribRegistry;
import com.ibm.etools.webtools.webpage.core.internal.util.ProjectFacetsUtil;
import com.ibm.etools.webtools.webpage.wizard.internal.nls.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class BasicTemplateContentProvider
extends TemplateTreeContentProvider {
    private final TemplateTreeNode basicNode = TemplateTreeNode.createCategory((String)Messages.TemplateTreeContentProvider_Basic_Templates);

    public Object[] getElements(Object inputElement) {
        Object[] superElements = super.getElements(inputElement);
        Object[] myElements = new Object[superElements.length + 1];
        List basicTemplates = this.collectValidBasicTemplates(this.project);
        this.basicNode.clearChildren();
        for (BasicTemplateDescriptor current : basicTemplates) {
            TemplateTreeNode currentNode = new TemplateTreeNode();
            currentNode.setTemplateDescriptor((ITemplateDescriptor)current);
            this.leafNodes.add(currentNode);
            this.basicNode.addChild(currentNode);
        }
        myElements[0] = this.basicNode;
        int i = 0;
        while (i < superElements.length) {
            myElements[i + 1] = superElements[i];
            ++i;
        }
        return myElements;
    }

    protected List collectValidBasicTemplates(IProject project) {
        PageGenerationContribRegistry templateRegistry = WebPageGenCorePlugin.getDefault().getContribRegistry();
        List basicTemplates = templateRegistry.getBasicTemplates();
        ArrayList<ITemplateDescriptor> allEnabledTempaltes = new ArrayList<ITemplateDescriptor>();
        if (project != null) {
            for (ITemplateDescriptor currentDesc : basicTemplates) {
                boolean isValid = true;
                if (currentDesc.getCategory() == 0) {
                    BasicTemplateDescriptor basicDesc = (BasicTemplateDescriptor)currentDesc;
                    isValid = basicDesc.isEnabled(project);
                } else if (ProjectFacetsUtil.isStaticWeb((IProject)project)) {
                    isValid = currentDesc.getPageType().equals("STATIC");
                }
                if (!isValid) continue;
                allEnabledTempaltes.add(currentDesc);
            }
        }
        return allEnabledTempaltes;
    }
}

