/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webpage.wizard;

import com.ibm.etools.webtools.webpage.core.internal.model.WebPageCreationDataModelProvider;
import com.ibm.etools.webtools.webpage.core.internal.util.ProjectFacetsUtil;
import com.ibm.etools.webtools.webpage.core.internal.util.WebPageModelUtil;
import com.ibm.etools.webtools.webpage.ui.internal.WebPageGenUIPlugin;
import com.ibm.etools.webtools.webpage.wizard.internal.NewWebPageWizardPage;
import com.ibm.etools.webtools.webpage.wizard.internal.nls.Messages;
import com.ibm.etools.webtools.wizards.WebtoolsWizardsPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.internal.provider.J2EEItemProvider;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class NewWebPageWizard
extends DataModelWizard
implements INewWizard,
IExecutableExtension {
    private static final String IRESOURCE_CLASS_NAME = "org.eclipse.core.resources.IResource";
    private IStructuredSelection selection;
    private boolean openEditor = true;

    public NewWebPageWizard() {
        this.init();
    }

    public NewWebPageWizard(IDataModel model) {
        super(model);
        this.init();
    }

    public void setOpenEditorAfterCreation(boolean shouldOpen) {
        this.openEditor = shouldOpen;
    }

    protected void init() {
        this.setWindowTitle(Messages.NewWebPageWizard_wizard_title);
        this.setDefaultPageImageDescriptor(WebPageGenUIPlugin.getImageDescriptor("icons/wizban/newhfile_wiz.gif"));
        this.setHelpAvailable(false);
        this.setForcePreviousAndNextButtons(false);
        this.setNeedsProgressMonitor(true);
    }

    protected void doAddPages() {
        this.addPage((IWizardPage)new NewWebPageWizardPage(this.getDataModel(), "main"));
        this.restorePersistentProperties();
    }

    public String getNextPage(String currentPageName, String expectedNextPageName) {
        if (currentPageName == null) {
            return "main";
        }
        return null;
    }

    public String getPreviousPage(String currentPageName, String expectedPreviousPageName) {
        return null;
    }

    protected IDataModelProvider getDefaultProvider() {
        Object context = null;
        if (this.selection != null) {
            context = this.selection.getFirstElement();
        }
        WebPageCreationDataModelProvider provider = new WebPageCreationDataModelProvider(context);
        return provider;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IWorkbenchWindow window;
        IResource resource = this.getResourceFromSelection(selection);
        if (resource == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            ISelection projExplorerSelection = window.getSelectionService().getSelection("com.ibm.etools.ui.navigator.SDExplorer");
            resource = this.getResourceFromSelection((IStructuredSelection)projExplorerSelection);
        }
        if (resource != null) {
            this.selection = new StructuredSelection((Object)resource);
        }
    }

    private IResource getResourceFromSelection(IStructuredSelection selection) {
        IProject resource = null;
        if (selection != null) {
            Object context = selection.getFirstElement();
            if (context instanceof J2EEItemProvider) {
                J2EEItemProvider provider = (J2EEItemProvider)context;
                context = provider.getParent();
            }
            if (context instanceof WebApp) {
                WebApp webApp = (WebApp)context;
                resource = ProjectUtilities.getProject((EObject)webApp);
            } else if (context instanceof IResource) {
                resource = (IResource)context;
            } else if (context != null) {
                IAdapterManager adapterManager;
                if (context instanceof IAdaptable) {
                    resource = (IResource)((IAdaptable)context).getAdapter(IResource.class);
                }
                if (resource == null && (adapterManager = Platform.getAdapterManager()) != null && adapterManager.hasAdapter(context, IRESOURCE_CLASS_NAME)) {
                    resource = (IResource)adapterManager.getAdapter(context, IRESOURCE_CLASS_NAME);
                }
            }
            if (resource != null && !ProjectFacetsUtil.isWebProject((IProject)resource.getProject())) {
                resource = null;
            }
        }
        return resource;
    }

    protected void restorePersistentProperties() {
        IDataModel model = this.getDataModel();
        WebPageModelUtil.getPropertyStore().restoreProperties(model);
        if (model.isPropertySet("IWebPageCreationDataModelProperties.PROJECT")) {
            IProject project = (IProject)model.getProperty("IWebPageCreationDataModelProperties.PROJECT");
            WebPageModelUtil.getPropertyStore().restoreProjectProperties(model, project);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    protected void postPerformFinish() throws InvocationTargetException {
        if (this.openEditor) {
            this.openFilesInEditor();
        }
        this.savePersistentProperties();
    }

    protected void savePersistentProperties() {
        IDataModel model = this.getDataModel();
        IProject project = (IProject)model.getProperty("IWebPageCreationDataModelProperties.PROJECT");
        WebPageModelUtil.getPropertyStore().storeProperties(model, project);
    }

    private void openFilesInEditor() {
        IDataModel model = this.getDataModel();
        final IFile file = (IFile)model.getProperty("IWebPageCreationDataModelProperties.FILE");
        if (file != null && file.exists()) {
            Display display;
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWindow != null) {
                BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)activeWindow);
            }
            if ((display = this.getShell().getDisplay()) != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IWorkbenchWindow workbenchWindow = WebtoolsWizardsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                            IDE.openEditor((IWorkbenchPage)workbenchWindow.getActivePage(), (IFile)file, (boolean)true);
                        }
                        catch (PartInitException partInitException) {}
                    }
                });
            }
        }
    }

    protected boolean runForked() {
        return true;
    }
}

