/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.webservice.jaxws;

import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.AbstractServiceFinder;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import com.ibm.etools.webtools.services.internal.util.RuntimeUtilities;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceData;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class WebServiceJaxWSFinder
extends AbstractServiceFinder {
    WebServiceFinder fParentFinder;

    WebServiceJaxWSFinder(WebServiceFinder finder, IServiceInvocationGenerator generator) {
        super(generator);
        this.fParentFinder = finder;
    }

    WebServiceData createService(IJavaProject jProject, IType proxy, IType serviceInterface, String name) throws JavaModelException {
        WebServiceData service = new WebServiceData(jProject, proxy, serviceInterface, this.getServiceGenerator());
        IMethod[] interfaceMethods = serviceInterface.getMethods();
        if (interfaceMethods != null) {
            int i = 0;
            while (i < interfaceMethods.length) {
                IMethod imethod = interfaceMethods[i];
                String methodName = imethod.getElementName();
                if (!methodName.endsWith("Async")) {
                    IMethod classMethod = proxy.getMethod(imethod.getElementName(), imethod.getParameterTypes());
                    if (classMethod != null) {
                        service.addMethod(classMethod, false);
                    } else {
                        service = null;
                        break;
                    }
                }
                ++i;
            }
        }
        return service;
    }

    @Override
    public List<ServiceData> getServices(IProject project, IProgressMonitor monitor) {
        return this.getServices(project, null, monitor);
    }

    @Override
    public List<ServiceData> getServices(IProject project, IServiceListener listener, IProgressMonitor monitor) {
        ArrayList<ServiceData> allServices = new ArrayList<ServiceData>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)root);
        try {
            try {
                ITypeHierarchy clientHierarchy;
                IType[] clients;
                IType serviceClientBaseClass;
                javaModel.open(monitor);
                IJavaProject javaProject = javaModel.getJavaProject(project.getName());
                if (javaProject != null && (serviceClientBaseClass = javaProject.findType("javax.xml.ws.Service")) != null && (clients = (clientHierarchy = serviceClientBaseClass.newTypeHierarchy(javaProject, null)).getSubclasses(serviceClientBaseClass)) != null) {
                    int i = 0;
                    while (i < clients.length) {
                        IMethod[] methods;
                        int flags;
                        IType client = clients[i];
                        if (!client.isBinary() && !Flags.isAbstract((int)(flags = client.getFlags())) && Flags.isPublic((int)flags) && (methods = client.getMethods()) != null && methods.length > 0) {
                            ArrayList<IMethod> possiblePortMethods = new ArrayList<IMethod>(methods.length);
                            int j = 0;
                            while (j < methods.length) {
                                IMethod method = methods[j];
                                int methodFlags = method.getFlags();
                                if (Flags.isPublic((int)methodFlags) && !Flags.isAbstract((int)methodFlags) && !method.isConstructor() && !"V".equals(method.getReturnType()) && method.getParameterNames().length == 0) {
                                    possiblePortMethods.add(method);
                                }
                                ++j;
                            }
                            if (possiblePortMethods.size() > 0) {
                                IMethod[] portMethodCandidates = possiblePortMethods.toArray(new IMethod[possiblePortMethods.size()]);
                                List<ServiceData> services = this.getServices(client, portMethodCandidates);
                                allServices.addAll(services);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                try {
                    javaModel.close();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                javaModel.close();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return allServices;
    }

    @Override
    public List<ServiceData> getServices(IProject project, IServiceListener listener, Set<String> facetIds, IProgressMonitor monitor) {
        List<ServiceData> services = null;
        if (facetIds != null && (facetIds.contains("com.ibm.websphere.wsfp.web") || RuntimeUtilities.isTargetRuntimeWAS7(project))) {
            services = super.getServices(project, listener, facetIds, monitor);
        }
        return services;
    }

    protected List<ServiceData> getServices(IType type, IMethod[] methods) {
        ArrayList<ServiceData> services = new ArrayList<ServiceData>(methods.length);
        ICompilationUnit icu = type.getCompilationUnit();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        parser.setResolveBindings(true);
        IBinding[] bindings = parser.createBindings((IJavaElement[])methods, null);
        if (bindings != null) {
            IJavaProject jProject = type.getJavaProject();
            int i = 0;
            while (i < bindings.length) {
                IMethodBinding mBinding;
                IAnnotationBinding[] annotations;
                IBinding binding = bindings[i];
                if (binding instanceof IMethodBinding && (annotations = (mBinding = (IMethodBinding)binding).getAnnotations()) != null) {
                    int j = 0;
                    while (j < annotations.length) {
                        IMemberValuePairBinding[] pairs;
                        IAnnotationBinding annotation = annotations[j];
                        String annoName = annotation.getName();
                        if ("WebEndpoint".equals(annoName) && (pairs = annotation.getDeclaredMemberValuePairs()) != null && pairs.length > 0) {
                            int k = 0;
                            while (k < pairs.length) {
                                ITypeBinding returnType;
                                String value;
                                IMemberValuePairBinding pair = pairs[k];
                                if ("name".equals(pair.getName()) && (value = (String)pair.getValue()) != null && (returnType = mBinding.getReturnType()).getKind() == 2) {
                                    IPackageBinding packageBinding = returnType.getPackage();
                                    String proxyName = String.valueOf(packageBinding.getName()) + "." + value + "Proxy";
                                    try {
                                        IType serviceInterface;
                                        WebServiceData service;
                                        IType proxy = jProject.findType(proxyName);
                                        if (proxy != null && (service = this.createService(jProject, proxy, serviceInterface = (IType)returnType.getJavaElement(), value)) != null) {
                                            services.add(service);
                                        }
                                    }
                                    catch (JavaModelException e) {
                                        e.printStackTrace();
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return services;
    }

    @Override
    public void removeListener(IServiceListener listener, IProject project) {
    }
}

